/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.ui.RestTemplatePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class RestWizTemplatePanel
extends DefaultTraversablePanel {
    private RestTemplatePanel _templatePanel;
    private RestTemplate _template;

    private void init(TraversableContext traversableContext) {
        this._template = (RestTemplate)traversableContext.get("REST_TEMPLATE");
        this._templatePanel = new RestTemplatePanel(this._template);
        this._templatePanel.setModuleURIExample(this.getModuleURIPrefix(traversableContext));
        this._templatePanel.setExistingURIs((List)traversableContext.get("REST_EXISTING_URIS"));
        this.setLayout(new GridBagLayout());
        this.add(this._templatePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    private String getModuleURIPrefix(TraversableContext traversableContext) {
        String string;
        RestModule restModule = (RestModule)traversableContext.get("REST_MODULE");
        String string2 = string = restModule != null ? restModule.getURIPrefix() : (String)traversableContext.get("REST_MODULE_URI");
        if (string == null) {
            string = RestArb.getString("URI_MODULE_DEFAULT");
        }
        return string;
    }

    public void onEntry(TraversableContext traversableContext) {
        if (this._templatePanel == null) {
            this.init(traversableContext);
        } else {
            this._templatePanel.addListeners();
            this._templatePanel.setModuleURIExample(this.getModuleURIPrefix(traversableContext));
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1 && this._templatePanel != null) {
            if (!this._templatePanel.validInfo()) {
                throw new TraversalException(this._templatePanel.getErrorMessage());
            }
            this._template = this._templatePanel.getValues();
            traversableContext.put("REST_TEMPLATE", (Object)this._template);
            this._templatePanel.removeListeners();
        }
    }

    public Object getExitTransition() {
        return "Transition.Handler";
    }
}

