/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.utils.RestJSONUtil;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.ZipOutputHandler;
import oracle.ide.Ide;
import oracle.ide.net.URLFilter;

public class RestSaveAdmin {
    private static File _lastUrl;
    private ZipOutputHandler _zipOut;
    private List<String> _entryNames;

    public static void save() {
        List<RestModule> list = RestUtils.getModules();
        List<RestSecurity> list2 = RestUtils.getPrivileges();
        if (list != null && !list.isEmpty() || list2 != null && !list2.isEmpty()) {
            RestSaveAdmin restSaveAdmin = new RestSaveAdmin();
            restSaveAdmin.saveAdministration(list, list2);
        }
    }

    protected boolean showSaveDialog() {
        if (_lastUrl == null) {
            _lastUrl = new File(this.getExportDirectory());
        }
        URLFileChooser uRLFileChooser = new URLFileChooser(_lastUrl);
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)RestUtils.ZIP_FILTER);
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setShowJarsAsDirs(false);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow(), RestArb.getString("SAVE_ADMINISTRATION"));
        if (n == 0) {
            int n2;
            String string = uRLFileChooser.getSelectedFile().toString();
            String string2 = string.substring(n2 = string.lastIndexOf(File.separator));
            _lastUrl = string2.lastIndexOf(".") > -1 ? uRLFileChooser.getSelectedFile() : new File(uRLFileChooser.getSelectedFile().toString() + ".zip");
            return true;
        }
        return false;
    }

    private String getExportDirectory() {
        String string = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
        if (string == null || string.isEmpty()) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAdministration(List<RestModule> list, List<RestSecurity> list2) {
        boolean bl;
        block6: {
            bl = false;
            try {
                if (this.showSaveDialog()) {
                    this.createZipFile();
                    this.formatModulesToXML(list);
                    this.formatPrivilegesToJSON(list2);
                    bl = true;
                    break block6;
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception exception) {
                Logger.severe(RestSaveAdmin.class, (String)exception.getMessage());
            }
            finally {
                this.closeFiles();
            }
        }
        return bl;
    }

    private void formatModulesToXML(List<RestModule> list) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this._zipOut != null) {
            for (RestModule restModule : list) {
                String string = this.getEntryName(restModule.getName(), ".xml");
                this._zipOut.openEntry(string);
                String string2 = RestXMLUtil.resourceModuletoXML(restModule);
                if (string2 != null) {
                    this._zipOut.writeEntryText(string2);
                }
                this._zipOut.closeEntry();
                this._entryNames.add(string);
            }
        } else {
            Logger.severe(RestSaveAdmin.class, (String)"Zip file is null");
        }
    }

    private void formatPrivilegesToJSON(List<RestSecurity> list) throws Exception {
        if (list == null || list.size() == 0) {
            return;
        }
        if (this._zipOut != null) {
            for (RestSecurity restSecurity : list) {
                String string = this.getEntryName(restSecurity.getName(), ".json");
                this._zipOut.openEntry(string);
                String string2 = RestJSONUtil.restPrivilegetoJSON(restSecurity);
                if (string2 != null) {
                    this._zipOut.writeEntryText(string2);
                }
                this._zipOut.closeEntry();
                this._entryNames.add(string);
            }
        } else {
            Logger.severe(RestSaveAdmin.class, (String)"Zip file is null");
        }
    }

    private boolean createZipFile() throws FileNotFoundException {
        if (_lastUrl != null) {
            this._zipOut = new ZipOutputHandler();
            this._zipOut.openZip(_lastUrl.getAbsolutePath());
            this._entryNames = new ArrayList<String>();
            return true;
        }
        return false;
    }

    private void closeFiles() {
        if (this._zipOut != null) {
            try {
                this._zipOut.closeZip();
            }
            catch (IOException iOException) {
                Logger.severe(RestSaveAdmin.class, (String)iOException.getMessage());
            }
        }
    }

    private String getEntryName(String string, String string2) {
        Object object;
        Object object2 = null;
        if (string != null && !this._entryNames.contains((String)(object = string.replaceAll("[\\\\/:\"*?<>|]+", "_")) + string2)) {
            object2 = object;
        }
        if (object2 == null) {
            object = new Random();
            int n = ((Random)object).nextInt(999999);
            n = Math.abs(n);
            object2 = "rest" + Integer.toString(n);
        }
        return object2 + string2;
    }
}

