/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.ui.RestTablePanel;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestResourceHandlerPanel
extends JPanel {
    private static final int MIN_SIZE = 0;
    private static final int MAX_SIZE = 10000;
    private static final int DEFAULT_PAGINATION_SIZE = 25;
    private JPanel _optionsPanel;
    private JPanel _pagePanel;
    private JLabel _methodLabel;
    private JLabel _sourceLabel;
    private JLabel _resultFormatLabel;
    private JComboBox _methodHandlers;
    private JComboBox _sourceType;
    private JCheckBox _secureAccess;
    private JLabel _dataFormatLabel;
    private JComboBox _dataFormat;
    private NumericSpinBox _pagination;
    private RestTablePanel _mimeTypes;
    private RestResourceHandler.HTTP_METHOD_TYPE _methodType;
    private RestResourceHandler _handler;
    private String _errMsg;
    private boolean _isSelectMethodHandlers;
    private String[] _handlerList;
    private String[] _sourceTypeList;
    private String[] _dataFormatList;
    private long _defaultModulePageSize;

    public RestResourceHandlerPanel(RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE) {
        this._methodType = hTTP_METHOD_TYPE;
        this.createPanel();
    }

    public RestResourceHandlerPanel(RestResourceHandler restResourceHandler) {
        if (restResourceHandler != null) {
            this._methodType = restResourceHandler.getMethodType();
        }
        if (this._methodType == null) {
            this._isSelectMethodHandlers = true;
            this._methodType = RestResourceHandler.HTTP_METHOD_TYPE.GET;
        }
        this._handler = restResourceHandler;
        this.createPanel();
    }

    private void createPanel() {
        this.initComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        if (this._isSelectMethodHandlers) {
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._methodHandlers, (String)RestArb.getString("METHOD"));
        } else {
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this._methodLabel, (String)RestArb.getString("METHOD"));
        }
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        if (this._isSelectMethodHandlers) {
            jPanel.add((Component)this._methodHandlers, new GridBagConstraints(1, n, 1, 1, 0.0, 0.1, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        } else {
            jPanel.add((Component)this._methodLabel, new GridBagConstraints(1, n, 1, 1, 0.0, 0.1, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        }
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(2, n, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)RestArb.getString("HANDLER"));
        JPanel jPanel2 = null;
        if (this._secureAccess.isVisible()) {
            ResourceUtils.resButton((AbstractButton)this._secureAccess, (String)RestArb.getString("SECURE_ACCESS"));
            jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)this._secureAccess, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
            UIUtils.makeTitledBorder((JComponent)jPanel2, (String)RestArb.getString("APEX"));
        }
        this._optionsPanel = this.getHandlerOptionsPanel();
        n = 0;
        this.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 0.1, 23, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this._optionsPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.5, 23, 1, new Insets(0, 8, 0, 0), 0, 0));
        if (this._secureAccess.isVisible()) {
            this.add((Component)jPanel2, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(10, 8, 0, 0), 0, 0));
        }
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 0.2, 0.2, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void initComponents() {
        this._optionsPanel = new JPanel(new GridBagLayout());
        this._handlerList = new String[RestResourceHandler.HTTP_METHOD_TYPE.values().length];
        int n = 0;
        for (RestResourceHandler.HTTP_METHOD_TYPE enum_ : RestResourceHandler.HTTP_METHOD_TYPE.values()) {
            this._handlerList[n++] = enum_.getNLS();
        }
        this._sourceTypeList = new String[RestResourceHandler.SOURCE_TYPE.values().length];
        n = 0;
        for (Enum enum_ : RestResourceHandler.SOURCE_TYPE.values()) {
            this._sourceTypeList[n++] = ((RestResourceHandler.SOURCE_TYPE)enum_).getNLS();
        }
        this._dataFormatList = new String[RestResourceHandler.FORMAT_TYPE.values().length];
        n = 0;
        for (Enum enum_ : RestResourceHandler.FORMAT_TYPE.values()) {
            this._dataFormatList[n++] = ((RestResourceHandler.FORMAT_TYPE)enum_).getNLS();
        }
        this._dataFormatLabel = new JLabel();
        if (this._isSelectMethodHandlers) {
            this._methodHandlers = new JComboBox<String>(this._handlerList);
            this._methodHandlers.setSelectedIndex(0);
        } else {
            this._methodLabel = new JLabel();
            this._methodLabel.setText(this._methodType.toString());
        }
        this._secureAccess = new JCheckBox();
        if (RestUtils.isAPEXRestfulServices()) {
            this._secureAccess.setVisible(true);
            this._secureAccess.setSelected(this._handler == null ? true : this._handler.isSecuredAccess());
        } else {
            this._secureAccess.setVisible(false);
        }
        if (this._methodType != null) {
            switch (this._methodType) {
                case GET: {
                    this.initGetOptions();
                    break;
                }
                case DELETE: {
                    this.initDeleteOptions();
                    break;
                }
                case POST: {
                    this.initPostOptions();
                    break;
                }
                case PUT: {
                    this.initPutOptions();
                }
            }
        }
    }

    private void initGetOptions() {
        this.assignSourceType();
        int n = 0;
        if (this._handler == null || this._handler.getSourceType() == null) {
            this._sourceType.setSelectedIndex(0);
        } else {
            n = this._handler.getSourceType().ordinal();
            this._sourceType.setSelectedIndex(n);
        }
        this._dataFormat = new JComboBox<String>(this._dataFormatList);
        if (this._handler == null || this._handler.getFormatType() == null) {
            this._dataFormat.setSelectedIndex(0);
        } else {
            n = this._handler.getFormatType().ordinal();
            this._dataFormat.setSelectedIndex(n);
        }
        this._pagination = new NumericSpinBox(0, 10000);
        long l = this._handler == null ? this._defaultModulePageSize : this._handler.getPaginationSize();
        this._pagination.setValue((Number)l);
        this.addListeners();
    }

    private void initDeleteOptions() {
        this.assignSourceType();
    }

    private void initPutOptions() {
        this.assignSourceType();
        this._mimeTypes = new RestTablePanel(RestArb.getString("MIME_TYPES"), null, this._handler != null ? this._handler.getMimeTypes() : null);
    }

    private void initPostOptions() {
        this.assignSourceType();
        this._mimeTypes = new RestTablePanel(RestArb.getString("MIME_TYPES"), null, this._handler != null ? this._handler.getMimeTypes() : null);
    }

    public void assignSourceType() {
        if (this._methodType == null) {
            return;
        }
        if (this._methodType.equals((Object)RestResourceHandler.HTTP_METHOD_TYPE.GET)) {
            this._sourceType = new JComboBox();
            this._sourceType = new JComboBox<String>(this._sourceTypeList);
        } else {
            this._sourceLabel = new JLabel();
            this._sourceLabel.setText(RestResourceHandler.SOURCE_TYPE.PLSQL.getNLS());
        }
    }

    public JPanel getGETOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this._resultFormatLabel = new JLabel(RestArb.getString("FORMAT_BINARY"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._sourceType, (String)RestArb.getString("SOURCE_TYPE"));
        ResourceUtils.resLabel((JLabel)this._dataFormatLabel, (Component)this._dataFormat, (String)RestArb.getString("DATA_FORMAT"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._pagination, (String)RestArb.getString("PAGINATION_SIZE"));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel2.add((Component)this._sourceType, new GridBagConstraints(1, n, 2, 1, 0.0, 0.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(2, n, 1, 1, 1.0, 1.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._dataFormatLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel3.add((Component)this._dataFormat, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel3.add((Component)this._resultFormatLabel, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel3.add(Box.createHorizontalGlue(), new GridBagConstraints(2, n, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)RestArb.getString("RESULTS_BORDER"));
        n = 0;
        this._pagePanel = new JPanel(new GridBagLayout());
        this._pagePanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        this._pagePanel.add((Component)this._pagination, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        if (this._handler != null && this._handler.getSourceType() != null && this._handler.getSourceType() == RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) {
            this._pagePanel.setVisible(false);
        } else {
            this._pagePanel.setVisible(true);
        }
        this.updateComponents();
        n = 0;
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 1.0, 0.1, 23, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._pagePanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getDELETEOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._sourceLabel, (String)StringUtils.stripMnemonic((String)RestArb.getString("SOURCE_TYPE")));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel2.add((Component)this._sourceLabel, new GridBagConstraints(1, n, 1, 1, 0.5, 1.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public JPanel getPUTOptionsPanel() {
        return this.getSourceAndMimeTypePanel();
    }

    public JPanel getPOSTOptionsPanel() {
        return this.getSourceAndMimeTypePanel();
    }

    public JPanel getSourceAndMimeTypePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._sourceLabel, (String)StringUtils.stripMnemonic((String)RestArb.getString("SOURCE_TYPE")));
        int n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel2.add((Component)this._sourceLabel, new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 23, 0, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)this._mimeTypes, new GridBagConstraints(0, n, 1, 5, 1.0, 1.0, 23, 1, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(0, 0, 8, 0), 0, 0));
        jPanel.add((Component)jPanel3, new GridBagConstraints(0, ++n, 1, 5, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void setDefaultModulePagination(long l) {
        if (this._pagination != null) {
            this._defaultModulePageSize = l;
            this._pagination.setValue((Number)this._defaultModulePageSize);
        }
    }

    public void addListeners() {
        if (this._isSelectMethodHandlers && this._methodHandlers != null) {
            this._methodHandlers.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    RestResourceHandlerPanel.this._methodType = RestResourceHandler.HTTP_METHOD_TYPE.values()[RestResourceHandlerPanel.this._methodHandlers.getSelectedIndex()];
                    RestResourceHandlerPanel.this.changeHandlerOptionsPanel();
                }
            });
        }
        this._sourceType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RestResourceHandlerPanel.this.updateComponents();
                RestResourceHandlerPanel.this._dataFormat.revalidate();
                RestResourceHandlerPanel.this._dataFormat.repaint();
                RestResourceHandlerPanel.this._resultFormatLabel.revalidate();
                RestResourceHandlerPanel.this._resultFormatLabel.repaint();
                RestResourceHandlerPanel.this._pagePanel.revalidate();
                RestResourceHandlerPanel.this._pagePanel.repaint();
            }
        });
    }

    private void updateComponents() {
        int n = this._sourceType.getSelectedIndex();
        RestResourceHandler.SOURCE_TYPE sOURCE_TYPE = RestResourceHandler.SOURCE_TYPE.values()[n];
        this._pagePanel.setVisible(sOURCE_TYPE != RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW);
        if (sOURCE_TYPE == RestResourceHandler.SOURCE_TYPE.QUERY || sOURCE_TYPE == RestResourceHandler.SOURCE_TYPE.COLLECTION_QUERY) {
            this._dataFormat.setVisible(true);
        } else {
            this._dataFormat.setVisible(false);
        }
        if (sOURCE_TYPE == RestResourceHandler.SOURCE_TYPE.QUERY || sOURCE_TYPE == RestResourceHandler.SOURCE_TYPE.COLLECTION_QUERY) {
            this._resultFormatLabel.setVisible(false);
        } else {
            this._resultFormatLabel.setVisible(true);
            if (sOURCE_TYPE == RestResourceHandler.SOURCE_TYPE.MEDIA_RESOURCE) {
                this._resultFormatLabel.setText(RestArb.getString("FORMAT_BINARY"));
            } else {
                this._resultFormatLabel.setText(RestArb.getString("FORMAT_JSON"));
            }
        }
    }

    public void removeListeners() {
        ItemListener[] itemListenerArray;
        if (this._isSelectMethodHandlers && this._methodHandlers != null) {
            for (ItemListener itemListener : itemListenerArray = this._methodHandlers.getItemListeners()) {
                this._methodHandlers.removeItemListener(itemListener);
            }
        }
        for (ItemListener itemListener : itemListenerArray = this._sourceType.getItemListeners()) {
            this._sourceType.removeItemListener(itemListener);
        }
    }

    private JPanel getHandlerOptionsPanel() {
        switch (this._methodType) {
            case GET: {
                this.initGetOptions();
                return this.getGETOptionsPanel();
            }
            case DELETE: {
                this.initDeleteOptions();
                return this.getDELETEOptionsPanel();
            }
            case POST: {
                this.initPostOptions();
                return this.getPOSTOptionsPanel();
            }
            case PUT: {
                this.initPutOptions();
                return this.getPUTOptionsPanel();
            }
        }
        return null;
    }

    private void changeHandlerOptionsPanel() {
        this.remove(this._optionsPanel);
        this._optionsPanel = this.getHandlerOptionsPanel();
        this.add((Component)this._optionsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 23, 1, new Insets(0, 8, 0, 0), 0, 0));
        this._optionsPanel.revalidate();
        this._optionsPanel.repaint();
    }

    public boolean updateValues(RestResourceHandler restResourceHandler) {
        this._handler = restResourceHandler;
        this._methodType = restResourceHandler.getMethodType();
        this._methodLabel.setText(restResourceHandler.getMethodType().getNLS());
        if (this._secureAccess.isVisible()) {
            this._secureAccess.setSelected(this._handler.isSecuredAccess());
        }
        if (this._methodType.equals((Object)RestResourceHandler.HTTP_METHOD_TYPE.GET)) {
            int n = this._handler.getSourceType() == null ? 0 : this._handler.getSourceType().ordinal();
            this._sourceType.setSelectedIndex(n);
            n = this._handler.getFormatType() == null ? 0 : this._handler.getFormatType().ordinal();
            this._dataFormat.setSelectedIndex(n);
            this._pagination.setValue((Number)this._handler.getPaginationSize());
        } else {
            this._sourceLabel.setText(RestResourceHandler.SOURCE_TYPE.PLSQL.getNLS());
            if (this._methodType.equals((Object)RestResourceHandler.HTTP_METHOD_TYPE.POST) || this._methodType.equals((Object)RestResourceHandler.HTTP_METHOD_TYPE.PUT)) {
                this._mimeTypes = new RestTablePanel(RestArb.getString("MIME_TYPES"), null, this._handler.getMimeTypes());
            }
        }
        return true;
    }

    public boolean validInfo() {
        return true;
    }

    public boolean isDuplicateRequiredField() {
        return false;
    }

    public RestResourceHandler getValues() {
        if (this._handler == null) {
            this._handler = new RestResourceHandler();
        }
        this._handler.setMethodType(this._methodType);
        if (this._secureAccess.isVisible()) {
            this._handler.setSecuredAccess(this._secureAccess.isSelected());
        }
        switch (this._methodType) {
            case GET: {
                int n = this._sourceType.getSelectedIndex();
                this._handler.setSourceType(RestResourceHandler.SOURCE_TYPE.values()[n]);
                n = this._dataFormat.getSelectedIndex();
                this._handler.setFormatType(RestResourceHandler.FORMAT_TYPE.values()[n]);
                if (this._handler.getSourceType() == RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) {
                    this._handler.setPaginationSize(0L);
                } else {
                    this._handler.setPaginationSize(this._pagination.getIntValue());
                }
                this._handler.setMimeTypes(null);
                break;
            }
            case DELETE: {
                this._handler.setSourceType(RestResourceHandler.SOURCE_TYPE.PLSQL);
                this._handler.setFormatType(null);
                break;
            }
            case POST: 
            case PUT: {
                this._handler.setSourceType(RestResourceHandler.SOURCE_TYPE.PLSQL);
                this._handler.setFormatType(null);
                this._handler.setMimeTypes(this._mimeTypes.getValues());
            }
        }
        return this._handler;
    }

    public RestResourceHandler getResourceHandler() {
        return this._handler;
    }

    public RestResourceHandler.HTTP_METHOD_TYPE getMethodType() {
        return this._methodType;
    }

    public String getErrorMessage() {
        return this._errMsg;
    }

    private void setErrorMessage(String string) {
        this._errMsg = string;
    }

    public JCheckBox getSecureAccessCheckBox() {
        return this._secureAccess;
    }
}

