/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.rest.RestArb;
import oracle.jdbc.OracleCallableStatement;

public class InstallDBUtils {
    private static final String SYS_USER = "SYS";
    private static final int MAX_VERSION_COMPARE = 3;
    private static final String APEX = "APEX";
    private static final String MIN_APEX_REST_VERSION = "4.2.0.0.0";
    private static final String GET_ORDS_VERSION_SQL = "select version from ords_metadata.ords_version";
    private static final String GET_ORDS_REGISTRY_SQL = "declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('ORDS') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('ORDS');\n  :reg_status  := sys.dbms_registry.status('ORDS');\nend;\n";
    private static final String GET_APEX_REGISTRY_SQL = "declare\nregistered varchar2(5) := 'false';\nreg_version varchar2(30);\nreg_status  varchar2(30);\nbegin\n  if sys.dbms_registry.is_in_registry('APEX') then\n    :registered := 'true';\n  end if;\n  :reg_version := sys.dbms_registry.version('APEX');\n  :reg_status  := sys.dbms_registry.status('APEX');\nend;\n";
    private static final String GET_APEX_USERS_SQL = "select username from sys.dba_users where username in ('APEX_LISTENER','APEX_REST_PUBLIC_USER')";
    private static final String GET_ORDS_USERS_SQL = "select username from sys.dba_users where username in ('ORDS_METADATA','ORDS_PUBLIC_USER')";
    private static final String GET_SYSDBA_PRIV_SQL = "select privilege from sys.session_privs where privilege = 'SYSDBA'";
    private static final String IS_CDB_ROOT_SQL = "declare\nl_is_cdb  VARCHAR2(10) := 'NO';\nl_is_root VARCHAR2(10) := 'false';\nbegin\n  if (sys.dbms_db_version.VERSION >= 12) then\n    select cdb into l_is_cdb from v$database;\n  if (l_is_cdb = 'YES') and (sys_context('USERENV','CON_NAME') = 'CDB$ROOT') then\n     :l_is_root := 'true';\n     end if;\n  end if;\nend;";
    private static HashMap<String, String[]> lookUp_Version = new HashMap();
    private static Logger logger = Logger.getLogger(InstallDBUtils.class.getName());

    public static String getUrl(String string, String string2, String string3, String string4) {
        String string5 = !NullOrEmpty.nullOrEmpty((CharSequence)string4) ? "jdbc:oracle:thin:@//" + string + ":" + string2 + "/" + string4 : "jdbc:oracle:thin:@" + string + ":" + string2 + ":" + string3;
        return string5;
    }

    public static String getORDSVersion(Connection connection) {
        String string = DBUtil.getInstance((Connection)connection).executeReturnOneCol(GET_ORDS_VERSION_SQL);
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRegistryVersion(Connection connection, String string, boolean bl) throws Exception {
        boolean bl2;
        String string2;
        String string3;
        block10: {
            string3 = null;
            string2 = null;
            bl2 = false;
            OracleCallableStatement oracleCallableStatement = null;
            if (Connections.getInstance().lock(connection)) {
                try {
                    oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string);
                    oracleCallableStatement.registerOutParameter(1, 12);
                    oracleCallableStatement.registerOutParameter(2, 12);
                    oracleCallableStatement.registerOutParameter(3, 12);
                    oracleCallableStatement.execute();
                    bl2 = Boolean.parseBoolean(oracleCallableStatement.getString(1));
                    string3 = oracleCallableStatement.getString(2);
                    string2 = oracleCallableStatement.getString(3);
                    break block10;
                }
                finally {
                    Connections.getInstance().unlock(connection);
                    Closeables.close((Object)oracleCallableStatement);
                }
            }
            logger.warning(RestArb.format("CONNECT_LOCK_FAILED", string));
            return null;
        }
        if (!bl2) {
            return "";
        }
        if (bl) {
            if (!NullOrEmpty.nullOrEmpty((CharSequence)string2) && string2.equalsIgnoreCase("VALID") && InstallDBUtils.validateVersion(string3)) {
                return string3;
            }
            String string4 = RestArb.format("ERR_ORDS_REGISTRY_VERSION_STATUS", string3, string2);
            throw new Exception(string4);
        }
        if (!NullOrEmpty.nullOrEmpty((CharSequence)string2) && string2.equalsIgnoreCase("VALID")) {
            return string3;
        }
        String string5 = RestArb.format("ERR_APEX_REGISTRY_VERSION_STATUS", string3, string2);
        throw new Exception(string5);
    }

    public static boolean isCDBRoot(Connection connection) throws Exception {
        boolean bl = false;
        if (DBUtil.checkVersion((Connection)connection, null, (Version)DBUtil.ORACLE12c_VERSION) && Connections.getInstance().lock(connection)) {
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(IS_CDB_ROOT_SQL);
                oracleCallableStatement.registerOutParameter(1, 12);
                oracleCallableStatement.execute();
                bl = Boolean.parseBoolean(oracleCallableStatement.getString(1));
            }
            finally {
                Connections.getInstance().unlock(connection);
                Closeables.close((Object)oracleCallableStatement);
            }
        }
        return bl;
    }

    public static boolean userExist(Connection connection, String string) {
        String[] stringArray = new String[]{string};
        return InstallDBUtils.usersExists(connection, stringArray);
    }

    public static boolean usersExists(Connection connection, String[] stringArray) {
        Map<String, String> map = InstallDBUtils.getUsersStatus(connection, stringArray);
        for (String string : stringArray) {
            if (map.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUserStatus(String string, String string2, String string3, String[] stringArray) throws Exception {
        Map<String, String> map;
        if (NullOrEmpty.nullOrEmpty((CharSequence)string) || NullOrEmpty.nullOrEmpty((CharSequence)string2) || NullOrEmpty.nullOrEmpty((CharSequence)string3)) {
            return null;
        }
        String string4 = string3;
        if (string3.startsWith("@")) {
            string4 = Passwords.comingIn((String)string4.substring(1));
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string4);
            map = InstallDBUtils.getUsersStatus(connection, stringArray);
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUsersStatus(Connection connection, String[] stringArray) {
        HashMap<String, String> hashMap;
        block5: {
            String string = InstallDBUtils.getUserStatusQuery(stringArray);
            hashMap = new HashMap<String, String>();
            try {
                if (!Connections.getInstance().lock(connection)) break block5;
                ResultSet resultSet = null;
                try {
                    Map map = null;
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, map);
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        String string3 = resultSet.getString(2);
                        hashMap.put(string2, string3);
                    }
                }
                catch (Throwable throwable) {
                    Connections.getInstance().unlock(connection);
                    DBUtil.closeResultSet(resultSet);
                    throw throwable;
                }
                Connections.getInstance().unlock(connection);
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getNames(Connection connection, String string) {
        ArrayList<String> arrayList;
        block5: {
            arrayList = new ArrayList<String>();
            try {
                if (!Connections.getInstance().lock(connection)) break block5;
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(string, hashMap);
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        arrayList.add(string2);
                    }
                }
                catch (Throwable throwable) {
                    Connections.getInstance().unlock(connection);
                    DBUtil.closeResultSet(resultSet);
                    throw throwable;
                }
                Connections.getInstance().unlock(connection);
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
            catch (SQLException sQLException) {
                logger.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        return arrayList;
    }

    private static boolean validateVersion(String string) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)string)) {
            String string2 = "\\d{1,2}\\.\\d{1,2}\\.\\d{1,2}\\.[\\d]+\\.[\\d]+\\.[\\d]+";
            boolean bl = Pattern.matches(string2, string);
            return bl;
        }
        return false;
    }

    private static boolean isEarlierVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        if (stringArray.length < 3 && stringArray2.length < 3) {
            logger.warning("The version format is invalid. sourceVersion: " + string + " targetVersion: " + string2);
        }
        for (int i = 0; i < 3; ++i) {
            int n;
            int n2 = Integer.parseInt(stringArray[i]);
            if (n2 < (n = Integer.parseInt(stringArray2[i]))) {
                return true;
            }
            if (n2 <= n) continue;
            return false;
        }
        return false;
    }

    private static String getLookupKey(String string, String string2) {
        if (NullOrEmpty.nullOrEmpty((CharSequence)string) || NullOrEmpty.nullOrEmpty((CharSequence)string2)) {
            return null;
        }
        return string.toUpperCase() + string2.toUpperCase();
    }

    public static String getORDSRegistryVersion(Connection connection) throws Exception {
        return InstallDBUtils.getRegistryVersion(connection, GET_ORDS_REGISTRY_SQL, true);
    }

    public static String getAPEXRegistryVersion(Connection connection) throws Exception {
        return InstallDBUtils.getRegistryVersion(connection, GET_APEX_REGISTRY_SQL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canMigrateAPEXRest(String string, String string2, String string3) {
        Object object;
        if (NullOrEmpty.nullOrEmpty((CharSequence)string) || NullOrEmpty.nullOrEmpty((CharSequence)string2) || NullOrEmpty.nullOrEmpty((CharSequence)string3)) {
            return false;
        }
        String string4 = InstallDBUtils.getLookupKey(string, string2);
        if (string4 != null && (object = lookUp_Version.get(string4)) != null) {
            boolean bl = Boolean.parseBoolean(object[2]);
            return bl;
        }
        object = null;
        String string5 = string3;
        if (string3.startsWith("@")) {
            string5 = Passwords.comingIn((String)string5.substring(1));
        }
        Connection connection = null;
        boolean bl = false;
        try {
            List<String> list;
            connection = DriverManager.getConnection(string, string2, string5);
            object = InstallDBUtils.getAPEXRegistryVersion(connection);
            if (object == null || ((String)object).isEmpty()) {
                String[] stringArray = new String[]{APEX, "", Boolean.toString(false)};
                lookUp_Version.put(string4, stringArray);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = bl = !InstallDBUtils.isEarlierVersion((String)object, MIN_APEX_REST_VERSION) && !((String)object).startsWith("5");
            if (bl && (list = InstallDBUtils.getNames(connection, GET_APEX_USERS_SQL)).contains("APEX_LISTENER") && list.contains("APEX_REST_PUBLIC_USER")) {
                String[] stringArray = new String[]{APEX, object, Boolean.toString(bl)};
                lookUp_Version.put(string4, stringArray);
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            boolean bl6 = false;
            return bl6;
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
            string5 = null;
        }
    }

    private static String getUserStatusQuery(String[] stringArray) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select username, account_status from sys.dba_users where username in (");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append("'").append(stringArray[i]).append("'");
                if (i + 1 >= stringArray.length) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String validateConnection(String string, String string2, String string3) {
        String string4 = null;
        String string5 = string3;
        if (string5.startsWith("@")) {
            string5 = Passwords.comingIn((String)string5.substring(1));
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, string2, string5);
        }
        catch (Exception exception) {
            string4 = exception.getLocalizedMessage();
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
                connection = null;
            }
            catch (SQLException sQLException) {}
        }
        return string4;
    }

    public static String getDBAUsername(String string) {
        String string2 = string.trim().toUpperCase();
        if (string2.equals(SYS_USER)) {
            return string + " AS SYSDBA";
        }
        return string;
    }

    public static List<String> getORDSDBUsers(Connection connection) {
        return InstallDBUtils.getNames(connection, GET_ORDS_USERS_SQL);
    }

    public static boolean hasSYSDBAPrivileges(Connection connection) {
        String string = DBUtil.getInstance((Connection)connection).executeReturnOneCol(GET_SYSDBA_PRIV_SQL);
        return string != null && string.equals("SYSDBA");
    }
}

