/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.editor;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.rest.editor.RestWorksheetNode;
import oracle.dbtools.util.Resource;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.dbtools.worksheet.extension.WorksheetNode;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public class RestWorkSheet
extends Worksheet {
    private static final Logger LOGGER = Logger.getLogger(RestWorkSheet.class.getName());
    private Node m_node = null;
    private List<String> _currBindVars;

    public RestWorkSheet(ArrayList<IdeAction> arrayList, String string, List<String> arrayList2) {
        ArrayList arrayList3 = this._currBindVars = arrayList2 == null ? new ArrayList() : arrayList2;
        if (!this._currBindVars.isEmpty()) {
            ((WorksheetGUI)this.getGUI()).setBindVariables(arrayList2);
        }
        this.addActionProvider(new ArrayList());
        this.initContext();
        this.setText(string);
        Toolbar toolbar = this.getToolbar();
        Container container = (Container)this.getGUI();
        container.add((Component)toolbar, "North");
    }

    protected void initContext() {
        Context context = Context.newIdeContext((View)this.getViewWithoutDecoration());
        this.m_node = this.getTempNode();
        context.setNode(this.m_node);
        this.setContext(context);
    }

    private WorksheetNode getTempNode() {
        RestWorksheetNode restWorksheetNode = null;
        try {
            File file = File.createTempFile("rest", ".worksheet", Resource.RAPTOR_USER_TEMP);
            file.deleteOnExit();
            restWorksheetNode = new RestWorksheetNode(file.toURL());
            restWorksheetNode.setConnectionName("");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return restWorksheetNode;
    }

    public void setText(String string) {
        if (string == null || string.isEmpty()) {
            this.replaceText("");
        }
        this.replaceText(string);
    }

    public String getText() {
        return this.getFocusedEditorPane().getText();
    }

    public Node getNode() {
        return this.m_node;
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            Node node = context.getNode();
            this.m_node = node instanceof WorksheetNode ? (WorksheetNode)node : null;
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_resthandler_html");
    }

    public void updateBindVariables(List<String> arrayList) {
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList2 = arrayList == null ? new ArrayList<String>() : arrayList;
        if (!this._currBindVars.equals(arrayList2)) {
            ((WorksheetGUI)this.getGUI()).setBindVariables(arrayList2);
            ((WorksheetGUI)this.getGUI()).invokeInsight(this.getConnectionName());
            this._currBindVars = arrayList2;
        }
    }
}

