/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.autorest.ui.CheckBoxColumnHeaderRenderer;
import oracle.dbtools.autorest.ui.CheckBoxTableCellRendererEditor;
import oracle.dbtools.autorest.ui.LabelColumnHeaderRenderer;

public class RestObjectMembersPanel
extends JPanel {
    public static final String PANEL_OBJECT_MEMBERS_HEADER_MEMBER = AutoRestArb.get("PANEL_OBJECT_MEMBERS_HEADER_MEMBER");
    public static final String PANEL_OBJECT_MEMBERS_HEADER_VISIBLE = AutoRestArb.get("PANEL_OBJECT_MEMBERS_HEADER_VISIBLE");
    private transient RestObjectData restObjectDataModel;
    private transient List<String> existingNames;
    private transient ArrayList<String> _errMsg;
    private ArrayList<String> ignorePropertyList = new ArrayList();
    private transient ObjectDataModelListener objectDataModelListener = new ObjectDataModelListener();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane membersVisibleScrollPane = new JScrollPane();
    private JTable membersVisibleTable = new JTable();
    private transient MembersVisibleTableModel membersVisibleTableModel = new MembersVisibleTableModel();
    private JButton selectAllButton = new JButton();
    private JButton deselectAllButton = new JButton();

    public RestObjectMembersPanel(RestObjectData restObjectData) {
        this.restObjectDataModel = restObjectData;
        this.restObjectDataModel.addPropertyChangeListener(this.objectDataModelListener);
        this.jbInit();
    }

    private void jbInit() {
        this.initialise();
        this.setName("RestObjectMembersPanel");
        this.setLayout(this.gridBagLayout1);
        this.membersVisibleTable.setName("membersVisibleTable");
        this.membersVisibleTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.membersVisibleTable.setModel(this.membersVisibleTableModel);
        this.selectAllButton.setName("selectAllButton");
        this.selectAllButton.setText("All visible");
        this.selectAllButton.setText(AutoRestArb.get("PANEL_OBJECT_MEMBERS_SELECT_ALL_VISIBLE"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestObjectMembersPanel.this.selectAllButton_actionPerformed(actionEvent);
            }
        });
        this.deselectAllButton.setName("deselectAllButton");
        this.deselectAllButton.setText("None visible");
        this.deselectAllButton.setText(AutoRestArb.get("PANEL_OBJECT_MEMBERS_DESELECT_ALL_VISIBLE"));
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RestObjectMembersPanel.this.deselectAllButton_actionPerformed(actionEvent);
            }
        });
        this.membersVisibleTable.getColumnModel().getColumn(0).setHeaderRenderer(new LabelColumnHeaderRenderer());
        this.membersVisibleTable.getColumnModel().getColumn(1).setCellRenderer(new CheckBoxTableCellRendererEditor());
        this.membersVisibleTable.getColumnModel().getColumn(1).setCellEditor(new CheckBoxTableCellRendererEditor());
        this.membersVisibleTable.getColumnModel().getColumn(1).setHeaderRenderer(new CheckBoxColumnHeaderRenderer());
        this.membersVisibleScrollPane.setName("membersVisibleScrollPane");
        this.membersVisibleScrollPane.getViewport().add((Component)this.membersVisibleTable, null);
        this.add((Component)this.membersVisibleScrollPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.selectAllButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.deselectAllButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        if (this._errMsg.size() > 0) {
            // empty if block
        }
        return this._errMsg.size() == 0;
    }

    public RestObjectData getValues() {
        return this.restObjectDataModel;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public void setExistingNames(List<String> list) {
        this.existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this.existingNames == null || this.existingNames.isEmpty()) {
            return false;
        }
        return this.existingNames.contains(string);
    }

    private void initialise() {
        if (this.restObjectDataModel != null) {
            this.membersVisibleTableModel.fireTableDataChanged();
        }
    }

    public void updatePanel() {
        this.initialise();
    }

    private void selectAllButton_actionPerformed(ActionEvent actionEvent) {
        if (this.restObjectDataModel != null) {
            Boolean[] booleanArray = this.restObjectDataModel.getVisible();
            for (int i = 0; i < booleanArray.length; ++i) {
                this.restObjectDataModel.getVisible()[i] = Boolean.TRUE;
            }
            this.membersVisibleTableModel.fireTableDataChanged();
        }
    }

    private void deselectAllButton_actionPerformed(ActionEvent actionEvent) {
        if (this.restObjectDataModel != null) {
            Boolean[] booleanArray = this.restObjectDataModel.getVisible();
            for (int i = 0; i < booleanArray.length; ++i) {
                this.restObjectDataModel.getVisible()[i] = Boolean.FALSE;
            }
            this.membersVisibleTableModel.fireTableDataChanged();
        }
    }

    private class ObjectDataModelListener
    implements PropertyChangeListener {
        private ObjectDataModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ArrayList arrayList = RestObjectMembersPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestObjectMembersPanel.this.ignorePropertyList.contains(string)) {
                    try {
                        if (propertyChangeEvent.getPropertyName().equals("memberNames") || propertyChangeEvent.getPropertyName().equals("visible")) {
                            RestObjectMembersPanel.this.membersVisibleTableModel.fireTableDataChanged();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class MembersVisibleTableModel
    extends AbstractTableModel {
        protected Vector columnIdentifiers = new Vector();

        public MembersVisibleTableModel() {
            this.addColumn(PANEL_OBJECT_MEMBERS_HEADER_MEMBER);
            this.addColumn(PANEL_OBJECT_MEMBERS_HEADER_VISIBLE);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    object = RestObjectMembersPanel.this.restObjectDataModel.getMemberAliases()[n];
                    break;
                }
                case 1: {
                    object = RestObjectMembersPanel.this.restObjectDataModel.getVisible()[n];
                }
            }
            return object;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    ((RestObjectMembersPanel)RestObjectMembersPanel.this).restObjectDataModel.getMemberAliases()[n] = object == null ? null : object.toString();
                    break;
                }
                case 1: {
                    ((RestObjectMembersPanel)RestObjectMembersPanel.this).restObjectDataModel.getVisible()[n] = object == null ? null : (object instanceof Boolean ? (Boolean)object : Boolean.valueOf(object.toString()));
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public int getColumnCount() {
            int n = 2;
            return n;
        }

        @Override
        public int getRowCount() {
            int n = RestObjectMembersPanel.this.restObjectDataModel.getMemberAliases().length;
            return n;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public int findColumn(String string) {
            boolean bl = false;
            if (string != null) {
                if (string.equals(PANEL_OBJECT_MEMBERS_HEADER_MEMBER)) {
                    bl = false;
                } else if (string.equals(PANEL_OBJECT_MEMBERS_HEADER_VISIBLE)) {
                    bl = true;
                }
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            String string = PANEL_OBJECT_MEMBERS_HEADER_MEMBER;
            switch (n) {
                case 0: {
                    string = PANEL_OBJECT_MEMBERS_HEADER_MEMBER;
                    break;
                }
                case 1: {
                    string = PANEL_OBJECT_MEMBERS_HEADER_VISIBLE;
                }
            }
            return string;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Class clazz = String.class;
            switch (n) {
                case 0: {
                    clazz = String.class;
                    break;
                }
                case 1: {
                    clazz = Boolean.class;
                }
            }
            return clazz;
        }

        public void addColumn(Object object) {
            this.columnIdentifiers.addElement(object);
            this.fireTableStructureChanged();
        }
    }
}

