/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UpgradeController;
import oracle.dbtools.unit_test.testObjects.UtArguments;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtLookupItem;
import oracle.dbtools.unit_test.testObjects.UtStartup;
import oracle.dbtools.unit_test.testObjects.UtTeardown;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.testObjects.UtTestImplArgs;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.javatools.db.DBException;
import oracle.xml.parser.v2.XMLElement;

public class UtTest {
    private String _utId;
    private String _testName;
    private String _objName;
    private String _objOwner;
    private String _objType;
    private String _objCall;
    private boolean _coverage;
    private List<UtStartup> _startups = new ArrayList<UtStartup>();
    private HashSet<String> _savedStartupIdSet = new HashSet();
    private List<UtTeardown> _teardowns = new ArrayList<UtTeardown>();
    private HashSet<String> _savedTeardownIdSet = new HashSet();
    private String _objOverload;
    private String _sourceConName;
    private ArrayList<UtArguments> _arguments = new ArrayList();
    private ArrayList<UtTestImpl> _impls = new ArrayList();
    private boolean dirty = false;

    public UtTest(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this._objName = string2;
        this._objCall = string3;
        this._objType = string4;
        this._objOwner = string5;
        this._objOverload = string6;
        this._sourceConName = string7;
        this._coverage = false;
        this._utId = UUID.randomUUID().toString();
        this._testName = string == null || string.equals("") ? this._objName + "." + this._objOwner : string;
        this.createArguments();
        this.dirty = true;
    }

    public UtTest(String string) {
        this._utId = string;
        this.loadTest();
        this.loadStartups();
        this.loadTeardowns();
        this.loadArguments();
        this.loadImpls();
    }

    public UtTest(ImportContext importContext) {
        List<XMLElement> list;
        Object object;
        XMLElement xMLElement = importContext.getImportedElement();
        this._utId = xMLElement.getAttribute("id");
        if (this._utId == null || this._utId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this._testName = xMLElement.getAttribute("name");
        String string = UtUtils.existingTestID(this._utId, this._testName);
        if (string != null) {
            switch (importContext.conflictOption()) {
                case OVERWRITE: {
                    UtUtils.deleteTest(string, false);
                    break;
                }
                case SKIP: {
                    importContext.objectSkipped();
                    return;
                }
            }
        }
        this._objName = xMLElement.getAttribute("obj_name");
        this._objOwner = xMLElement.getAttribute("obj_owner");
        this._objType = xMLElement.getAttribute("obj_type");
        String string2 = xMLElement.getAttribute("obj_call");
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        this._objCall = string2;
        this._sourceConName = xMLElement.getAttribute("src_conn_name");
        String string3 = xMLElement.getAttribute("coverage");
        this._coverage = string3 != null ? Boolean.parseBoolean(string3) : false;
        List<XMLElement> list2 = importContext.getNestedElements(xMLElement, "startup");
        for (XMLElement object22 : list2) {
            object = new UtStartup(object22, this, null, importContext);
            this._startups.add((UtStartup)object);
        }
        List<XMLElement> list3 = importContext.getNestedElements(xMLElement, "teardown");
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (XMLElement)iterator.next();
            list = new UtTeardown((XMLElement)object, this, null, importContext);
            this._teardowns.add((UtTeardown)((Object)list));
        }
        HashMap<String, UtArguments> hashMap = new HashMap<String, UtArguments>();
        object = importContext.getNestedElements(xMLElement, "arg");
        list = object.iterator();
        while (list.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)list.next();
            UtArguments utArguments = new UtArguments(xMLElement2, this, importContext);
            this._arguments.add(utArguments);
            hashMap.put(utArguments.getArgId(), utArguments);
        }
        list = importContext.getNestedElements(xMLElement, "test_impl");
        for (XMLElement xMLElement3 : list) {
            UtTestImpl utTestImpl = new UtTestImpl(xMLElement3, this, hashMap, importContext);
            this._impls.add(utTestImpl);
        }
    }

    public void export(ExportContext exportContext) {
        this.exportRelated(exportContext);
        XMLElement xMLElement = exportContext.createExportedElement("test");
        xMLElement.setAttribute("id", this._utId);
        xMLElement.setAttribute("name", this._testName);
        xMLElement.setAttribute("obj_name", this._objName);
        xMLElement.setAttribute("obj_owner", this._objOwner);
        xMLElement.setAttribute("obj_type", this._objType);
        xMLElement.setAttribute("obj_call", this._objCall);
        xMLElement.setAttribute("src_conn_name", this._sourceConName);
        xMLElement.setAttribute("coverage", Boolean.toString(this._coverage));
        for (UtArguments object : this._arguments) {
            object.exportFields(xMLElement, exportContext);
        }
        for (UtStartup utStartup : this._startups) {
            utStartup.exportFields(xMLElement, exportContext);
        }
        for (UtTeardown utTeardown : this._teardowns) {
            utTeardown.exportFields(xMLElement, exportContext);
        }
        for (UtTestImpl utTestImpl : this._impls) {
            utTestImpl.exportFields(xMLElement, exportContext);
        }
    }

    private void exportRelated(ExportContext exportContext) {
        for (UtStartup object : this._startups) {
            object.exportRelated(exportContext);
        }
        for (UtTeardown utTeardown : this._teardowns) {
            utTeardown.exportRelated(exportContext);
        }
        for (UtTestImpl utTestImpl : this._impls) {
            utTestImpl.exportRelated(exportContext);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getId() {
        return this._utId;
    }

    public String getTestName() {
        return this._testName;
    }

    public void setTestName(String string) {
        this._testName = string;
        this.dirty = true;
    }

    public String getObjectName() {
        return this._objName;
    }

    public void setObjectName(String string) {
        this._objName = string;
        this.dirty = true;
    }

    public String getObjectOwner() {
        return this._objOwner;
    }

    public void setObjectOwner(String string) {
        this._objOwner = string;
        this.dirty = true;
    }

    public String getObjectType() {
        return this._objType;
    }

    public void setObjectType(String string) {
        this._objType = string;
        this.dirty = true;
    }

    public String getObjectCall() {
        return this._objCall;
    }

    public void setObjectCall(String string) {
        this._objCall = string;
        this.dirty = true;
    }

    public boolean getCoverage() {
        return this._coverage;
    }

    public void setCoverage(boolean bl) {
        this._coverage = bl;
    }

    public void setStartupCodeHooks(List<IStartup> list) {
        ArrayList<UtStartup> arrayList = new ArrayList<UtStartup>();
        HashMap<String, UtStartup> hashMap = new HashMap<String, UtStartup>();
        for (UtStartup object : this._startups) {
            hashMap.put(object.getStartupId(), object);
        }
        if (list != null) {
            for (IStartup iStartup : list) {
                if (null == iStartup.getXml()) continue;
                UtStartup utStartup = (UtStartup)hashMap.get(iStartup.getOwnerId());
                if (utStartup == null) {
                    utStartup = new UtStartup(this, null, null, -1, null, null, true);
                }
                utStartup.setStartupCodeHook(iStartup);
                arrayList.add(utStartup);
            }
        }
        this._startups = arrayList;
    }

    public void setTeardownCodeHooks(List<ITeardown> list) {
        ArrayList<UtTeardown> arrayList = new ArrayList<UtTeardown>();
        HashMap<String, UtTeardown> hashMap = new HashMap<String, UtTeardown>();
        for (UtTeardown object : this._teardowns) {
            hashMap.put(object.getTeardownId(), object);
        }
        if (list != null) {
            for (ITeardown iTeardown : list) {
                if (null == iTeardown.getXml()) continue;
                UtTeardown utTeardown = (UtTeardown)hashMap.get(iTeardown.getOwnerId());
                if (utTeardown == null) {
                    utTeardown = new UtTeardown(this, null, null, -1, null, null, true);
                }
                utTeardown.setTeardownCodeHook(iTeardown);
                arrayList.add(utTeardown);
            }
        }
        this._teardowns = arrayList;
    }

    public List<UtStartup> getStartups() {
        return this._startups;
    }

    public List<IStartup> getStartupCodeHooks() {
        ArrayList<IStartup> arrayList = new ArrayList<IStartup>();
        for (UtStartup utStartup : this._startups) {
            IStartup iStartup = utStartup.getStartupCodeHook();
            if (iStartup == null) continue;
            arrayList.add(iStartup);
        }
        return arrayList;
    }

    public List<UtTeardown> getTeardowns() {
        return this._teardowns;
    }

    public List<ITeardown> getTeardownCodeHooks() {
        ArrayList<ITeardown> arrayList = new ArrayList<ITeardown>();
        for (UtTeardown utTeardown : this._teardowns) {
            ITeardown iTeardown = utTeardown.getTeardownCodeHook();
            if (iTeardown == null) continue;
            arrayList.add(iTeardown);
        }
        return arrayList;
    }

    public String getOverload() {
        return this._objOverload;
    }

    public String getSourceConName() {
        return this._sourceConName;
    }

    public void setSourceConName(String string) {
        this._sourceConName = string;
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createArguments() {
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this._sourceConName);
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        if (Connections.getInstance().lock(connection)) {
            block8: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string = UtUtils.getQuery("createArguments");
                    hashMap.put("OBJECT_OWNER", this._objOwner);
                    hashMap.put("OBJECT_NAME", this._objName);
                    hashMap.put("OBJECT_CALL", this._objCall);
                    hashMap.put("OVERLOAD", this._objOverload);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block8;
                    while (resultSet.next()) {
                        String string2 = resultSet.getString("DATA_TYPE");
                        if (string2 == null) continue;
                        UtArguments utArguments = new UtArguments(null, this, resultSet.getString("OWNER"), resultSet.getString("OBJECT_NAME"), resultSet.getString("PACKAGE_NAME"), this.getIntegerResult(resultSet, "OBJECT_ID"), resultSet.getString("OVERLOAD"), resultSet.getString("ARGUMENT_NAME"), this.getIntegerResult(resultSet, "POSITION"), this.getIntegerResult(resultSet, "SEQUENCE"), this.getIntegerResult(resultSet, "DATA_LEVEL"), string2, this.getIntegerResult(resultSet, "DEFAULT_LENGTH"), resultSet.getString("IN_OUT"), this.getIntegerResult(resultSet, "DATA_LENGTH"), this.getIntegerResult(resultSet, "DATA_PRECISION"), this.getIntegerResult(resultSet, "DATA_SCALE"), this.getIntegerResult(resultSet, "RADIX"), resultSet.getString("CHARACTER_SET_NAME"), resultSet.getString("TYPE_OWNER"), resultSet.getString("TYPE_NAME"), resultSet.getString("TYPE_SUBNAME"), resultSet.getString("TYPE_LINK"), resultSet.getString("PLS_TYPE"), this.getIntegerResult(resultSet, "CHAR_LENGTH"), resultSet.getString("CHAR_USED"));
                        this._arguments.add(utArguments);
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    private Integer getIntegerResult(ResultSet resultSet, String string) throws SQLException {
        return resultSet.getObject(string) != null ? Integer.valueOf(resultSet.getInt(string)) : null;
    }

    public String getNextImplName() {
        int n = this._impls == null ? 1 : this._impls.size() + 1;
        return UtAddinArb.format("NEW_TEST_IMPL_NAME", n);
    }

    public void createTestImpl(String string, String string2, String string3) {
        String string4 = string != null ? string : this.getNextImplName();
        UtTestImpl utTestImpl = new UtTestImpl(null, this._utId, string4, true, this, string2, string3, null, null);
        utTestImpl.createParameters(this._arguments);
        this._impls.add(utTestImpl);
        this.dirty = true;
    }

    public void createSeedImpls() {
        DataValue dataValue;
        int n;
        int n2;
        String[] stringArray;
        Object object;
        int n3 = 1;
        String string = UtConfig.getInstance().getPairElement("LOOKUP_CATEGORY").getName();
        HashMap<String, String> hashMap = UtUtils.getLookupCounts(string);
        ArrayList<UtArguments> arrayList = this.getCallableArgumentsSorted();
        if ("FUNCTION".equals(this.getObjectType())) {
            object = new ArrayList<UtArguments>(arrayList);
            stringArray = object.iterator();
            while (stringArray.hasNext()) {
                UtArguments utArguments = (UtArguments)stringArray.next();
                if (0 != utArguments.get_position()) continue;
                arrayList.remove(utArguments);
                break;
            }
        }
        object = new int[arrayList.size()];
        stringArray = new String[arrayList.size()];
        int n4 = 0;
        for (UtArguments utArguments : arrayList) {
            String string2 = utArguments.get_data_type();
            String string3 = hashMap.get(string2);
            n2 = string3 != null ? Integer.valueOf(string3) : 0;
            object[n4] = n2;
            stringArray[n4] = string2;
            ++n4;
        }
        for (Object object2 : object) {
            if (object2 <= 0) continue;
            n3 *= object2;
        }
        DataValue[][] dataValueArray = new DataValue[n3][arrayList.size()];
        for (n = 0; n < ((Object)object).length; ++n) {
            int n5;
            Vector<UtLookupItem> vector = UtUtils.getLookupValues(string, stringArray[n]);
            int n6 = vector.size();
            n2 = 1;
            for (n5 = n + 1; n5 < ((Object)object).length; ++n5) {
                if (object[n5] <= 0) continue;
                n2 *= object[n5];
            }
            n5 = 0;
            int n7 = 0;
            for (int i = 0; i < n3; ++i) {
                try {
                    dataValue = vector.get(n7).getValue();
                }
                catch (Exception exception) {
                    dataValue = null;
                }
                dataValueArray[i][n] = dataValue;
                if (++n5 != n2) continue;
                n5 = 0;
                if (n7 == n6 - 1) {
                    n7 = 0;
                    continue;
                }
                ++n7;
            }
        }
        for (n = 0; n < dataValueArray.length; ++n) {
            UtTestImpl utTestImpl = new UtTestImpl(null, this._utId, this.getNextImplName(), true, this, null, null, null, null);
            utTestImpl.createParameters(this._arguments);
            HashMap<String, UtTestImplArgs> hashMap2 = utTestImpl.getParameters();
            n2 = 0;
            for (UtArguments utArguments : arrayList) {
                UtTestImplArgs utTestImplArgs = hashMap2.get(utArguments.getArgId());
                dataValue = utTestImplArgs.getDataType();
                if (dataValue.isSupported()) {
                    utTestImplArgs.setInput(dataValueArray[n][n2]);
                }
                ++n2;
            }
            this._impls.add(utTestImpl);
        }
        this.dirty = true;
    }

    public void removeAllImpls() {
        this._impls.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTest() {
        Object object;
        if (UtAddin.getDataTypeConnectionProvider().peekDataTypeConnectionQualName() == null) {
            object = UtUtils.getTestConnectionName(this._utId);
            UtAddin.getDataTypeConnectionProvider().setDataTypeConnectionQualName((String)object);
        }
        object = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(false);
                String string = UtUtils.getQuery("test");
                hashMap.put("ID", this._utId);
                object = dBUtil.executeOracleQuery(string, hashMap);
                if (object != null) {
                    while (object.next()) {
                        this._testName = object.getString("NAME");
                        this._objName = object.getString("OBJECT_NAME");
                        this._objOwner = object.getString("OBJECT_OWNER");
                        this._objType = object.getString("OBJECT_TYPE");
                        this._objCall = object.getString("OBJECT_CALL");
                        this._sourceConName = object.getString("CONNECTION_NAME");
                        this._coverage = object.getBoolean("COVERAGE");
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStartups() {
        block10: {
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string = UtUtils.getQuery("loadStartups");
                    hashMap.put("UT_ID", this._utId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string2 = resultSet.getString("STARTUP_ID");
                            int n = resultSet.getInt("INDEX_NO");
                            String string3 = null;
                            UtLibraryRef utLibraryRef = null;
                            String string4 = resultSet.getString("LIB_STARTUP_ID");
                            if (string4 != null) {
                                utLibraryRef = new UtLibraryRef(string4, resultSet.getString("LIB_STARTUP_NAME"));
                                string3 = resultSet.getString("LIB_STARTUP");
                            } else {
                                utLibraryRef = null;
                                string3 = resultSet.getString("STARTUP");
                            }
                            if (string3 == null || string3.trim().equals("")) continue;
                            UtStartup utStartup = new UtStartup(this, null, string2, n, utLibraryRef, string3, false);
                            this._startups.add(utStartup);
                            this._savedStartupIdSet.add(utStartup.getStartupId());
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block10;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTeardowns() {
        block10: {
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string = UtUtils.getQuery("loadTeardowns");
                    hashMap.put("UT_ID", this._utId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string2 = resultSet.getString("TEARDOWN_ID");
                            int n = resultSet.getInt("INDEX_NO");
                            String string3 = null;
                            UtLibraryRef utLibraryRef = null;
                            String string4 = resultSet.getString("LIB_TEARDOWN_ID");
                            if (string4 != null) {
                                utLibraryRef = new UtLibraryRef(string4, resultSet.getString("LIB_TEARDOWN_NAME"));
                                string3 = resultSet.getString("LIB_TEARDOWN");
                            } else {
                                utLibraryRef = null;
                                string3 = resultSet.getString("TEARDOWN");
                            }
                            if (string3 == null || string3.trim().equals("")) continue;
                            UtTeardown utTeardown = new UtTeardown(this, null, string2, n, utLibraryRef, string3, false);
                            this._teardowns.add(utTeardown);
                            this._savedTeardownIdSet.add(utTeardown.getTeardownId());
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block10;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadArguments() {
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            block7: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string = UtUtils.getQuery("loadArguments");
                    hashMap.put("ID", this._utId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block7;
                    while (resultSet.next()) {
                        UtArguments utArguments = new UtArguments(resultSet.getString("ARG_ID"), this, resultSet.getString("OWNER"), resultSet.getString("OBJECT_NAME"), resultSet.getString("PACKAGE_NAME"), this.getIntegerResult(resultSet, "OBJECT_ID"), resultSet.getString("OVERLOAD"), resultSet.getString("ARGUMENT_NAME"), this.getIntegerResult(resultSet, "POSITION"), this.getIntegerResult(resultSet, "SEQUENCE"), this.getIntegerResult(resultSet, "DATA_LEVEL"), resultSet.getString("DATA_TYPE"), this.getIntegerResult(resultSet, "DEFAULT_LENGTH"), resultSet.getString("IN_OUT"), this.getIntegerResult(resultSet, "DATA_LENGTH"), this.getIntegerResult(resultSet, "DATA_PRECISION"), this.getIntegerResult(resultSet, "DATA_SCALE"), this.getIntegerResult(resultSet, "RADIX"), resultSet.getString("CHARACTER_SET_NAME"), resultSet.getString("TYPE_OWNER"), resultSet.getString("TYPE_NAME"), resultSet.getString("TYPE_SUBNAME"), resultSet.getString("TYPE_LINK"), resultSet.getString("PLS_TYPE"), this.getIntegerResult(resultSet, "CHAR_LENGTH"), resultSet.getString("CHAR_USED"));
                        this._arguments.add(utArguments);
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        if (this._arguments.size() > 0) {
            this._objOverload = this._arguments.get(0).get_overload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadImpls() {
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            block8: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string = UtUtils.getQuery("loadImpls");
                    hashMap.put("ID", this._utId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block8;
                    while (resultSet.next()) {
                        UtLibraryRef utLibraryRef = null;
                        String string2 = null;
                        String string3 = resultSet.getString("LIB_DYN_QUERY_ID");
                        if (string3 != null) {
                            utLibraryRef = new UtLibraryRef(string3, resultSet.getString("LIB_DYN_QUERY_NAME"));
                            string2 = resultSet.getString("LIB_DYN_QUERY");
                        } else {
                            utLibraryRef = null;
                            string2 = resultSet.getString("DYNAMIC_VALUE_QUERY");
                        }
                        UtTestImpl utTestImpl = new UtTestImpl(resultSet.getString("UTI_ID"), resultSet.getString("UT_ID"), resultSet.getString("NAME"), false, this, resultSet.getString("EXPECTED_RETURN"), resultSet.getString("EXPECTED_RETURN_ERROR"), string2, utLibraryRef);
                        utTestImpl.loadValidations();
                        utTestImpl.loadParameters();
                        this._impls.add(utTestImpl);
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    public ArrayList<UtArguments> getChildArgumentsSorted(int n) {
        ArrayList<UtArguments> arrayList = new ArrayList<UtArguments>();
        ArrayList<UtArguments> arrayList2 = this.getSequenceSortedArguments();
        UtArguments utArguments = null;
        for (UtArguments utArguments2 : arrayList2) {
            if (utArguments == null) {
                if (utArguments2.get_sequence() != n) continue;
                utArguments = utArguments2;
                continue;
            }
            if (utArguments2.get_data_level() < utArguments.get_data_level() + 1) break;
            if (utArguments2.get_data_level() > utArguments.get_data_level() + 1) continue;
            arrayList.add(utArguments2);
        }
        return arrayList;
    }

    public ArrayList<UtArguments> getCallableArgumentsSorted() {
        return this.getCallableArgumentsSorted(this._arguments);
    }

    public ArrayList<UtArguments> getCallableArgumentsSorted(ArrayList<UtArguments> arrayList) {
        ArrayList<UtArguments> arrayList2 = new ArrayList<UtArguments>();
        for (UtArguments utArguments : arrayList) {
            if (utArguments.get_data_level() != 0) continue;
            arrayList2.add(utArguments);
        }
        return this.getSequenceSortedArguments(arrayList2);
    }

    public ArrayList<UtArguments> getSequenceSortedArguments() {
        return this.getSequenceSortedArguments(this._arguments);
    }

    public ArrayList<UtArguments> getSequenceSortedArguments(ArrayList<UtArguments> arrayList) {
        ArrayList<UtArguments> arrayList2 = arrayList == this._arguments ? new ArrayList<UtArguments>(arrayList) : arrayList;
        Collections.sort(arrayList2, new argSequenceSorter());
        return arrayList2;
    }

    public ArrayList<UtTestImpl> getImpls() {
        Collections.sort(this._impls, new implSorter());
        return this._impls;
    }

    public UtTestImpl getImpl(String string) {
        for (UtTestImpl utTestImpl : this.getImpls()) {
            if (!utTestImpl.getName().equals(string)) continue;
            return utTestImpl;
        }
        return null;
    }

    public void save(boolean bl) throws ObjectUpdateException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            Savepoint savepoint = null;
            try {
                int n;
                int n2;
                Object object;
                savepoint = connection.setSavepoint();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("mergeTest");
                if (bl || this.dirty) {
                    hashMap.put("UT_ID", this._utId);
                    hashMap.put("TEST_NAME", this._testName);
                    hashMap.put("OBJECT_NAME", this._objName);
                    hashMap.put("OBJECT_TYPE", this._objType);
                    hashMap.put("OBJECT_OWNER", this._objOwner);
                    hashMap.put("OBJECT_CALL", this._objCall);
                    hashMap.put("CONNECTION_NAME", this._sourceConName);
                    hashMap.put("COVERAGE", this._coverage ? 1 : 0);
                    dBUtil.setRaiseError(true);
                    int n3 = dBUtil.executeUpdate(string, hashMap);
                    if (0 == n3) {
                        connection.rollback(savepoint);
                        throw new ObjectUpdateException();
                    }
                }
                for (UtArguments utArguments : this._arguments) {
                    hashMap.clear();
                    string = UtUtils.getQuery("insertArg");
                    hashMap.put("ARG_ID", utArguments.getArgId());
                    hashMap.put("UT_ID", utArguments.get_utid());
                    hashMap.put("OWNER", utArguments.get_owner());
                    hashMap.put("OBJECT_NAME", utArguments.get_object_name());
                    hashMap.put("PACKAGE_NAME", utArguments.get_package_name());
                    hashMap.put("OBJECT_ID", utArguments.get_object_id());
                    hashMap.put("OVERLOAD", utArguments.get_overload());
                    hashMap.put("ARGUMENT_NAME", utArguments.get_argument_name());
                    hashMap.put("POSITION", utArguments.get_position());
                    hashMap.put("SEQUENCE", utArguments.get_sequence());
                    hashMap.put("DATA_LEVEL", utArguments.get_data_level());
                    hashMap.put("DATA_TYPE", utArguments.get_data_type());
                    hashMap.put("DEFAULT_LENGTH", utArguments.get_default_length());
                    hashMap.put("IN_OUT", utArguments.get_in_out());
                    hashMap.put("DATA_LENGTH", utArguments.get_data_length());
                    hashMap.put("DATA_PRECISION", utArguments.get_data_precision());
                    hashMap.put("DATA_SCALE", utArguments.get_data_scale());
                    hashMap.put("RADIX", utArguments.get_radix());
                    hashMap.put("CHARACTER_SET_NAME", utArguments.get_character_set_name());
                    hashMap.put("TYPE_OWNER", utArguments.get_type_owner());
                    hashMap.put("TYPE_NAME", utArguments.get_type_name());
                    hashMap.put("TYPE_SUBNAME", utArguments.get_type_subname());
                    hashMap.put("TYPE_LINK", utArguments.get_type_link());
                    hashMap.put("PLS_TYPE", utArguments.get_pls_type());
                    hashMap.put("CHAR_LENGTH", utArguments.get_char_length());
                    hashMap.put("CHAR_USED", utArguments.get_char_used());
                    dBUtil.setRaiseError(true);
                    int n4 = dBUtil.executeUpdate(string, hashMap);
                    if (0 != n4) continue;
                    connection.rollback(savepoint);
                    throw new ObjectUpdateException();
                }
                try {
                    object = new HashSet();
                    for (int i = 0; i < this._startups.size(); ++i) {
                        UtStartup utStartup = this._startups.get(i);
                        ((HashSet)object).add(utStartup.getStartupId());
                        utStartup.save(i, bl);
                    }
                    for (String string2 : this._savedStartupIdSet) {
                        if (((HashSet)object).contains(string2)) continue;
                        dBUtil = DBUtil.getInstance((Connection)connection);
                        string = UtUtils.getQuery("deleteStartup");
                        hashMap.put("ID", string2);
                        dBUtil.setRaiseError(true);
                        n2 = dBUtil.executeUpdate(string, hashMap);
                        if (0 != n2) continue;
                        throw new ObjectUpdateException();
                    }
                    this._savedStartupIdSet = new HashSet(this._startups.size());
                    for (n = 0; n < this._startups.size(); ++n) {
                        UtStartup utStartup = this._startups.get(n);
                        this._savedStartupIdSet.add(utStartup.getStartupId());
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    connection.rollback(savepoint);
                    throw objectUpdateException;
                }
                try {
                    object = new HashSet<String>();
                    for (n = 0; n < this._teardowns.size(); ++n) {
                        UtTeardown utTeardown = this._teardowns.get(n);
                        ((HashSet)object).add(utTeardown.getTeardownId());
                        utTeardown.save(n, bl);
                    }
                    for (String string3 : this._savedTeardownIdSet) {
                        if (((HashSet)object).contains(string3)) continue;
                        dBUtil = DBUtil.getInstance((Connection)connection);
                        string = UtUtils.getQuery("deleteTeardown");
                        hashMap.put("ID", string3);
                        dBUtil.setRaiseError(true);
                        n2 = dBUtil.executeUpdate(string, hashMap);
                        if (0 != n2) continue;
                        throw new ObjectUpdateException();
                    }
                    this._savedTeardownIdSet = new HashSet(this._teardowns.size());
                    for (int i = 0; i < this._teardowns.size(); ++i) {
                        UtTeardown utTeardown = this._teardowns.get(i);
                        this._savedTeardownIdSet.add(utTeardown.getTeardownId());
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    connection.rollback(savepoint);
                    throw objectUpdateException;
                }
                try {
                    for (UtTestImpl utTestImpl : this._impls) {
                        utTestImpl.save(bl);
                    }
                }
                catch (ObjectUpdateException objectUpdateException) {
                    connection.rollback(savepoint);
                    throw objectUpdateException;
                }
                this.dirty = false;
                connection.commit();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                if (savepoint != null) {
                    try {
                        connection.rollback(savepoint);
                    }
                    catch (SQLException sQLException2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                    }
                }
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public String getTestCall() {
        UtArguments utArguments = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._objType + " " + this._objOwner + "." + this._objName);
        if (this.getCallableArgumentsSorted().size() > 0) {
            if (this._objCall != null && !this._objCall.equals("")) {
                stringBuilder.append("." + this._objCall);
            }
            stringBuilder.append("(");
            for (UtArguments utArguments2 : this.getCallableArgumentsSorted()) {
                if (utArguments2.get_data_level() == 0 && utArguments2.get_position() == 0) {
                    utArguments = utArguments2;
                    continue;
                }
                stringBuilder.append(utArguments2.get_argument_name() + " " + this.formattedInOut(utArguments2.get_in_out()) + " " + utArguments2.getDataTypeString() + ",");
            }
            if (stringBuilder.lastIndexOf(",") > 0) {
                stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, "");
            }
            stringBuilder.append(") ");
            if (utArguments != null) {
                stringBuilder.append("RETURNS " + utArguments.getDataTypeString());
            }
        }
        return stringBuilder.toString();
    }

    private String formattedInOut(String string) {
        if (string != null && string.equals("IN/OUT")) {
            return "IN OUT";
        }
        return string;
    }

    public UtArguments getArgument(String string) {
        for (UtArguments utArguments : this._arguments) {
            if (!utArguments.getArgId().equals(string)) continue;
            return utArguments;
        }
        return null;
    }

    public UpgradeController createUpgradeController(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        return new UpgradeControllerImpl(string, string2, string3, string4, string5, string6, bl);
    }

    private class UpgradeControllerImpl
    implements UpgradeController {
        private UtTest _newTest;
        private boolean _matchByName;
        private HashMap<String, String> _changedOrDeletedArgNameToIdMap;
        private ArrayList<String> _newArgNames;
        private HashMap<String, String> _unchangedArgNameToIdMap;

        UpgradeControllerImpl(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
            this._newTest = new UtTest(null, string, string2, string3, string4, string5, string6);
            this._changedOrDeletedArgNameToIdMap = new HashMap();
            this._newArgNames = new ArrayList();
            this._unchangedArgNameToIdMap = new HashMap();
            this.setMatchByName(bl);
        }

        @Override
        public UtTest getTest() {
            return UtTest.this;
        }

        @Override
        public UtTest getNewTest() {
            return this._newTest;
        }

        @Override
        public boolean getMatchByName() {
            return this._matchByName;
        }

        @Override
        public void setMatchByName(boolean bl) {
            this._changedOrDeletedArgNameToIdMap.clear();
            this._unchangedArgNameToIdMap.clear();
            this._newArgNames.clear();
            if (bl) {
                this.matchParametersByName();
            } else {
                this.matchParametersByPosition();
            }
            this._matchByName = bl;
        }

        @Override
        public boolean upgradeRequired() {
            return this.hasSourceConnectionChanged() || this.hasObjectOwnerChanged() || this.hasObjectNameChanged() || this._changedOrDeletedArgNameToIdMap.size() != 0 || this._newArgNames.size() != 0;
        }

        @Override
        public boolean hasSourceConnectionChanged() {
            return !this.eq(UtTest.this.getSourceConName(), this._newTest.getSourceConName());
        }

        @Override
        public boolean hasObjectOwnerChanged() {
            return !this.eq(UtTest.this.getObjectOwner(), this._newTest.getObjectOwner());
        }

        @Override
        public boolean hasObjectNameChanged() {
            return !this.eq(UtTest.this.getObjectName(), this._newTest.getObjectName()) || !this.eq(UtTest.this.getObjectCall(), this._newTest.getObjectCall());
        }

        @Override
        public Collection<String> getChangedOrDeletedArgNames() {
            return this._changedOrDeletedArgNameToIdMap.keySet();
        }

        @Override
        public Collection<String> getNewArgNames() {
            return this._newArgNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void upgradeTest() {
            Object object2;
            UtTest.this._objName = this._newTest._objName;
            UtTest.this._objOwner = this._newTest._objOwner;
            UtTest.this._objType = this._newTest._objType;
            UtTest.this._objCall = this._newTest._objCall;
            UtTest.this._objOverload = this._newTest._objOverload;
            UtTest.this._sourceConName = this._newTest._sourceConName;
            ArrayList<UtArguments> arrayList = new ArrayList<UtArguments>();
            ArrayList<UtArguments> arrayList2 = new ArrayList<UtArguments>();
            for (Object object3 : this._newTest._arguments) {
                void object4;
                object2 = null;
                object2 = ((UtArguments)object3).get_argument_name() == null && ((UtArguments)object3).get_data_level() == 0 ? UtAddinArb.getString("RETURNS_ARG_NAME") : ((UtArguments)object3).get_argument_name();
                Object var6_10 = null;
                if (object2 != null) {
                    String string = this._unchangedArgNameToIdMap.get(object2);
                }
                UtArguments utArguments = ((UtArguments)object3).createUpgradeArg(UtTest.this, (String)object4);
                arrayList2.add(utArguments);
                if (object4 != null) continue;
                arrayList.add(utArguments);
            }
            UtTest.this._arguments = arrayList2;
            for (Object object3 : UtTest.this._impls) {
                ((UtTestImpl)object3).upgradeArgs(this._changedOrDeletedArgNameToIdMap.values(), arrayList);
            }
            UtTest.this.dirty = true;
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    try {
                        Object object3;
                        object3 = null;
                        for (String string : this._unchangedArgNameToIdMap.values()) {
                            if (object3 == null) {
                                object3 = new StringBuffer();
                                ((StringBuffer)object3).append("delete from UT_TEST_ARGUMENTS where UT_ID = '" + UtTest.this._utId + "' and ARG_ID not in (");
                            } else {
                                ((StringBuffer)object3).append(',');
                            }
                            ((StringBuffer)object3).append('\'');
                            ((StringBuffer)object3).append(string);
                            ((StringBuffer)object3).append('\'');
                        }
                        if (object3 != null) {
                            ((StringBuffer)object3).append(')');
                        } else {
                            object3 = new StringBuffer();
                            ((StringBuffer)object3).append("delete from UT_TEST_ARGUMENTS where UT_ID = '" + UtTest.this._utId + "'");
                        }
                        object2 = DBUtil.getInstance((Connection)connection);
                        object2.setRaiseError(true);
                        HashMap hashMap = new HashMap();
                        object2.executeUpdate(((StringBuffer)object3).toString(), hashMap);
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, UtUtils.asString(exception));
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        }
                        throw new ObjectUpdateException(exception);
                    }
                    UtTest.this.save(true);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, UtUtils.asString(exception));
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }

        private ArrayList<UtArguments> getLevel0Args(ArrayList<UtArguments> arrayList) {
            ArrayList<UtArguments> arrayList2 = new ArrayList<UtArguments>();
            for (UtArguments utArguments : arrayList) {
                if (utArguments.get_data_level() != 0) continue;
                arrayList2.add(utArguments);
            }
            return arrayList2;
        }

        private void matchParametersByName() {
            Object object;
            ArrayList<UtArguments> arrayList = this.getLevel0Args(UtTest.this._arguments);
            ArrayList<UtArguments> arrayList2 = this.getLevel0Args(this._newTest._arguments);
            HashMap<String, UtArguments> hashMap = new HashMap<String, UtArguments>();
            for (UtArguments object2 : arrayList2) {
                hashMap.put(object2.get_argument_name(), object2);
            }
            for (UtArguments utArguments : arrayList) {
                String string = utArguments.get_argument_name();
                object = (UtArguments)hashMap.get(string);
                if (object == null || !this.equivalentArgDefs(utArguments, (UtArguments)object)) {
                    if (string == null) {
                        this._changedOrDeletedArgNameToIdMap.put(UtAddinArb.getString("RETURNS_ARG_NAME"), utArguments.getArgId());
                    } else {
                        this._changedOrDeletedArgNameToIdMap.put(string, utArguments.getArgId());
                    }
                    if (object == null) continue;
                    if (string == null) {
                        this._newArgNames.add(UtAddinArb.getString("RETURNS_ARG_NAME"));
                        continue;
                    }
                    this._newArgNames.add(string);
                    continue;
                }
                if (string == null) {
                    this._unchangedArgNameToIdMap.put(UtAddinArb.getString("RETURNS_ARG_NAME"), utArguments.getArgId());
                    continue;
                }
                this._unchangedArgNameToIdMap.put(string, utArguments.getArgId());
            }
            HashMap hashMap2 = new HashMap();
            for (UtArguments utArguments : arrayList) {
                hashMap2.put(utArguments.get_argument_name(), utArguments);
            }
            for (UtArguments utArguments : arrayList2) {
                object = utArguments.get_argument_name();
                UtArguments utArguments2 = (UtArguments)hashMap2.get(object);
                if (utArguments2 != null) continue;
                if (object == null) {
                    this._newArgNames.add(UtAddinArb.getString("RETURNS_ARG_NAME"));
                    continue;
                }
                this._newArgNames.add((String)object);
            }
        }

        private void matchParametersByPosition() {
            int n;
            int n2;
            ArrayList<UtArguments> arrayList = this.getLevel0Args(UtTest.this._arguments);
            ArrayList<UtArguments> arrayList2 = this.getLevel0Args(this._newTest._arguments);
            int n3 = arrayList.size();
            int n4 = n3 > (n2 = arrayList2.size()) ? n2 : n3;
            for (n = 0; n < n4; ++n) {
                if (!this.equivalentArgDefs(arrayList.get(n), arrayList2.get(n))) {
                    if (arrayList.get(n).get_argument_name() == null) {
                        this._changedOrDeletedArgNameToIdMap.put(UtAddinArb.getString("RETURNS_ARG_NAME"), arrayList.get(n).getArgId());
                    } else {
                        this._changedOrDeletedArgNameToIdMap.put(arrayList.get(n).get_argument_name(), arrayList.get(n).getArgId());
                    }
                    if (arrayList2.get(n).get_argument_name() == null) {
                        this._newArgNames.add(UtAddinArb.getString("RETURNS_ARG_NAME"));
                        continue;
                    }
                    this._newArgNames.add(arrayList2.get(n).get_argument_name());
                    continue;
                }
                if (arrayList.get(n).get_argument_name() == null) {
                    this._unchangedArgNameToIdMap.put(UtAddinArb.getString("RETURNS_ARG_NAME"), arrayList.get(0).getArgId());
                    continue;
                }
                this._unchangedArgNameToIdMap.put(arrayList.get(n).get_argument_name(), arrayList.get(0).getArgId());
            }
            for (n = n2; n < n3; ++n) {
                if (arrayList.get(n).get_argument_name() == null) {
                    this._changedOrDeletedArgNameToIdMap.put(UtAddinArb.getString("RETURNS_ARG_NAME"), arrayList.get(n).getArgId());
                    continue;
                }
                this._changedOrDeletedArgNameToIdMap.put(arrayList.get(n).get_argument_name(), arrayList.get(n).getArgId());
            }
            for (n = n3; n < n2; ++n) {
                if (arrayList2.get(n).get_argument_name() == null) {
                    this._newArgNames.add(UtAddinArb.getString("RETURNS_ARG_NAME"));
                    continue;
                }
                this._newArgNames.add(arrayList2.get(n).get_argument_name());
            }
        }

        private boolean equivalentArgDefs(UtArguments utArguments, UtArguments utArguments2) {
            return this.eq(utArguments.get_data_level(), utArguments2.get_data_level()) && this.eq(utArguments.get_data_type(), utArguments2.get_data_type()) && this.eq(utArguments.get_default_length(), utArguments2.get_default_length()) && this.eq(utArguments.get_in_out(), utArguments2.get_in_out()) && this.eq(utArguments.get_data_length(), utArguments2.get_data_length()) && this.eq(utArguments.get_data_precision(), utArguments2.get_data_precision()) && this.eq(utArguments.get_data_scale(), utArguments2.get_data_scale()) && this.eq(utArguments.get_radix(), utArguments2.get_radix()) && this.eq(utArguments.get_character_set_name(), utArguments2.get_character_set_name()) && this.eq(utArguments.get_type_owner(), utArguments2.get_type_owner()) && this.eq(utArguments.get_type_name(), utArguments2.get_type_name()) && this.eq(utArguments.get_type_subname(), utArguments2.get_type_subname()) && this.eq(utArguments.get_type_link(), utArguments2.get_type_link()) && this.eq(utArguments.get_pls_type(), utArguments2.get_pls_type()) && this.eq(utArguments.get_char_length(), utArguments2.get_char_length()) && this.eq(utArguments.get_char_used(), utArguments2.get_char_used());
        }

        private boolean eq(Object object, Object object2) {
            return object == null && object2 == null || object != null && object.equals(object2);
        }
    }

    public class implSorter
    implements Comparator {
        public int compare(Object object, Object object2) {
            return ((UtTestImpl)object).getName().compareToIgnoreCase(((UtTestImpl)object2).getName());
        }
    }

    public class argSequenceSorter
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n = ((UtArguments)object).get_sequence() - ((UtArguments)object2).get_sequence();
            return n;
        }
    }
}

