/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingWrapper;
import oracle.dbtools.raptor.datatypes.values.NamedDataValue;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.runner.CoverageManager;
import oracle.dbtools.unit_test.runner.UtRunnerDynamicImplArgs;
import oracle.dbtools.unit_test.runner.UtRunnerImplArgs;
import oracle.dbtools.unit_test.runner.UtRunnerObject;
import oracle.dbtools.unit_test.testObjects.UtTestImplArgs;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class UtRunnerImplIterator
implements Iterator {
    public static final String RETURN_NAME = "RETURNS";
    private static Logger LOGGER = Logger.getLogger(UtRunnerImplIterator.class.getName());
    protected DataTypeConnectionProvider provider;
    private String qualifiedName;
    protected String dynamicQuery;
    private LinkedList<CallableBinding> binds;
    PLSQLBoundBlockBuilder builder;
    private String sql;
    protected OraclePreparedStatement stmt;
    protected OracleResultSet rs;
    protected int colCount;
    protected CoverageManager coverageManager;
    protected UtRunnerImplObject runner;
    protected boolean lookAhead;

    public UtRunnerImplIterator(DataTypeConnectionProvider dataTypeConnectionProvider, String string, String string2) {
        this.provider = dataTypeConnectionProvider;
        this.qualifiedName = string;
        this.dynamicQuery = string2;
        this.binds = new LinkedList();
        this.lookAhead = false;
    }

    public DataTypeConnectionProvider getProvider() {
        return this.provider;
    }

    public String getSql() {
        PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder = this.builder;
        String string = this.sql;
        if (string == null) {
            pLSQLBoundBlockBuilder = new PLSQLBoundBlockBuilder();
            string = this.generateSql(pLSQLBoundBlockBuilder);
            this.builder = pLSQLBoundBlockBuilder;
            this.sql = string;
        }
        return string;
    }

    public void addBind(CallableBinding callableBinding) {
        this.sql = null;
        this.binds.add(callableBinding);
    }

    public List<String> getBindTokenList() {
        return this.builder.getBindTokenList();
    }

    protected String generateSql(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        for (CallableBinding callableBinding : this.binds) {
            pLSQLBoundBlockBuilder.addBuilder(callableBinding.getBuilder());
        }
        pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.Call, this.qualifiedName);
        return pLSQLBoundBlockBuilder.generateSql();
    }

    public void open() throws SQLException {
        if (this.dynamicQuery != null) {
            this.stmt = this.openDynamicQueryStatement();
            this.rs = (OracleResultSet)this.stmt.executeQuery();
            this.colCount = this.rs.getMetaData().getColumnCount();
            this.lookAhead = false;
        } else {
            this.close();
        }
        this.runner = null;
    }

    @Override
    public boolean hasNext() {
        block4: {
            try {
                if (this.rs != null) {
                    if (!this.lookAhead) {
                        this.lookAhead = this.rs.next();
                    }
                    break block4;
                }
                this.lookAhead = false;
                return this.runner == null;
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
                this.lookAhead = false;
            }
        }
        return this.lookAhead;
    }

    public UtRunnerObject next() {
        block10: {
            try {
                if (this.rs != null) {
                    boolean bl = this.lookAhead;
                    if (!this.lookAhead) {
                        bl = this.rs.next();
                    } else {
                        this.lookAhead = false;
                    }
                    if (bl) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        for (int i = this.colCount; i > 0; --i) {
                            try {
                                hashMap.put(this.rs.getMetaData().getColumnLabel(i), this.rs.getOracleObject(i));
                                continue;
                            }
                            catch (SQLException sQLException) {
                                hashMap.put(this.rs.getMetaData().getColumnLabel(i), this.rs.getObject(i));
                            }
                        }
                        this.runner = new UtRunnerImplObject(hashMap);
                        break block10;
                    }
                    return null;
                }
                if (this.runner == null) {
                    this.runner = new UtRunnerImplObject();
                    break block10;
                }
                return null;
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
                this.lookAhead = false;
                return null;
            }
        }
        return this.runner;
    }

    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            this.rs = null;
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
            }
            this.stmt = null;
        }
        this.lookAhead = false;
    }

    public boolean isDynamic() {
        return this.dynamicQuery == null;
    }

    public String getDynamicQuery() {
        return this.dynamicQuery;
    }

    protected OraclePreparedStatement openDynamicQueryStatement() throws SQLException {
        if (this.dynamicQuery != null) {
            String string = DynamicValueQuery.getQueryFromXml(this.dynamicQuery);
            return (OraclePreparedStatement)this.provider.getDataTypeConnection().prepareStatement(string);
        }
        return null;
    }

    @Override
    public void remove() {
    }

    public void setCoverageManager(CoverageManager coverageManager) {
        this.coverageManager = coverageManager;
    }

    public CoverageManager getCoverageManager() {
        return this.coverageManager;
    }

    protected class UtRunnerImplObject
    implements UtRunnerObject {
        protected Map<String, Object> dynamicData;
        protected Map<String, DataValue> dynamicCache;

        protected UtRunnerImplObject() {
        }

        protected UtRunnerImplObject(Map<String, Object> map) {
            this.dynamicData = map;
        }

        @Override
        public DataTypeConnectionProvider getProvider() {
            return UtRunnerImplIterator.this.getProvider();
        }

        @Override
        public String getSql() {
            return UtRunnerImplIterator.this.getSql();
        }

        @Override
        public CoverageManager getCoverageManager() {
            return UtRunnerImplIterator.this.getCoverageManager();
        }

        @Override
        public CallableBinding[] getBinds() {
            CallableBinding[] callableBindingArray = UtRunnerImplIterator.this.binds.toArray(new CallableBinding[UtRunnerImplIterator.this.binds.size()]);
            if (this.dynamicData != null) {
                CallableBinding[] callableBindingArray2 = new CallableBinding[callableBindingArray.length];
                int n = -1;
                for (CallableBinding callableBinding : callableBindingArray) {
                    UtRunnerImplArgs utRunnerImplArgs = (UtRunnerImplArgs)callableBinding.getParameter();
                    Map<UtTestImplArgs.ValueSelector, DataValue> map = this.getDynamicDataValues(utRunnerImplArgs);
                    UtRunnerDynamicImplArgs utRunnerDynamicImplArgs = new UtRunnerDynamicImplArgs(utRunnerImplArgs, map);
                    CallableBindingWrapper callableBindingWrapper = new CallableBindingWrapper(callableBinding, (DataBinding)utRunnerDynamicImplArgs);
                    callableBindingArray2[++n] = callableBindingWrapper;
                }
                return callableBindingArray2;
            }
            return callableBindingArray;
        }

        @Override
        public boolean isDynamic() {
            return this.dynamicData != null;
        }

        protected Map<UtTestImplArgs.ValueSelector, DataValue> getDynamicDataValues(UtRunnerImplArgs utRunnerImplArgs) {
            HashMap<UtTestImplArgs.ValueSelector, DataValue> hashMap = new HashMap<UtTestImplArgs.ValueSelector, DataValue>();
            if (this.dynamicData != null) {
                BindingMode bindingMode = utRunnerImplArgs.getMode();
                DataType dataType = utRunnerImplArgs.getDataType();
                if (BindingMode.IN == bindingMode || BindingMode.IN_OUT == bindingMode) {
                    this.mapDynamicValueByName(hashMap, dataType, UtTestImplArgs.ValueSelector.input, utRunnerImplArgs.getName(), BindingMode.IN_OUT == bindingMode);
                }
                if (BindingMode.IN != bindingMode) {
                    this.mapDynamicValueByName(hashMap, dataType, UtTestImplArgs.ValueSelector.result, utRunnerImplArgs.getName(), false);
                }
            }
            return hashMap;
        }

        protected void mapDynamicValueByName(Map<UtTestImplArgs.ValueSelector, DataValue> map, DataType dataType, UtTestImplArgs.ValueSelector valueSelector, String string, boolean bl) {
            DataValue dataValue;
            DataValue dataValue2 = this.getDynamicValueByName(dataType, valueSelector, string, bl);
            if (dataValue2 != null && (dataValue = NamedDataValue.getNamedDataValue((String)string, (DataValue)dataValue2)) != null) {
                map.put(valueSelector, dataValue);
            }
        }

        protected DataValue getDynamicValueByName(DataType dataType, UtTestImplArgs.ValueSelector valueSelector, String string, boolean bl) {
            String string2 = string == null ? UtRunnerImplIterator.RETURN_NAME : string;
            string2 = valueSelector == UtTestImplArgs.ValueSelector.result ? string2 + "$" : string2;
            DataValue dataValue = null;
            if (this.dynamicData.containsKey(string2)) {
                String string3;
                Object object = this.dynamicData.get(string2);
                if (bl && ("CLOB".equals(string3 = dataType.getDataTypeString()) || "BLOB".equals(string3))) {
                    object = this.copyLob(string3, object);
                }
                dataValue = dataType.getDataValue(object);
            }
            return dataValue;
        }

        private Object copyLob(String string, Object object) {
            Object object2 = null;
            try {
                String string2 = "declare     source " + string + "; " + "    copy " + string + "; " + "begin " + "    source := ?; " + "    dbms_lob.createtemporary(copy, true); " + "    dbms_lob.copy(copy, source, dbms_lob.getlength(source)); " + "    ? := copy; " + "end;";
                CallableStatement callableStatement = UtRunnerImplIterator.this.provider.getDataTypeConnection().prepareCall(string2);
                callableStatement.setObject(1, object);
                callableStatement.registerOutParameter(2, "CLOB".equals(string) ? 2005 : 2004);
                callableStatement.execute();
                object2 = callableStatement.getObject(2);
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, UtUtils.logString(sQLException), sQLException);
                object2 = object;
            }
            return object2;
        }
    }
}

