/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator;

import oracle.dbtools.raptor.navigator.core.NavigatorManager;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.unit_test.navigator.UtNavigatorWindow;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;

public class UtNavigatorManager
extends NavigatorManager {
    private static final String DEFAULT_NAME = "UtNavigatorName";
    private static final String UT_NAVIGATOR_WINDOW_ID = "UtNavigatorWindow";
    private static UtNavigatorManager s_instance;

    public static synchronized UtNavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new UtNavigatorManager();
        }
        return s_instance;
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        DBNavigatorManager dBNavigatorManager = DBNavigatorManager.getInstance();
        if (dBNavigatorManager.getNavigatorWindow() != null) {
            dockingParam.setTabbedWith((Dockable)dBNavigatorManager.getNavigatorWindow());
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_unittesting_html");
    }

    protected NavigatorWindow createNavigatorWindow() {
        return new UtNavigatorWindow(this.getViewId());
    }

    public ViewId getViewId() {
        return new ViewId(UT_NAVIGATOR_WINDOW_ID, DEFAULT_NAME);
    }
}

