/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.navigator;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionException;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.dbtools.raptor.report.navigatorV2.ReportNavigatorContextMenu;
import oracle.dbtools.raptor.report.navigatorV2.ReportNode;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.UtDataTypeConnectionProvider;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.create_wizard.CreateWizMain;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.editor.SuiteItemPickerDialog;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.editor.UtLibraryEditor;
import oracle.dbtools.unit_test.editor.UtLookupEditor;
import oracle.dbtools.unit_test.editor.UtSuiteEditor;
import oracle.dbtools.unit_test.editor.UtTestEditor;
import oracle.dbtools.unit_test.impexp.ExportListener;
import oracle.dbtools.unit_test.impexp.ExportManager;
import oracle.dbtools.unit_test.manage_objects.PurgeResultsDialog;
import oracle.dbtools.unit_test.manage_objects.SyncTestWizMain;
import oracle.dbtools.unit_test.navigator.UtNavigatorWindow;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDefaultElement;
import oracle.dbtools.unit_test.navigator.nodes.UtDefaultFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueriesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtDynamicValueQueryElement;
import oracle.dbtools.unit_test.navigator.nodes.UtEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLibraryEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupCategoryFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupNode;
import oracle.dbtools.unit_test.navigator.nodes.UtLookupRootFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtNestedSuitesFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtParamElement;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupElement;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtSuiteTestsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownElement;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownsFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestEditorNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTestFolder;
import oracle.dbtools.unit_test.navigator.nodes.UtTestImplNode;
import oracle.dbtools.unit_test.navigator.nodes.UtTestNode;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationElement;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationsFolder;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.runner.Debugger;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupRegistry;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;
import oracle.dbtools.unit_test.utils.UiUtils;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorConstants;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdbc.OracleConnection;

public class UtNavigatorContextMenu
implements ContextMenuListener,
Controller {
    protected static final Logger LOGGER = Logger.getLogger(UtNavigatorContextMenu.class.getName());
    Element[] els = null;
    private boolean _actionsMade = false;
    private static UtNavigatorContextMenu _instance;
    static final int REFRESH_FOLDER_CMD_ID;
    private static IdeAction refreshAction;
    static final int EXPORT_MULTIPLE_CMD_ID;
    private static IdeAction exportMultiAction;
    static final int DELETE_FOLDER_CMD_ID;
    private static IdeAction deleteAction;
    static final int ADD_IMPL_FOLDER_CMD_ID;
    private static IdeAction addImplAction;
    static final int DEBUG_IMPL_CMD_ID;
    private static IdeAction debugImplAction;
    static final int RENAME_IMPL_CMD_ID;
    private static IdeAction renameImplAction;
    static final int CREATE_TEST_CMD_ID;
    private static IdeAction createTestAction;
    static final int RUN_TEST_CMD_ID;
    private static IdeAction runTestAction;
    static final int SYNC_TEST_CMD_ID;
    private static IdeAction syncTestAction;
    static final int PURGE_TEST_RESULTS_CMD_ID;
    private static IdeAction purgeTestResultsAction;
    static final int ADD_SUITE_CMD_ID;
    private static IdeAction addSuiteAction;
    static final int RENAME_SUITE_CMD_ID;
    private static IdeAction renameSuiteAction;
    static final int EXPORT_SUITE_CMD_ID;
    private static IdeAction exportSuiteAction;
    static final int ADD_TEST_CMD_ID;
    private static IdeAction addTestAction;
    static final int ADD_NESTED_SUITE_CMD_ID;
    private static IdeAction addNestedSuiteAction;
    static final int REMOVE_TEST_CMD_ID;
    private static IdeAction removeTestAction;
    static final int REMOVE_NESTED_SUITE_CMD_ID;
    private static IdeAction removeNestedSuiteAction;
    static final int COPY_TEST_CMD_ID;
    private static IdeAction copyTestAction;
    static final int RENAME_TEST_CMD_ID;
    private static IdeAction renameTestAction;
    static final int EXPORT_TEST_CMD_ID;
    private static IdeAction exportTestAction;
    static final int RUN_SUITE_CMD_ID;
    private static IdeAction runSuiteAction;
    static final int PURGE_SUITE_RESULTS_CMD_ID;
    private static IdeAction purgeSuiteResultsAction;
    static final int ADD_LIB_STARTUP_CMD_ID;
    private static IdeAction addLibStartupAction;
    static final int ADD_LIB_TEARDOWN_CMD_ID;
    private static IdeAction addLibTeardownAction;
    static final int ADD_LIB_VALIDATION_CMD_ID;
    private static IdeAction addLibValidationAction;
    static final int ADD_LIB_DVQ_CMD_ID;
    private static IdeAction addLibDvqAction;
    static final int DELETE_LIB_STARTUP_CMD_ID;
    private static IdeAction deleteLibStartupAction;
    static final int DELETE_LIB_TEARDOWN_CMD_ID;
    private static IdeAction deleteLibTeardownAction;
    static final int DELETE_LIB_VALIDATION_CMD_ID;
    private static IdeAction deleteLibValidationAction;
    static final int DELETE_LIB_DVQ_CMD_ID;
    private static IdeAction deleteLibDvqAction;
    static final int RENAME_LIB_STARTUP_CMD_ID;
    private static IdeAction renameLibStartupAction;
    static final int RENAME_LIB_TEARDOWN_CMD_ID;
    private static IdeAction renameLibTeardownAction;
    static final int RENAME_LIB_VALIDATION_CMD_ID;
    private static IdeAction renameLibValidationAction;
    static final int RENAME_LIB_DVQ_CMD_ID;
    private static IdeAction renameLibDvqAction;
    static final int COPY_LIB_STARTUP_CMD_ID;
    private static IdeAction copyLibStartupAction;
    static final int COPY_LIB_TEARDOWN_CMD_ID;
    private static IdeAction copyLibTeardownAction;
    static final int COPY_LIB_VALIDATION_CMD_ID;
    private static IdeAction copyLibValidationAction;
    static final int COPY_LIB_DVQ_CMD_ID;
    private static IdeAction copyLibDvqAction;
    static final int EXPORT_LIB_STARTUP_CMD_ID;
    private static IdeAction exportLibStartupAction;
    static final int EXPORT_LIB_TEARDOWN_CMD_ID;
    private static IdeAction exportLibTeardownAction;
    static final int EXPORT_LIB_VALIDATION_CMD_ID;
    private static IdeAction exportLibValidationAction;
    static final int EXPORT_LIB_DVQ_CMD_ID;
    private static IdeAction exportLibDvqAction;
    static final int ADD_INPUT_CATEGORY;
    private static IdeAction addCategoryAction;
    static final int DELETE_INPUT_CATEGORY;
    private static IdeAction delCategoryAction;
    static final int RENAME_INPUT_CATEGORY;
    private static IdeAction renCategoryAction;
    static final int ADD_INPUT_DATATYPE;
    private static IdeAction addDatatypeAction;
    static final int DELETE_INPUT_DATATYPE;
    private static IdeAction delDatatypeAction;
    static final int OPEN_ELEMENT_CMD_ID;
    private static IdeAction openElementAction;
    private String _implName = null;
    private boolean _editorIsEditingDisableExactTestImplMatch;

    protected static void ignore(Throwable throwable) {
        assert (throwable != null || null == throwable);
    }

    protected static void log(Throwable throwable) {
        UtNavigatorContextMenu.log(throwable, Level.WARNING);
    }

    protected static void log(Throwable throwable, Level level) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        UtNavigatorContextMenu.log(string, throwable, level);
    }

    protected static void log(String string, Throwable throwable, Level level) {
        LOGGER.log(level, string, throwable);
    }

    public static synchronized UtNavigatorContextMenu getInstance() {
        if (_instance == null) {
            _instance = new UtNavigatorContextMenu();
        }
        return _instance;
    }

    static void createActions() {
        addCategoryAction = IdeAction.get((int)ADD_INPUT_CATEGORY);
        addDatatypeAction = IdeAction.get((int)ADD_INPUT_DATATYPE);
        refreshAction = IdeAction.get((int)REFRESH_FOLDER_CMD_ID);
        exportMultiAction = IdeAction.get((int)EXPORT_MULTIPLE_CMD_ID);
        deleteAction = IdeAction.get((int)DELETE_FOLDER_CMD_ID);
        addImplAction = IdeAction.get((int)ADD_IMPL_FOLDER_CMD_ID);
        debugImplAction = IdeAction.get((int)DEBUG_IMPL_CMD_ID);
        renameImplAction = IdeAction.get((int)RENAME_IMPL_CMD_ID);
        createTestAction = IdeAction.get((int)CREATE_TEST_CMD_ID);
        runTestAction = IdeAction.get((int)RUN_TEST_CMD_ID);
        syncTestAction = IdeAction.get((int)SYNC_TEST_CMD_ID);
        purgeTestResultsAction = IdeAction.get((int)PURGE_TEST_RESULTS_CMD_ID);
        addSuiteAction = IdeAction.get((int)ADD_SUITE_CMD_ID);
        renameSuiteAction = IdeAction.get((int)RENAME_SUITE_CMD_ID);
        addTestAction = IdeAction.get((int)ADD_TEST_CMD_ID);
        addNestedSuiteAction = IdeAction.get((int)ADD_NESTED_SUITE_CMD_ID);
        removeNestedSuiteAction = IdeAction.get((int)REMOVE_NESTED_SUITE_CMD_ID);
        removeTestAction = IdeAction.get((int)REMOVE_TEST_CMD_ID);
        copyTestAction = IdeAction.get((int)COPY_TEST_CMD_ID);
        renameTestAction = IdeAction.get((int)RENAME_TEST_CMD_ID);
        exportTestAction = IdeAction.get((int)EXPORT_TEST_CMD_ID);
        exportSuiteAction = IdeAction.get((int)EXPORT_SUITE_CMD_ID);
        runSuiteAction = IdeAction.get((int)RUN_SUITE_CMD_ID);
        purgeSuiteResultsAction = IdeAction.get((int)PURGE_SUITE_RESULTS_CMD_ID);
        addLibStartupAction = IdeAction.get((int)ADD_LIB_STARTUP_CMD_ID);
        addLibTeardownAction = IdeAction.get((int)ADD_LIB_TEARDOWN_CMD_ID);
        addLibValidationAction = IdeAction.get((int)ADD_LIB_VALIDATION_CMD_ID);
        addLibDvqAction = IdeAction.get((int)ADD_LIB_DVQ_CMD_ID);
        deleteLibStartupAction = IdeAction.get((int)DELETE_LIB_STARTUP_CMD_ID);
        deleteLibTeardownAction = IdeAction.get((int)DELETE_LIB_TEARDOWN_CMD_ID);
        deleteLibValidationAction = IdeAction.get((int)DELETE_LIB_VALIDATION_CMD_ID);
        deleteLibDvqAction = IdeAction.get((int)DELETE_LIB_DVQ_CMD_ID);
        renameLibStartupAction = IdeAction.get((int)RENAME_LIB_STARTUP_CMD_ID);
        renameLibTeardownAction = IdeAction.get((int)RENAME_LIB_TEARDOWN_CMD_ID);
        renameLibValidationAction = IdeAction.get((int)RENAME_LIB_VALIDATION_CMD_ID);
        renameLibDvqAction = IdeAction.get((int)RENAME_LIB_DVQ_CMD_ID);
        copyLibStartupAction = IdeAction.get((int)COPY_LIB_STARTUP_CMD_ID);
        copyLibTeardownAction = IdeAction.get((int)COPY_LIB_TEARDOWN_CMD_ID);
        copyLibValidationAction = IdeAction.get((int)COPY_LIB_VALIDATION_CMD_ID);
        copyLibDvqAction = IdeAction.get((int)COPY_LIB_DVQ_CMD_ID);
        exportLibStartupAction = IdeAction.get((int)EXPORT_LIB_STARTUP_CMD_ID);
        exportLibTeardownAction = IdeAction.get((int)EXPORT_LIB_TEARDOWN_CMD_ID);
        exportLibValidationAction = IdeAction.get((int)EXPORT_LIB_VALIDATION_CMD_ID);
        exportLibDvqAction = IdeAction.get((int)EXPORT_LIB_DVQ_CMD_ID);
        delDatatypeAction = IdeAction.get((int)DELETE_INPUT_DATATYPE);
        delCategoryAction = IdeAction.get((int)DELETE_INPUT_CATEGORY);
        renCategoryAction = IdeAction.get((int)RENAME_INPUT_CATEGORY);
        openElementAction = IdeAction.get((int)OPEN_ELEMENT_CMD_ID);
    }

    private UtNavigatorContextMenu() {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean update(IdeAction ideAction, Context context) {
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof UtNavigatorWindow) {
            if (elementArray.length > 0) {
                if (elementArray[0] instanceof UtTestNode || elementArray[0] instanceof UtTestImplNode || elementArray[0] instanceof UtSuiteNode) {
                    if (ideAction.getCommandId() == 20) {
                        ideAction.setEnabled(true);
                        return true;
                    }
                } else if (ideAction.getCommandId() == 20) {
                    ideAction.setEnabled(false);
                    return true;
                }
            } else if (ideAction.getCommandId() == 20) {
                ideAction.setEnabled(false);
                return true;
            }
            if (ideAction.getCommandId() == 82) {
                ideAction.setEnabled(false);
                return true;
            }
            if (ideAction.getCommandId() == 77) {
                ideAction.setEnabled(false);
                return true;
            }
            return false;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (!this._actionsMade) {
            UtNavigatorContextMenu.createActions();
            this._actionsMade = true;
        }
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (context.getView() instanceof UtNavigatorWindow) {
            if (elementArray.length == 1) {
                NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
                if (elementArray[0] instanceof UtDefaultElement && this.canOpenElement(((NavigatorWindow)context.getView()).getTree(), (UtDefaultElement)elementArray[0])) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)openElementAction));
                }
                if (elementArray[0] instanceof UtDefaultFolder || elementArray[0] instanceof RootFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)refreshAction));
                }
                if (elementArray[0] instanceof UtTestFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)createTestAction));
                } else if (elementArray[0] instanceof UtTestNode) {
                    UtTestNode utTestNode = (UtTestNode)elementArray[0];
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)deleteAction);
                    jMenuItem.setText(UtAddinArb.getString("DELETE_TEST"));
                    contextMenu.add((Component)jMenuItem);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameTestAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyTestAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addImplAction));
                    jMenuItem = contextMenu.createMenuItem((ToggleAction)runTestAction);
                    jMenuItem.setEnabled(UtUtils.getTestImplCount(utTestNode.getId()) > 0);
                    contextMenu.add((Component)jMenuItem);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)purgeTestResultsAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)syncTestAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportTestAction));
                } else if (elementArray[0] instanceof UtTestImplNode) {
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)deleteAction);
                    jMenuItem.setText(UtAddinArb.getString("DELETE_IMPL"));
                    contextMenu.add((Component)jMenuItem);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameImplAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)debugImplAction));
                } else if (elementArray[0] instanceof UtSuiteFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addSuiteAction));
                } else if (elementArray[0] instanceof UtLookupRootFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addCategoryAction));
                } else if (elementArray[0] instanceof UtLookupCategoryFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)delCategoryAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addDatatypeAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renCategoryAction));
                } else if (elementArray[0] instanceof UtLookupNode) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)delDatatypeAction));
                } else if (elementArray[0] instanceof UtSuiteNode) {
                    JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)deleteAction);
                    jMenuItem.setText(UtAddinArb.getString("DELETE_SUITE"));
                    contextMenu.add((Component)jMenuItem);
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameSuiteAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)runSuiteAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)purgeSuiteResultsAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportSuiteAction));
                } else if (elementArray[0] instanceof UtNestedSuitesFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addNestedSuiteAction));
                } else if (elementArray[0] instanceof UtSuiteTestsFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addTestAction));
                } else if (elementArray[0] instanceof UtSuiteTestNode) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)removeTestAction));
                } else if (elementArray[0] instanceof UtNestedSuiteNode) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)removeNestedSuiteAction));
                } else if (elementArray[0] instanceof UtStartupsFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addLibStartupAction));
                } else if (elementArray[0] instanceof UtTeardownsFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addLibTeardownAction));
                } else if (elementArray[0] instanceof UtValidationsFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addLibValidationAction));
                } else if (elementArray[0] instanceof UtDynamicValueQueriesFolder) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)addLibDvqAction));
                } else if (elementArray[0] instanceof UtStartupElement) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteLibStartupAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameLibStartupAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyLibStartupAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportLibStartupAction));
                } else if (elementArray[0] instanceof UtTeardownElement) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteLibTeardownAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameLibTeardownAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyLibTeardownAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportLibTeardownAction));
                } else if (elementArray[0] instanceof UtValidationElement) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteLibValidationAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameLibValidationAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyLibValidationAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportLibValidationAction));
                } else if (elementArray[0] instanceof UtDynamicValueQueryElement) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)deleteLibDvqAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)renameLibDvqAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)copyLibDvqAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportLibDvqAction));
                }
            } else {
                NavigatorConstants.removeNewMenuItem((ContextMenu)contextMenu);
                boolean bl = true;
                for (Element element : elementArray) {
                    if (!bl) break;
                    if (element instanceof UtTestNode || element instanceof UtSuiteNode || element instanceof UtStartupElement || element instanceof UtTeardownElement || element instanceof UtValidationElement || element instanceof UtDynamicValueQueryElement) continue;
                    bl = false;
                }
                if (bl) {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)refreshAction));
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)exportMultiAction));
                } else {
                    contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)refreshAction));
                }
            }
        }
    }

    private void runTest(Context context) {
        Element[] elementArray;
        for (Element element : elementArray = context.getSelection()) {
            if (!(element instanceof UtTestNode) || !(context.getView() instanceof UtNavigatorWindow)) continue;
            this._editorIsEditingDisableExactTestImplMatch = true;
            this.run(((NavigatorWindow)context.getView()).getTree(), (UtTestNode)element);
            this._editorIsEditingDisableExactTestImplMatch = false;
        }
    }

    private void syncTest(Context context) {
        Element[] elementArray = context.getSelection();
        SyncTestWizMain.launch(((UtTestNode)elementArray[0]).getId());
    }

    private void purgeTestResults(Context context) {
        Element[] elementArray = context.getSelection();
        PurgeResultsDialog.purgeTest(((UtTestNode)elementArray[0]).getId());
    }

    private void purgeSuiteResults(Context context) {
        Element[] elementArray = context.getSelection();
        PurgeResultsDialog.purgeSuite(((UtSuiteNode)elementArray[0]).getId());
    }

    private void run(NavigatorTree navigatorTree, UtDefaultElement utDefaultElement) {
        IdeAction ideAction;
        UtEditor utEditor;
        if (this.canOpenElement(navigatorTree, utDefaultElement) && null != (utEditor = this.openElement(utDefaultElement, false)) && null != (ideAction = utEditor.getRunAction())) {
            try {
                ideAction.performAction();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception);
            }
        }
    }

    private void createTest(Context context) {
        CreateWizMain.launch(null);
        this.refreshTreeNode(context);
    }

    private void runSuite(Context context) {
        Element[] elementArray;
        for (Element element : elementArray = context.getSelection()) {
            if (!(element instanceof UtSuiteNode) || !(context.getView() instanceof UtNavigatorWindow)) continue;
            this.run(((NavigatorWindow)context.getView()).getTree(), (UtSuiteNode)element);
        }
    }

    private void debugImpl(Context context) {
        Element[] elementArray;
        for (Element element : elementArray = context.getSelection()) {
            if (!(element instanceof UtTestImplNode)) continue;
            String string = UtUtils.getTestImplConnectionName(((UtTestImplNode)element).getId());
            if ((string = this.verifyDataConnectionQualName(string)) == null) break;
            try {
                Debugger debugger = new Debugger(string);
                UtTestImpl utTestImpl = new UtTestImpl(((UtTestImplNode)element).getId());
                debugger.debugImpl(utTestImpl);
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameImpl(Context context) {
        Object object;
        DBUtil dBUtil;
        UtTestImplNode utTestImplNode = (UtTestImplNode)context.getSelection()[0];
        UtTestImpl utTestImpl = new UtTestImpl(utTestImplNode.getId());
        String string = this.getImplName(UtAddinArb.getString("RENAME_IMPL_TITLE"), utTestImpl.getName(), utTestImpl.getUtId());
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = UtUtils.getQuery("renameImpl");
                hashMap.put("ID", utTestImpl.getUtiId());
                hashMap.put("NAME", string);
                dBUtil.executeUpdate((String)object, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        utTestImplNode.setName(string);
        dBUtil = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        this.refreshParentTreeNode(context, (NavigatorTreeNode)dBUtil);
        object = EditorManager.getEditorManager().getAllEditors();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            UtSuiteEditor utSuiteEditor;
            String string2;
            Editor editor = (Editor)iterator.next();
            if (!(editor instanceof UtSuiteEditor) || !(string2 = (utSuiteEditor = (UtSuiteEditor)editor).getElementId()).equals(utTestImpl.getUtId())) continue;
            UtTestEditorNode utTestEditorNode = (UtTestEditorNode)utSuiteEditor.getContext().getNode();
            utTestEditorNode.setViewedObject(utTestImplNode);
        }
    }

    private void refreshNode(Context context) {
        Element[] elementArray;
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        if (navigatorTreeNode != null && (elementArray = context.getView()) instanceof NavigatorWindow) {
            NavigatorTree navigatorTree = ((NavigatorWindow)elementArray).getTree();
            navigatorTree.refresh(navigatorTreeNode);
        }
        if ((elementArray = context.getSelection()).length > 0 && elementArray[0] instanceof RootFolder) {
            ((RootFolder)elementArray[0]).reset();
        }
    }

    private void delete(Context context) {
        Element[] elementArray;
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE"), (String)UtAddinArb.getString("DELETE_TITLE"), null, (boolean)true)) {
            return;
        }
        for (Element element : elementArray = context.getSelection()) {
            if (element instanceof UtTestNode) {
                this.deleteNode(context, (UtTestNode)element);
                continue;
            }
            if (element instanceof UtTestImplNode) {
                this.deleteImpl(context, (UtTestImplNode)element);
                continue;
            }
            if (!(element instanceof UtSuiteNode)) continue;
            this.deleteSuite(context, (UtSuiteNode)element);
        }
    }

    private void deleteSuite(Context context, UtSuiteNode utSuiteNode) {
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        UtUtils.deleteSuite(utSuiteNode.getId());
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            UtSuiteEditor utSuiteEditor;
            String string;
            if (!(editor instanceof UtSuiteEditor) || !(string = (utSuiteEditor = (UtSuiteEditor)editor).getElementId()).equals(utSuiteNode.getId())) continue;
            ArrayList<UtSuiteEditor> arrayList = new ArrayList<UtSuiteEditor>();
            arrayList.add(utSuiteEditor);
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    private void deleteNode(Context context, UtTestNode utTestNode) {
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        UtUtils.deleteTest(utTestNode.getId());
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            UtTestEditor utTestEditor;
            String string;
            if (!(editor instanceof UtTestEditor) || !(string = (utTestEditor = (UtTestEditor)editor).getUtId()).equals(utTestNode.getId())) continue;
            ArrayList<UtTestEditor> arrayList = new ArrayList<UtTestEditor>();
            arrayList.add(utTestEditor);
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    private void deleteImpl(Context context, UtTestImplNode utTestImplNode) {
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        UtUtils.deleteTestImpl(utTestImplNode.getId());
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            UtTestEditor utTestEditor;
            String string;
            if (!(editor instanceof UtTestEditor) || !(string = (utTestEditor = (UtTestEditor)editor).getUtiId()).equals(utTestImplNode.getId())) continue;
            ArrayList<UtTestEditor> arrayList = new ArrayList<UtTestEditor>();
            arrayList.add(utTestEditor);
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    private void addImpl(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtTestNode) {
            UtTest utTest = new UtTest(((UtTestNode)elementArray[0]).getId());
            String string = this.getImplName(UtAddinArb.getString("IMPL_TITLE"), utTest.getNextImplName(), utTest.getId());
            if (string != null) {
                utTest.createTestImpl(string, null, null);
                try {
                    utTest.save(false);
                }
                catch (ObjectUpdateException objectUpdateException) {
                    UtNavigatorContextMenu.ignore(objectUpdateException);
                }
            }
        }
        this.refreshTreeNode(context);
    }

    private String getImplName(String string, String string2, String string3) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextField jTextField = null;
        jTextField = new JTextField(string2);
        jPanel.add((Component)new JLabel(UtAddinArb.getString("IMPL_NAME_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        if (string.equals(UtAddinArb.getString("IMPL_TITLE"))) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_impl_dialog_html");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_rename_impl_dialog_html");
        }
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string);
        if (bl) {
            String string4 = jTextField.getText().trim();
            if (string4.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("EMPTY_NAME"), (String)UtAddinArb.getString("EMPTY_NAME_TITLE"), null);
                return this.getImplName(string, jTextField.getText(), string3);
            }
            if (UtUtils.isImplNameUsed(jTextField.getText(), string3)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getImplName(string, jTextField.getText(), string3);
            }
            return jTextField.getText();
        }
        return null;
    }

    private String getSuiteName(String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextField jTextField = null;
        jTextField = string2 == null ? new JTextField("NEW SUITE") : new JTextField(string2);
        jPanel.add((Component)new JLabel(UtAddinArb.getString("SUITE_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_suite_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string);
        if (bl) {
            String string3 = jTextField.getText().trim();
            if (string3.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("EMPTY_NAME"), (String)UtAddinArb.getString("EMPTY_NAME_TITLE"), null);
                return this.getSuiteName(string, jTextField.getText());
            }
            if (UtUtils.isSuiteNameUsed(string3)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getSuiteName(string, jTextField.getText());
            }
            return string3;
        }
        return null;
    }

    private String getCategoryName(String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextField jTextField = null;
        jTextField = new JTextField(string2);
        jPanel.add((Component)new JLabel(UtAddinArb.getString("CATEGORY_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_category_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string);
        if (bl) {
            if (UtUtils.isCategoryNameUsed(jTextField.getText().trim())) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getCategoryName(string, jTextField.getText());
            }
            if (jTextField.getText().trim().equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("NULL_CATEGORY"), (String)UtAddinArb.getString("NULL_CATEGORY"), null);
                return this.getCategoryName(string, jTextField.getText());
            }
            return jTextField.getText().trim();
        }
        return null;
    }

    private PairElement getDatatypeName(String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string3 = UtAddinArb.getString("DATATYPE_TITLE");
        ArrayList<PairElement> arrayList = UtUtils.getDataTypePairs();
        ArrayList<PairElement> arrayList2 = UtUtils.getLookupDataTypePairs(UtUtils.getLookupCategoryPair(string2), null);
        ArrayList arrayList3 = (ArrayList)arrayList.clone();
        for (PairElement pairElement : arrayList2) {
            for (PairElement pairElement2 : arrayList) {
                if (!pairElement.getName().equals(pairElement2.getName())) continue;
                arrayList3.remove(pairElement2);
            }
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList3.toArray());
        UiUtils.nameForQA(jComboBox, "DataType", new String[0]);
        if (string != null) {
            jComboBox.setSelectedItem(string);
        }
        jPanel.add((Component)new JLabel(UtAddinArb.getString("DATATYPE")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_datatype_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jComboBox, (String)string3);
        if (bl) {
            if (UtUtils.isDatatypeNameUsed(((PairElement)jComboBox.getSelectedItem()).getName(), string2)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getDatatypeName((String)jComboBox.getSelectedItem(), string2);
            }
            return (PairElement)jComboBox.getSelectedItem();
        }
        return null;
    }

    private String getLibItemName(String string, String string2, String string3, ICodeHook iCodeHook) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextField jTextField = null;
        jTextField = string3 == null ? new JTextField("NEW ITEM") : new JTextField(string3);
        jPanel.add((Component)new JLabel(string2), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_lib_item_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string);
        if (bl) {
            String string4 = jTextField.getText().trim();
            if (string4.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("EMPTY_NAME"), (String)UtAddinArb.getString("EMPTY_NAME_TITLE"), null);
                return this.getLibItemName(string, string2, jTextField.getText(), iCodeHook);
            }
            boolean bl2 = UtUtils.isLibNameUsed(iCodeHook, string4);
            if (bl2) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getLibItemName(string, string2, jTextField.getText(), iCodeHook);
            }
            return string4;
        }
        return null;
    }

    private String getTestName(String string, String string2) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JTextField jTextField = null;
        jTextField = string2 == null ? new JTextField() : new JTextField(string2);
        jPanel.add((Component)new JLabel(UtAddinArb.getString("TEST_COPY_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_copy_test_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jTextField, (String)string);
        if (bl) {
            String string3 = jTextField.getText().trim();
            if (string3.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("EMPTY_NAME"), (String)UtAddinArb.getString("EMPTY_NAME_TITLE"), null);
                return this.getTestName(string, jTextField.getText());
            }
            if (UtUtils.isTestNameUsed(jTextField.getText())) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("DUPLICATE_TEST"), (String)UtAddinArb.getString("DUPLICATE_TITLE"), null);
                return this.getTestName(string, jTextField.getText());
            }
            return jTextField.getText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTest(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtTestNode) {
            String string = ((UtTestNode)elementArray[0]).getId();
            String string2 = this.getTestName(UtAddinArb.getString("TEST_COPY_TITLE"), UtAddinArb.getString("COPY_PREFIX") + " " + ((UtTestNode)elementArray[0]).getName());
            if (string2 == null) {
                return;
            }
            NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string3 = UtUtils.getQuery("copyTest");
                    hashMap.put("OLD_UT_ID", string);
                    hashMap.put("NEW_NAME", string2);
                    dBUtil.executeUpdate(string3, hashMap);
                    connection.commit();
                }
                catch (Exception exception) {
                    UtNavigatorContextMenu.log(exception, Level.SEVERE);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            this.refreshParentTreeNode(context, navigatorTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameTest(Context context) {
        Object object;
        DBUtil dBUtil;
        UtTestNode utTestNode = (UtTestNode)context.getSelection()[0];
        UtTest utTest = new UtTest(utTestNode.getId());
        String string = this.getTestName(UtAddinArb.getString("RENAME_TEST_TITLE"), utTest.getTestName());
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = UtUtils.getQuery("renameTest");
                hashMap.put("ID", utTest.getId());
                hashMap.put("NAME", string);
                dBUtil.executeUpdate((String)object, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        utTestNode.setName(string);
        dBUtil = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        this.refreshParentTreeNode(context, (NavigatorTreeNode)dBUtil);
        object = EditorManager.getEditorManager().getAllEditors();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            UtTestEditor utTestEditor;
            String string2;
            Editor editor = (Editor)iterator.next();
            if (!(editor instanceof UtTestEditor) || !(string2 = (utTestEditor = (UtTestEditor)editor).getUtId()).equals(utTest.getId())) continue;
            UtTestEditorNode utTestEditorNode = (UtTestEditorNode)utTestEditor.getContext().getNode();
            utTestEditorNode.setViewedObject(utTestNode);
        }
    }

    private void exportTest(Context context) {
        UtTestNode utTestNode = (UtTestNode)context.getSelection()[0];
        final String string = utTestNode.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(UtUtils.getDefaultImportExportDirectory() + File.separator + utTestNode.getName() + ".xml");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportTestById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private void exportSuite(Context context) {
        UtSuiteNode utSuiteNode = (UtSuiteNode)context.getSelection()[0];
        final String string = utSuiteNode.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(utSuiteNode.getName());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportSuiteById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private void exportMultiple(Context context) {
        this.els = context.getSelection();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter("UtExport");
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block14: {
                    try {
                        if (exportFileInfo == null) break block14;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                for (Element element : UtNavigatorContextMenu.this.els) {
                                    if (element instanceof UtTestNode) {
                                        exportManager.exportTest(((UtTestNode)element).getName(), (ExportListener)exportListenerImpl);
                                        continue;
                                    }
                                    if (element instanceof UtSuiteNode) {
                                        exportManager.exportSuite(((UtSuiteNode)element).getName(), (ExportListener)exportListenerImpl);
                                        continue;
                                    }
                                    if (element instanceof UtStartupElement) {
                                        exportManager.exportLibStartup(((UtStartupElement)element).getName(), exportListenerImpl);
                                        continue;
                                    }
                                    if (element instanceof UtTeardownElement) {
                                        exportManager.exportLibTeardown(((UtTeardownElement)element).getName(), exportListenerImpl);
                                        continue;
                                    }
                                    if (element instanceof UtValidationElement) {
                                        exportManager.exportLibValidation(((UtValidationElement)element).getName(), exportListenerImpl);
                                        continue;
                                    }
                                    if (!(element instanceof UtDynamicValueQueryElement)) continue;
                                    exportManager.exportLibDynamicValueQuery(((UtDynamicValueQueryElement)element).getName(), exportListenerImpl);
                                }
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameSuite(Context context) {
        Object object;
        DBUtil dBUtil;
        UtSuiteNode utSuiteNode = (UtSuiteNode)context.getSelection()[0];
        UtSuite utSuite = new UtSuite(utSuiteNode.getId());
        String string = this.getSuiteName(UtAddinArb.getString("RENAME_SUITE_TITLE"), utSuite.getSuiteName());
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = UtUtils.getQuery("renameSuite");
                hashMap.put("ID", utSuite.getSid());
                hashMap.put("NAME", string);
                dBUtil.executeUpdate((String)object, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        utSuiteNode.setName(string);
        dBUtil = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        this.refreshParentTreeNode(context, (NavigatorTreeNode)dBUtil);
        object = EditorManager.getEditorManager().getAllEditors();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            UtSuiteEditor utSuiteEditor;
            String string2;
            Editor editor = (Editor)iterator.next();
            if (!(editor instanceof UtSuiteEditor) || !(string2 = (utSuiteEditor = (UtSuiteEditor)editor).getElementId()).equals(utSuite.getSid())) continue;
            UtSuiteEditorNode utSuiteEditorNode = (UtSuiteEditorNode)utSuiteEditor.getContext().getNode();
            utSuiteEditorNode.setViewedObject(utSuiteNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameLookupCategory(Context context) {
        PairElement pairElement;
        Object object;
        DBUtil dBUtil;
        UtLookupCategoryFolder utLookupCategoryFolder = (UtLookupCategoryFolder)context.getSelection()[0];
        String string = this.getCategoryName(UtAddinArb.getString("RENAME_CATEGORY_TITLE"), utLookupCategoryFolder.getName());
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = UtUtils.getQuery("renameLookupCategory");
                hashMap.put("ID", utLookupCategoryFolder.getId());
                hashMap.put("NAME", string);
                dBUtil.executeUpdate((String)object, hashMap);
                connection.commit();
                pairElement = new PairElement(utLookupCategoryFolder.getId(), string);
                UtConfig.getInstance().setPairElement("LOOKUP_CATEGORY", pairElement);
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        utLookupCategoryFolder.setName(string);
        dBUtil = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        this.refreshParentTreeNode(context, (NavigatorTreeNode)dBUtil);
        object = EditorManager.getEditorManager().getAllEditors();
        pairElement = object.iterator();
        while (pairElement.hasNext()) {
            UtLookupEditor utLookupEditor;
            UtLookupEditorNode utLookupEditorNode;
            UtLookupNode utLookupNode;
            Editor editor = (Editor)pairElement.next();
            if (!(editor instanceof UtLookupEditor) || !(utLookupNode = (UtLookupNode)(utLookupEditorNode = (UtLookupEditorNode)(utLookupEditor = (UtLookupEditor)editor).getContext().getNode()).getElement()).getCatId().equals(utLookupCategoryFolder.getId())) continue;
            UtLookupEditorNode utLookupEditorNode2 = (UtLookupEditorNode)utLookupEditor.getContext().getNode();
            ((UtLookupNode)utLookupEditorNode2.getElement()).setCategory(string);
            utLookupNode.setCategory(string);
            utLookupEditorNode2.setViewedObject(utLookupNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuite(Context context) {
        int n = UtUtils.getSuiteCount() + 1;
        String string = UtAddinArb.format("NEW_SUITE_NAME", n);
        string = this.getSuiteName(UtAddinArb.getString("SUITE_TITLE"), string);
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = UtUtils.getQuery("mergeSuite");
                hashMap.put("UT_SID", UUID.randomUUID().toString());
                hashMap.put("COVERAGE", "0");
                hashMap.put("NAME", string);
                dBUtil.executeUpdate(string2, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this.refreshTreeNode(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCategory(Context context) {
        int n = UtUtils.getLookupCategoryCount() + 1;
        String string = UtAddinArb.format("NEW_LOOKUP_CATEGORY_NAME", n);
        string = this.getCategoryName(UtAddinArb.getString("CATEGORY_TITLE"), string);
        if (string == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = UtUtils.getQuery("mergeLookupCategory");
                hashMap.put("ID", UUID.randomUUID().toString());
                hashMap.put("NAME", string);
                dBUtil.executeUpdate(string2, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this.refreshTreeNode(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatatype(Context context) {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        UtLookupCategoryFolder utLookupCategoryFolder = (UtLookupCategoryFolder)context.getSelection()[0];
        ArrayList<PairElement> arrayList = null;
        boolean bl = false;
        if (bl) {
            object3 = UtUtils.getDataTypePairs();
            PairElement pairElement = UtUtils.getLookupDataTypePairs(UtUtils.getLookupCategoryPair(utLookupCategoryFolder.getId()), null);
            arrayList = (ArrayList<PairElement>)((ArrayList)object3).clone();
            serializable = new StringBuilder();
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = (PairElement)object2.next();
                ((StringBuilder)serializable).append(object.getName()).append(", ").append(object.getID()).append('\n');
            }
            object2 = ((StringBuilder)serializable).toString();
            if (null == object2) {
                // empty if block
            }
            for (Object object4 : pairElement) {
                Iterator iterator = ((ArrayList)object3).iterator();
                while (iterator.hasNext()) {
                    PairElement pairElement2 = (PairElement)iterator.next();
                    if (!object4.getName().equals(pairElement2.getName())) continue;
                    arrayList.remove(pairElement2);
                }
            }
        } else {
            object3 = this.getDatatypeName(null, utLookupCategoryFolder.getId());
            if (object3 == null) {
                return;
            }
            arrayList = new ArrayList<PairElement>(1);
            arrayList.add((PairElement)object3);
        }
        for (PairElement pairElement : arrayList) {
            serializable = new HashMap();
            object2 = UtAddin.getRepositoryManager().getConnection();
            if (!Connections.getInstance().lock((Connection)object2)) continue;
            try {
                Object object4;
                object = DBUtil.getInstance((Connection)object2);
                object.setRaiseError(true);
                object4 = UtUtils.getQuery("mergeLookupDatatype");
                ((HashMap)serializable).put("ID", UUID.randomUUID().toString());
                ((HashMap)serializable).put("CAT_ID", utLookupCategoryFolder.getId());
                ((HashMap)serializable).put("TYPE_ID", pairElement.getID());
                ((HashMap)serializable).put("TYPE_STRING", pairElement.getName());
                object.executeUpdate((String)object4, (Map)((Object)serializable));
                object2.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock((Connection)object2);
            }
        }
        this.refreshTreeNode(context);
    }

    private void addTest(Context context) {
        String string;
        SuiteItemPickerDialog suiteItemPickerDialog;
        boolean bl;
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtSuiteTestsFolder && (bl = (suiteItemPickerDialog = new SuiteItemPickerDialog()).runDialog(string = ((UtSuiteTestsFolder)elementArray[0]).getSuiteId(), SuiteItemPickerDialog.Tabs.TESTS_ONLY))) {
            UtSuite utSuite = new UtSuite(string);
            for (UtSuite.SuiteItem suiteItem : suiteItemPickerDialog.getSuiteItems()) {
                utSuite.addItem(suiteItem);
            }
            try {
                utSuite.save(false);
            }
            catch (ObjectUpdateException objectUpdateException) {
                UtNavigatorContextMenu.ignore(objectUpdateException);
            }
        }
        this.refreshTreeNode(context);
    }

    private void addNestedSuite(Context context) {
        String string;
        SuiteItemPickerDialog suiteItemPickerDialog;
        boolean bl;
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtNestedSuitesFolder && (bl = (suiteItemPickerDialog = new SuiteItemPickerDialog()).runDialog(string = ((UtNestedSuitesFolder)elementArray[0]).getSuiteId(), SuiteItemPickerDialog.Tabs.SUITES_ONLY))) {
            UtSuite utSuite = new UtSuite(string);
            for (UtSuite.SuiteItem suiteItem : suiteItemPickerDialog.getSuiteItems()) {
                utSuite.addItem(suiteItem);
            }
            try {
                utSuite.save(false);
            }
            catch (ObjectUpdateException objectUpdateException) {
                UtNavigatorContextMenu.ignore(objectUpdateException);
            }
        }
        this.refreshTreeNode(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTest(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtSuiteTestNode) {
            NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
            String string = ((UtSuiteTestNode)elementArray[0]).getSuiteId();
            String string2 = ((UtSuiteTestNode)elementArray[0]).getId();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string3 = UtUtils.getQuery("removeSuiteTest");
                    hashMap.put("SUITE_ID", string);
                    hashMap.put("TEST_ID", string2);
                    dBUtil.executeUpdate(string3, hashMap);
                    connection.commit();
                }
                catch (Exception exception) {
                    UtNavigatorContextMenu.log(exception, Level.SEVERE);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            this.refreshParentTreeNode(context, navigatorTreeNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNestedSuite(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray[0] instanceof UtNestedSuiteNode) {
            NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
            String string = ((UtNestedSuiteNode)elementArray[0]).getSuiteId();
            String string2 = ((UtNestedSuiteNode)elementArray[0]).getId();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string3 = UtUtils.getQuery("removeNestedSuite");
                    hashMap.put("SUITE_ID", string);
                    hashMap.put("NESTED_SUITE_ID", string2);
                    dBUtil.executeUpdate(string3, hashMap);
                    connection.commit();
                }
                catch (Exception exception) {
                    UtNavigatorContextMenu.log(exception, Level.SEVERE);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            this.refreshParentTreeNode(context, navigatorTreeNode);
        }
    }

    private void addLibStartup(Context context) {
        UtStartupsFolder utStartupsFolder = (UtStartupsFolder)context.getSelection()[0];
        String string = utStartupsFolder.getShortLabel();
        IStartup iStartup = StartupRegistry.getInstanceFor(string);
        this.addLibItem(context, UtAddinArb.getString("ADD_STARTUP_TITLE"), UtAddinArb.getString("STARTUP_LABEL"), "mergeLibStartup", iStartup);
    }

    private void addLibTeardown(Context context) {
        UtTeardownsFolder utTeardownsFolder = (UtTeardownsFolder)context.getSelection()[0];
        String string = utTeardownsFolder.getShortLabel();
        ITeardown iTeardown = TearDownRegistry.getInstanceFor(string);
        this.addLibItem(context, UtAddinArb.getString("ADD_TEARDOWN_TITLE"), UtAddinArb.getString("TEARDOWN_LABEL"), "mergeLibTeardown", iTeardown);
    }

    private void addLibValidation(Context context) {
        UtValidationsFolder utValidationsFolder = (UtValidationsFolder)context.getSelection()[0];
        String string = utValidationsFolder.getShortLabel();
        IValidation iValidation = ValidationRegistry.getInstanceFor(string);
        this.addLibItem(context, UtAddinArb.getString("ADD_VALIDATION_TITLE"), UtAddinArb.getString("VALIDATION_LABEL"), "mergeLibValidation", iValidation);
    }

    private void addLibDvq(Context context) {
        DynamicValueQuery dynamicValueQuery = new DynamicValueQuery();
        this.addLibItem(context, UtAddinArb.getString("ADD_DVQ_TITLE"), UtAddinArb.getString("DVQ_LABEL"), "mergeLibDynQuery", dynamicValueQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibItem(Context context, String string, String string2, String string3, ICodeHook iCodeHook) {
        int n = UtUtils.getLibCount(iCodeHook) + 1;
        String string4 = UtAddinArb.format("NEW_LIBRARY_NAME", n, iCodeHook.getHookName());
        if ((string4 = this.getLibItemName(string, string2, string4, iCodeHook)) == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string5 = UtUtils.getQuery(string3);
                hashMap.put("LIB_ID", UUID.randomUUID().toString());
                hashMap.put("NAME", string4);
                hashMap.put("CLASS", iCodeHook.getClass().getName());
                hashMap.put("XML", iCodeHook.getXml());
                dBUtil.executeUpdate(string5, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this.refreshTreeNode(context);
    }

    private void deleteLibStartup(Context context) {
        UtStartupElement utStartupElement = (UtStartupElement)context.getSelection()[0];
        this.deleteLibItem(context, "referencedLibStartup", "deleteLibStartup", utStartupElement.getId());
    }

    private void deleteLibTeardown(Context context) {
        UtTeardownElement utTeardownElement = (UtTeardownElement)context.getSelection()[0];
        this.deleteLibItem(context, "referencedLibTeardown", "deleteLibTeardown", utTeardownElement.getId());
    }

    private void deleteLibValidation(Context context) {
        UtValidationElement utValidationElement = (UtValidationElement)context.getSelection()[0];
        this.deleteLibItem(context, "referencedLibValidation", "deleteLibValidation", utValidationElement.getId());
    }

    private void deleteLibDvq(Context context) {
        UtDynamicValueQueryElement utDynamicValueQueryElement = (UtDynamicValueQueryElement)context.getSelection()[0];
        this.deleteLibItem(context, "referencedLibDvq", "deleteLibDvq", utDynamicValueQueryElement.getId());
    }

    private void deleteLookupCategory(Context context) {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE"), (String)UtAddinArb.getString("DELETE_TITLE"), null, (boolean)true)) {
            return;
        }
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        UtLookupCategoryFolder utLookupCategoryFolder = (UtLookupCategoryFolder)context.getSelection()[0];
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            UtLookupEditor utLookupEditor;
            String string;
            if (!(editor instanceof UtLookupEditor) || !(string = (utLookupEditor = (UtLookupEditor)editor).getDetails().getCategory().getID()).equals(utLookupCategoryFolder.getId())) continue;
            ArrayList<UtLookupEditor> arrayList = new ArrayList<UtLookupEditor>();
            arrayList.add(utLookupEditor);
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        UtUtils.deleteLookupCatogory(utLookupCategoryFolder.getId());
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    private void deleteLookupDatatype(Context context) {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE"), (String)UtAddinArb.getString("DELETE_TITLE"), null, (boolean)true)) {
            return;
        }
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        UtLookupNode utLookupNode = (UtLookupNode)context.getSelection()[0];
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            UtLookupEditor utLookupEditor;
            String string;
            if (!(editor instanceof UtLookupEditor) || !(string = (utLookupEditor = (UtLookupEditor)editor).getDetails().getDatatype().getID()).equals(utLookupNode.getId())) continue;
            ArrayList<UtLookupEditor> arrayList = new ArrayList<UtLookupEditor>();
            arrayList.add(utLookupEditor);
            EditorManager.getEditorManager().closeEditors(arrayList);
        }
        UtUtils.deleteLookupDatatype(utLookupNode.getId());
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLibItem(Context context, String string, String string2, String string3) {
        String string4;
        Object object;
        Object object2;
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("CONFIRM_DELETE"), (String)UtAddinArb.getString("DELETE_TITLE"), null, (boolean)true)) {
            return;
        }
        NavigatorTreeNode navigatorTreeNode = this.getNearestSiblingToSelectedNode(context);
        boolean bl = true;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                object2 = DBUtil.getInstance((Connection)connection);
                object = UtUtils.getQuery(string);
                hashMap.put("ID", string3);
                string4 = object2.executeReturnOneCol((String)object, hashMap);
                bl = !string4.equals("0");
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        if (bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("REFERENCED_LIB_ITEM"), (String)UtAddinArb.getString("REFERENCED_LIB_ITEM_TITLE"), null);
        } else {
            hashMap = new HashMap();
            if (Connections.getInstance().lock(connection)) {
                try {
                    object2 = DBUtil.getInstance((Connection)connection);
                    object2.setRaiseError(true);
                    object = UtUtils.getQuery(string2);
                    hashMap.put("ID", string3);
                    object2.executeUpdate((String)object, hashMap);
                    connection.commit();
                }
                catch (Exception exception) {
                    UtNavigatorContextMenu.log(exception, Level.SEVERE);
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
            object2 = EditorManager.getEditorManager().getAllEditors();
            object = object2.iterator();
            while (object.hasNext()) {
                UtLibraryEditor utLibraryEditor;
                String string5;
                string4 = (Editor)object.next();
                if (!(string4 instanceof UtLibraryEditor) || !(string5 = (utLibraryEditor = (UtLibraryEditor)((Object)string4)).getElementId()).equals(string3)) continue;
                ArrayList<UtLibraryEditor> arrayList = new ArrayList<UtLibraryEditor>();
                arrayList.add(utLibraryEditor);
                EditorManager.getEditorManager().closeEditors(arrayList);
            }
            this.refreshParentTreeNode(context, navigatorTreeNode);
        }
    }

    private void renameLibStartup(Context context) {
        UtStartupElement utStartupElement = (UtStartupElement)context.getSelection()[0];
        this.renameLibItem(context, UtAddinArb.getString("RENAME_STARTUP_TITLE"), UtAddinArb.getString("STARTUP_LABEL"), "renameLibStartup", utStartupElement, new UtLibraryItem(UtLibraryItem.Kind.STARTUP, utStartupElement.getId()));
    }

    private void renameLibTeardown(Context context) {
        UtTeardownElement utTeardownElement = (UtTeardownElement)context.getSelection()[0];
        this.renameLibItem(context, UtAddinArb.getString("RENAME_TEARDOWN_TITLE"), UtAddinArb.getString("TEARDOWN_LABEL"), "renameLibTeardown", utTeardownElement, new UtLibraryItem(UtLibraryItem.Kind.TEARDOWN, utTeardownElement.getId()));
    }

    private void renameLibValidation(Context context) {
        UtValidationElement utValidationElement = (UtValidationElement)context.getSelection()[0];
        this.renameLibItem(context, UtAddinArb.getString("RENAME_VALIDATION_TITLE"), UtAddinArb.getString("VALIDATION_LABEL"), "renameLibValidation", utValidationElement, new UtLibraryItem(UtLibraryItem.Kind.VALIDATION, utValidationElement.getId()));
    }

    private void renameLibDvq(Context context) {
        UtDynamicValueQueryElement utDynamicValueQueryElement = (UtDynamicValueQueryElement)context.getSelection()[0];
        this.renameLibItem(context, UtAddinArb.getString("RENAME_DVQ_TITLE"), UtAddinArb.getString("DVQ_LABEL"), "renameLibDvq", utDynamicValueQueryElement, new UtLibraryItem(UtLibraryItem.Kind.DYNAMIC_VALUE_QUERY, utDynamicValueQueryElement.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameLibItem(Context context, String string, String string2, String string3, UtDefaultElement utDefaultElement, UtLibraryItem utLibraryItem) {
        Object object;
        DBUtil dBUtil;
        ICodeHook iCodeHook = utLibraryItem.createCodeHook();
        String string4 = this.getLibItemName(string, string2, utLibraryItem.getRef().getName(), iCodeHook);
        if (string4 == null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = UtUtils.getQuery(string3);
                hashMap.put("LIB_ID", utLibraryItem.getRef().getLibId());
                hashMap.put("NAME", string4);
                dBUtil.executeUpdate((String)object, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        utDefaultElement.setName(string4);
        dBUtil = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        this.refreshParentTreeNode(context, (NavigatorTreeNode)dBUtil);
        object = EditorManager.getEditorManager().getAllEditors();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            UtLibraryEditor utLibraryEditor;
            String string5;
            Editor editor = (Editor)iterator.next();
            if (!(editor instanceof UtLibraryEditor) || !(string5 = (utLibraryEditor = (UtLibraryEditor)editor).getElementId()).equals(utLibraryItem.getRef().getLibId())) continue;
            UtLibraryEditorNode utLibraryEditorNode = (UtLibraryEditorNode)utLibraryEditor.getContext().getNode();
            utLibraryEditorNode.setViewedObject(utDefaultElement);
        }
    }

    private void copyLibStartup(Context context) {
        UtStartupElement utStartupElement = (UtStartupElement)context.getSelection()[0];
        UtLibraryItem utLibraryItem = new UtLibraryItem(UtLibraryItem.Kind.STARTUP, utStartupElement.getId());
        IStartup iStartup = StartupRegistry.getInstanceFor(utLibraryItem.getImplKey());
        this.copyLibItem(context, UtAddinArb.getString("STARTUP_COPY_TITLE"), UtAddinArb.getString("STARTUP_LABEL"), "mergeLibStartup", utLibraryItem, iStartup);
    }

    private void copyLibTeardown(Context context) {
        UtTeardownElement utTeardownElement = (UtTeardownElement)context.getSelection()[0];
        UtLibraryItem utLibraryItem = new UtLibraryItem(UtLibraryItem.Kind.TEARDOWN, utTeardownElement.getId());
        ITeardown iTeardown = TearDownRegistry.getInstanceFor(utLibraryItem.getImplKey());
        this.copyLibItem(context, UtAddinArb.getString("TEARDOWN_COPY_TITLE"), UtAddinArb.getString("TEARDOWN_LABEL"), "mergeLibTeardown", utLibraryItem, iTeardown);
    }

    private void copyLibValidation(Context context) {
        UtValidationElement utValidationElement = (UtValidationElement)context.getSelection()[0];
        UtLibraryItem utLibraryItem = new UtLibraryItem(UtLibraryItem.Kind.VALIDATION, utValidationElement.getId());
        IValidation iValidation = ValidationRegistry.getInstanceFor(utLibraryItem.getImplKey());
        this.copyLibItem(context, UtAddinArb.getString("VALIDATION_COPY_TITLE"), UtAddinArb.getString("VALIDATION_LABEL"), "mergeLibValidation", utLibraryItem, iValidation);
    }

    private void copyLibDvq(Context context) {
        UtDynamicValueQueryElement utDynamicValueQueryElement = (UtDynamicValueQueryElement)context.getSelection()[0];
        UtLibraryItem utLibraryItem = new UtLibraryItem(UtLibraryItem.Kind.DYNAMIC_VALUE_QUERY, utDynamicValueQueryElement.getId());
        DynamicValueQuery dynamicValueQuery = new DynamicValueQuery();
        this.copyLibItem(context, UtAddinArb.getString("DVQ_COPY_TITLE"), UtAddinArb.getString("DVQ_LABEL"), "mergeLibDynQuery", utLibraryItem, dynamicValueQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyLibItem(Context context, String string, String string2, String string3, UtLibraryItem utLibraryItem, ICodeHook iCodeHook) {
        String string4 = this.getLibItemName(string, string2, UtAddinArb.getString("COPY_PREFIX") + " " + utLibraryItem.getRef().getName(), iCodeHook);
        if (string4 == null) {
            return;
        }
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string5 = UtUtils.getQuery(string3);
                hashMap.put("LIB_ID", UUID.randomUUID().toString());
                hashMap.put("NAME", string4);
                hashMap.put("CLASS", utLibraryItem.getImplClass());
                hashMap.put("XML", UtUtils.asClob(connection, utLibraryItem.getXml()));
                dBUtil.executeUpdate(string5, hashMap);
                connection.commit();
            }
            catch (Exception exception) {
                UtNavigatorContextMenu.log(exception, Level.SEVERE);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this.refreshParentTreeNode(context, navigatorTreeNode);
    }

    private void exportLibStartup(Context context) {
        UtStartupElement utStartupElement = (UtStartupElement)context.getSelection()[0];
        final String string = utStartupElement.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(utStartupElement.getName());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportLibStartupById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private void exportLibTeardown(Context context) {
        UtTeardownElement utTeardownElement = (UtTeardownElement)context.getSelection()[0];
        final String string = utTeardownElement.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(utTeardownElement.getName());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportLibTeardownById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private void exportLibValidation(Context context) {
        UtValidationElement utValidationElement = (UtValidationElement)context.getSelection()[0];
        final String string = utValidationElement.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(utValidationElement.getName());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportLibValidationById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    private void exportLibDvq(Context context) {
        UtDynamicValueQueryElement utDynamicValueQueryElement = (UtDynamicValueQueryElement)context.getSelection()[0];
        final String string = utDynamicValueQueryElement.getId();
        final UtUtils.ExportFileInfo exportFileInfo = UtUtils.getExportFileWriter(utDynamicValueQueryElement.getName());
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(ExportWizArb.getString((String)"FILE_TYPE"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() throws TaskException {
                block8: {
                    try {
                        if (exportFileInfo == null) break block8;
                        ExportManager exportManager = new ExportManager(exportFileInfo.writer, exportFileInfo.encoding);
                        ExportListenerImpl exportListenerImpl = new ExportListenerImpl();
                        Cursor cursor = Ide.getMainWindow().getCursor();
                        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            try {
                                exportManager.exportLibDynamicValueQueryById(string, exportListenerImpl);
                            }
                            finally {
                                exportManager.close();
                            }
                        }
                        finally {
                            Ide.getMainWindow().setCursor(cursor);
                        }
                        this.setMessage(UtAddinArb.format("EXPORT_SUCCEEDED", exportListenerImpl.getObjectList()));
                    }
                    catch (Exception exception) {
                        this.setMessage(UtAddinArb.getString("EXPORT_FAILED"));
                        UtNavigatorContextMenu.log(exception);
                    }
                }
                return null;
            }
        };
        UtAddin.getRepositoryManager().runTask(raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REFRESH_FOLDER_CMD_ID) {
            this.refreshTreeNode(context);
            return true;
        }
        if (n == DELETE_FOLDER_CMD_ID || n == 20) {
            this.delete(context);
        } else if (n == ADD_IMPL_FOLDER_CMD_ID) {
            this.addImpl(context);
        } else if (n == DEBUG_IMPL_CMD_ID) {
            this.debugImpl(context);
        } else if (n == RENAME_IMPL_CMD_ID) {
            this.renameImpl(context);
        } else if (n == RUN_TEST_CMD_ID) {
            this.runTest(context);
        } else if (n == SYNC_TEST_CMD_ID) {
            this.syncTest(context);
        } else if (n == PURGE_TEST_RESULTS_CMD_ID) {
            this.purgeTestResults(context);
        } else if (n == CREATE_TEST_CMD_ID) {
            this.createTest(context);
        } else if (n == RUN_SUITE_CMD_ID) {
            this.runSuite(context);
        } else if (n == PURGE_SUITE_RESULTS_CMD_ID) {
            this.purgeSuiteResults(context);
        } else if (n == ADD_SUITE_CMD_ID) {
            this.addSuite(context);
        } else if (n == RENAME_SUITE_CMD_ID) {
            this.renameSuite(context);
        } else if (n == ADD_TEST_CMD_ID) {
            this.addTest(context);
        } else if (n == ADD_NESTED_SUITE_CMD_ID) {
            this.addNestedSuite(context);
        } else if (n == REMOVE_NESTED_SUITE_CMD_ID) {
            this.removeNestedSuite(context);
        } else if (n == REMOVE_TEST_CMD_ID) {
            this.removeTest(context);
        } else if (n == COPY_TEST_CMD_ID) {
            this.copyTest(context);
        } else if (n == RENAME_TEST_CMD_ID) {
            this.renameTest(context);
        } else if (n == EXPORT_TEST_CMD_ID) {
            this.exportTest(context);
        } else if (n == EXPORT_SUITE_CMD_ID) {
            this.exportSuite(context);
        } else if (n == ADD_LIB_STARTUP_CMD_ID) {
            this.addLibStartup(context);
        } else if (n == ADD_LIB_TEARDOWN_CMD_ID) {
            this.addLibTeardown(context);
        } else if (n == ADD_LIB_VALIDATION_CMD_ID) {
            this.addLibValidation(context);
        } else if (n == ADD_LIB_DVQ_CMD_ID) {
            this.addLibDvq(context);
        } else if (n == DELETE_LIB_STARTUP_CMD_ID) {
            this.deleteLibStartup(context);
        } else if (n == DELETE_LIB_TEARDOWN_CMD_ID) {
            this.deleteLibTeardown(context);
        } else if (n == DELETE_LIB_VALIDATION_CMD_ID) {
            this.deleteLibValidation(context);
        } else if (n == DELETE_LIB_DVQ_CMD_ID) {
            this.deleteLibDvq(context);
        } else if (n == RENAME_LIB_STARTUP_CMD_ID) {
            this.renameLibStartup(context);
        } else if (n == RENAME_LIB_TEARDOWN_CMD_ID) {
            this.renameLibTeardown(context);
        } else if (n == RENAME_LIB_VALIDATION_CMD_ID) {
            this.renameLibValidation(context);
        } else if (n == RENAME_LIB_DVQ_CMD_ID) {
            this.renameLibDvq(context);
        } else if (n == COPY_LIB_STARTUP_CMD_ID) {
            this.copyLibStartup(context);
        } else if (n == COPY_LIB_TEARDOWN_CMD_ID) {
            this.copyLibTeardown(context);
        } else if (n == COPY_LIB_VALIDATION_CMD_ID) {
            this.copyLibValidation(context);
        } else if (n == COPY_LIB_DVQ_CMD_ID) {
            this.copyLibDvq(context);
        } else if (n == EXPORT_LIB_STARTUP_CMD_ID) {
            this.exportLibStartup(context);
        } else if (n == EXPORT_LIB_TEARDOWN_CMD_ID) {
            this.exportLibTeardown(context);
        } else if (n == EXPORT_LIB_VALIDATION_CMD_ID) {
            this.exportLibValidation(context);
        } else if (n == EXPORT_LIB_DVQ_CMD_ID) {
            this.exportLibDvq(context);
        } else if (n == ADD_INPUT_CATEGORY) {
            this.addCategory(context);
        } else if (n == ADD_INPUT_DATATYPE) {
            this.addDatatype(context);
        } else if (n == DELETE_INPUT_DATATYPE) {
            this.deleteLookupDatatype(context);
        } else if (n == DELETE_INPUT_CATEGORY) {
            this.deleteLookupCategory(context);
        } else if (n == RENAME_INPUT_CATEGORY) {
            this.renameLookupCategory(context);
        } else if (n == EXPORT_MULTIPLE_CMD_ID) {
            this.exportMultiple(context);
        } else if (n == OPEN_ELEMENT_CMD_ID) {
            WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
            try {
                waitCursor.show();
                this.openElement((UtDefaultElement)context.getSelection()[0], false);
            }
            finally {
                waitCursor.hide();
            }
        } else {
            return false;
        }
        return true;
    }

    public void attachMouseListener(final NavigatorTree navigatorTree) {
        CustomTree customTree = navigatorTree.getTree();
        customTree.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreePath treePath;
                if (mouseEvent.getButton() == 1 && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && mouseEvent.getSource() instanceof CustomTree && (NavigatorTreeNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent() != null && ((NavigatorTreeNode)((CustomTree)mouseEvent.getSource()).getLastSelectedPathComponent()).getElement() != null && (treePath = ((CustomTree)mouseEvent.getSource()).getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    NavigatorTreeNode navigatorTreeNode = (NavigatorTreeNode)treePath.getLastPathComponent();
                    NavigatorTreeNode navigatorTreeNode2 = UtNavigatorContextMenu.this.getParentNode(navigatorTreeNode);
                    if (navigatorTreeNode2 == null) {
                        return;
                    }
                    Element element = navigatorTreeNode2.getElement();
                    if (element instanceof UtDefaultElement) {
                        UtDefaultElement utDefaultElement = (UtDefaultElement)element;
                        if (UtNavigatorContextMenu.this.canOpenElement(navigatorTree, utDefaultElement)) {
                            WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                            try {
                                waitCursor.show();
                                UtNavigatorContextMenu.this.openElement(utDefaultElement, false);
                            }
                            finally {
                                waitCursor.hide();
                            }
                        }
                    } else if (element instanceof ReportNode) {
                        ((ReportNode)element).getReport().setParent(null);
                        ((ReportNode)element).getReport().setQueriesBindMap(null);
                        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
                        try {
                            waitCursor.show();
                            String string = UtAddin.getRepositoryConnectionName();
                            if (string != null) {
                                try {
                                    Connections.getInstance().getConnection(string);
                                }
                                catch (DBException dBException) {
                                    UtNavigatorContextMenu.ignore(dBException);
                                }
                            }
                            ReportNavigatorContextMenu.getInstance().openReport((ReportNode)element, false, string);
                        }
                        finally {
                            waitCursor.hide();
                        }
                    }
                }
            }
        });
    }

    private NavigatorTreeNode getParentNode(NavigatorTreeNode navigatorTreeNode) {
        Element element = (Element)navigatorTreeNode.getUserObject();
        if (element instanceof UtTestImplNode) {
            this._implName = ((UtTestImplNode)element).getName();
            return this.getParentNode((NavigatorTreeNode)navigatorTreeNode.getParent());
        }
        if (element instanceof UtParamElement) {
            return this.getParentNode((NavigatorTreeNode)navigatorTreeNode.getParent());
        }
        return navigatorTreeNode;
    }

    private boolean canOpenElement(NavigatorTree navigatorTree, UtDefaultElement utDefaultElement) {
        String string;
        if ((utDefaultElement instanceof UtTestNode || utDefaultElement instanceof UtSuiteTestNode) && UtUtils.getTestImplCount(string = utDefaultElement.getId()) == 0) {
            NavigatorTreeNode navigatorTreeNode = navigatorTree.findTreeNode((Element)utDefaultElement, navigatorTree.getRoot());
            navigatorTree.expand(navigatorTreeNode, false);
            return false;
        }
        return true;
    }

    private UtEditor openElement(UtDefaultElement utDefaultElement, boolean bl) {
        Object object;
        UtEditorNode utEditorNode = UtEditorNode.createUtEditorNode(utDefaultElement);
        if (null == utEditorNode) {
            return null;
        }
        UtEditor utEditor = null;
        boolean bl2 = false;
        List list = EditorManager.getEditorManager().getAllEditors();
        if (!bl && list.size() > 0) {
            object = new ArrayList();
            for (Editor editor : list) {
                if (!(editor instanceof UtEditor) || !this.editorSupports(editor.getEditorAddin(), (Element)utEditorNode)) continue;
                UtEditor utEditor2 = (UtEditor)editor;
                if (this.editorIsEditing(utEditor2, utDefaultElement)) {
                    utEditor = utEditor2;
                    bl2 = true;
                    break;
                }
                if (utEditor2.isPinned()) continue;
                if (null == utEditor && !utEditor2.isDirty()) {
                    utEditor = utEditor2;
                    continue;
                }
                object.add(utEditor2);
            }
            if (null == utEditor) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Editor editor;
                    editor = (UtEditor)((Object)iterator.next());
                    this.showEditor(editor.getEditorNode(), false);
                    if (!editor.canUpdateContent()) continue;
                    utEditor = editor;
                    break;
                }
            }
        }
        if (null != utEditor) {
            object = utEditor.getEditorNode();
            if (!bl2) {
                ((UtEditorNode)((Object)object)).setViewedObject(utDefaultElement);
                object.setURL(utEditorNode.getURL());
            }
            utEditorNode = object;
        }
        return this.showEditor(utEditorNode, !bl2);
    }

    private boolean editorSupports(EditorAddin editorAddin, Element element) {
        return !Float.isNaN(editorAddin.getEditorWeight(element));
    }

    private boolean editorIsEditing(UtEditor utEditor, UtDefaultElement utDefaultElement) {
        boolean bl = utDefaultElement.getId().equals(utEditor.getElementId());
        if (!this._editorIsEditingDisableExactTestImplMatch && bl && utEditor instanceof UtTestEditor) {
            bl = ((UtTestEditor)utEditor).getImplName().equals(this._implName);
        }
        return bl;
    }

    private String verifyDataConnectionQualName(String string) {
        if (string != null && Connections.getInstance().getConnectionInfo(string) == null) {
            OracleConnection oracleConnection;
            UtDataTypeConnectionProvider utDataTypeConnectionProvider = UtAddin.getDataTypeConnectionProvider();
            String string2 = utDataTypeConnectionProvider.peekDataTypeConnectionQualName();
            if (string2 != null && Connections.getInstance().getConnectionInfo(string2) == null) {
                utDataTypeConnectionProvider.setDataTypeConnectionQualName(null);
                string2 = null;
            }
            if (string2 == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)UtAddinArb.getString("BAD_TEST_CONN"), (String)UtAddinArb.getString("BAD_TEST_CONN_TITLE"), null);
            }
            try {
                oracleConnection = utDataTypeConnectionProvider.getValidDataTypeConnection();
            }
            catch (DataTypeConnectionException dataTypeConnectionException) {
                if (!(dataTypeConnectionException.getCause() instanceof ConnectionCanceledException)) {
                    UtNavigatorContextMenu.log(UtUtils.logString(dataTypeConnectionException.getCause()), dataTypeConnectionException.getCause(), Level.SEVERE);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)dataTypeConnectionException.getCause().getLocalizedMessage(), (String)UtAddinArb.get("ERROR"), null);
                }
                oracleConnection = null;
            }
            string = oracleConnection != null ? utDataTypeConnectionProvider.getDataTypeConnectionQualName() : null;
        }
        return string;
    }

    private UtEditor showEditor(UtEditorNode utEditorNode, boolean bl) {
        Context context = Context.newIdeContext((Node)utEditorNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        String string = null;
        if (bl) {
            if (utEditorNode instanceof UtTestEditorNode) {
                string = UtUtils.getTestConnectionName(utEditorNode.getElement().getId());
            }
            if (utEditorNode instanceof UtSuiteEditorNode) {
                string = UtUtils.getSuiteConnectionName(utEditorNode.getElement().getId());
            }
            string = this.verifyDataConnectionQualName(string);
            if (utEditorNode instanceof UtTestEditorNode && string == null) {
                return null;
            }
        }
        UtEditor utEditor = (UtEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
        if (bl) {
            if (null != string) {
                utEditor.setDataConnectionQualName(string);
            }
            if (utEditor instanceof UtTestEditor) {
                ((UtTestEditor)utEditor).updateContent(this._implName, true);
            } else {
                utEditor.refresh();
            }
        }
        return utEditor;
    }

    private NavigatorTreeNode getNearestSiblingToSelectedNode(Context context) {
        NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getNextSibling();
        if (navigatorTreeNode2 == null) {
            navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getPreviousSibling();
        }
        return navigatorTreeNode2;
    }

    private void refreshTreeNode(Context context) {
        Object object = context.getElement();
        if (!(object instanceof Subject)) {
            object = RootFolder.getInstance();
        }
        UpdateMessage.fireStructureChanged((Subject)((Subject)object));
    }

    private void refreshParentTreeNode(Context context, NavigatorTreeNode navigatorTreeNode) {
        String string;
        Element element;
        RootFolder rootFolder = null;
        NavigatorTreeNode navigatorTreeNode2 = NavigatorContext.getSingleNavigatorTreeNodeFromContext((Context)context);
        NavigatorTreeNode navigatorTreeNode3 = null;
        if (navigatorTreeNode2 != null && (element = (navigatorTreeNode3 = (NavigatorTreeNode)navigatorTreeNode2.getParent()).getElement()) instanceof Subject) {
            rootFolder = (Subject)element;
        }
        if (rootFolder == null) {
            rootFolder = RootFolder.getInstance();
        }
        if (navigatorTreeNode != null && (element = context.getView()) instanceof UtNavigatorWindow && (string = navigatorTreeNode.getElement().getShortLabel()) != null && !string.equals("")) {
            UtNavigatorWindow utNavigatorWindow = (UtNavigatorWindow)element;
            utNavigatorWindow.setAsynchronousLoadHandler(navigatorTreeNode3, new UtNavigatorWindow.AsynchronousLoadHandler(){

                @Override
                public void onLoadComplete(NavigatorTreeNode navigatorTreeNode) {
                    String string2;
                    Object object;
                    Object object2 = null;
                    Iterator iterator = navigatorTreeNode.getChildNodes();
                    while (iterator.hasNext()) {
                        object = (NavigatorTreeNode)iterator.next();
                        string2 = object.getElement().getShortLabel();
                        if (!string.equals(string2)) continue;
                        object2 = object;
                        break;
                    }
                    if (object2 != null) {
                        object = new TreePath(object2.getPath());
                        string2 = object2.getOwningNavigatorTree().getTree();
                        string2.getSelectionModel().setSelectionPath((TreePath)object);
                        SwingUtilities.invokeLater(new Runnable((CustomTree)string2, (TreePath)object){
                            final /* synthetic */ CustomTree val$tree;
                            final /* synthetic */ TreePath val$treePath;
                            {
                                this.val$tree = customTree;
                                this.val$treePath = treePath;
                            }

                            @Override
                            public void run() {
                                this.val$tree.scrollPathToVisible(this.val$treePath);
                            }
                        });
                    }
                }
            });
        }
        UpdateMessage.fireStructureChanged((Subject)rootFolder);
    }

    static {
        REFRESH_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"ut.refresh");
        EXPORT_MULTIPLE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportMultiple");
        DELETE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"ut.delete");
        ADD_IMPL_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addImpl");
        DEBUG_IMPL_CMD_ID = Ide.findOrCreateCmdID((String)"ut.debugImpl");
        RENAME_IMPL_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameImpl");
        CREATE_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.createTest");
        RUN_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.runTest");
        SYNC_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.syncTest");
        PURGE_TEST_RESULTS_CMD_ID = Ide.findOrCreateCmdID((String)"ut.purgeTestResults");
        ADD_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addSuite");
        RENAME_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameSuite");
        EXPORT_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportSuite");
        ADD_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addTest");
        ADD_NESTED_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addNestedSuite");
        REMOVE_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.removeTest");
        REMOVE_NESTED_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.removeNestedSuite");
        COPY_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.copyTest");
        RENAME_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameTest");
        EXPORT_TEST_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportTest");
        RUN_SUITE_CMD_ID = Ide.findOrCreateCmdID((String)"ut.runSuite");
        PURGE_SUITE_RESULTS_CMD_ID = Ide.findOrCreateCmdID((String)"ut.purgeSuiteResults");
        ADD_LIB_STARTUP_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addLibStartup");
        ADD_LIB_TEARDOWN_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addLibTeardown");
        ADD_LIB_VALIDATION_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addLibValidation");
        ADD_LIB_DVQ_CMD_ID = Ide.findOrCreateCmdID((String)"ut.addLibDvq");
        DELETE_LIB_STARTUP_CMD_ID = Ide.findOrCreateCmdID((String)"ut.deleteLibStartup");
        DELETE_LIB_TEARDOWN_CMD_ID = Ide.findOrCreateCmdID((String)"ut.deleteLibTeardown");
        DELETE_LIB_VALIDATION_CMD_ID = Ide.findOrCreateCmdID((String)"ut.deleteLibValidation");
        DELETE_LIB_DVQ_CMD_ID = Ide.findOrCreateCmdID((String)"ut.deleteLibDvq");
        RENAME_LIB_STARTUP_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameLibStartup");
        RENAME_LIB_TEARDOWN_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameLibTeardown");
        RENAME_LIB_VALIDATION_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameLibValidation");
        RENAME_LIB_DVQ_CMD_ID = Ide.findOrCreateCmdID((String)"ut.renameLibDvq");
        COPY_LIB_STARTUP_CMD_ID = Ide.findOrCreateCmdID((String)"ut.copyLibStartup");
        COPY_LIB_TEARDOWN_CMD_ID = Ide.findOrCreateCmdID((String)"ut.copyLibTeardown");
        COPY_LIB_VALIDATION_CMD_ID = Ide.findOrCreateCmdID((String)"ut.copyLibValidation");
        COPY_LIB_DVQ_CMD_ID = Ide.findOrCreateCmdID((String)"ut.copyLibDvq");
        EXPORT_LIB_STARTUP_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportLibStartup");
        EXPORT_LIB_TEARDOWN_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportLibTeardown");
        EXPORT_LIB_VALIDATION_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportLibValidation");
        EXPORT_LIB_DVQ_CMD_ID = Ide.findOrCreateCmdID((String)"ut.exportLibDvq");
        ADD_INPUT_CATEGORY = Ide.findOrCreateCmdID((String)"ut.addCategory");
        DELETE_INPUT_CATEGORY = Ide.findOrCreateCmdID((String)"ut.delCategory");
        RENAME_INPUT_CATEGORY = Ide.findOrCreateCmdID((String)"ut.renameCategory");
        ADD_INPUT_DATATYPE = Ide.findOrCreateCmdID((String)"ut.addDataType");
        DELETE_INPUT_DATATYPE = Ide.findOrCreateCmdID((String)"ut.delDataType");
        OPEN_ELEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"ut.openElement");
    }

    static class ExportListenerImpl
    implements ExportListener {
        private TreeSet<String> objectNames = new TreeSet();

        ExportListenerImpl() {
        }

        @Override
        public void onExportTest(UtTest utTest) {
            this.objectNames.add(utTest.getTestName());
        }

        @Override
        public void onExportSuite(UtSuite utSuite) {
            this.objectNames.add(utSuite.getSuiteName());
        }

        @Override
        public void onExportLibraryItem(UtLibraryItem utLibraryItem) {
            this.objectNames.add(utLibraryItem.getRef().getName());
        }

        String getObjectList() {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.objectNames) {
                stringBuffer.append("\n  ");
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

