/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_user;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.manage_user.UserStrings;
import oracle.dbtools.unit_test.manage_user.UserUtils;

public class UserPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = new JScrollPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JCheckBox withAdmin = new JCheckBox();
    private JList _activeList;
    private JList _inactiveList;
    private DefaultListModel _inactiveModel;
    private DefaultListModel _activeModel;
    private Connection _conn;
    private boolean _admin;

    private void loadInactiveUsers(boolean bl) {
        ((DefaultListModel)this._inactiveList.getModel()).clear();
        List<String> list = bl ? UserUtils.getNonAdmins(this._conn) : UserUtils.getNonUsers(this._conn);
        for (String string : list) {
            if (((DefaultListModel)this._inactiveList.getModel()).indexOf(string) != -1) continue;
            ((DefaultListModel)this._inactiveList.getModel()).addElement(string);
        }
    }

    private void loadActiveUsers(boolean bl) {
        ((DefaultListModel)this._activeList.getModel()).clear();
        List<String> list = bl ? UserUtils.getAdmins(this._conn) : UserUtils.getUsers(this._conn);
        for (String string : list) {
            if (string.equals("UT_REPO_ADMINISTRATOR") || ((DefaultListModel)this._activeList.getModel()).indexOf(string) != -1) continue;
            ((DefaultListModel)this._activeList.getModel()).addElement(string);
        }
    }

    public JPanel getPanel(Connection connection, boolean bl) {
        if (!UserUtils.isAdminUser(connection, null, bl)) {
            if (bl) {
                this.add(new JLabel(UserStrings.getString("NO_ADMIN_PERM")));
            } else {
                this.add(new JLabel(UserStrings.getString("NO_USER_PERM")));
            }
            return this;
        }
        this._conn = connection;
        this._admin = bl;
        this._activeModel = new DefaultListModel();
        this._activeList = new JList(this._activeModel);
        this.loadActiveUsers(bl);
        this._activeList.setDragEnabled(false);
        this._inactiveModel = new DefaultListModel();
        this._inactiveList = new JList(this._inactiveModel);
        this.loadInactiveUsers(bl);
        this._inactiveList.setDragEnabled(false);
        this.addAll.setActionCommand(">>");
        this.addAll.setIcon(RaptorImagesArb.getIcon((String)"LAST"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.setIcon(RaptorImagesArb.getIcon((String)"NEXT"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.setIcon(RaptorImagesArb.getIcon((String)"FIRST"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.setIcon(RaptorImagesArb.getIcon((String)"PREVIOUS"));
        this.remOne.addActionListener(this);
        this.withAdmin.setText(UserStrings.getString("WITH_ADMIN"));
        this.jScrollPane.setViewportView(this._inactiveList);
        this.jScrollPane.setPreferredSize(new Dimension(150, 200));
        this.jScrollPane1.setViewportView(this._activeList);
        this.jScrollPane1.setPreferredSize(new Dimension(150, 200));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jScrollPane, new GridBagConstraints(1, 0, 1, 6, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addOne, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.addAll, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remOne, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remAll, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.withAdmin, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(3, 0, 1, 6, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this;
    }

    private boolean grantRole(String string) {
        if (this._admin) {
            UserUtils.grantAdmin(this._conn, string, this.withAdmin.isSelected());
        } else {
            UserUtils.grantUser(this._conn, string, this.withAdmin.isSelected());
        }
        UtAddin.getRepositoryManager().initializeConnection();
        return true;
    }

    private boolean revokeRole(String string) {
        if (this._admin) {
            UserUtils.revokeAdmin(this._conn, string);
        } else {
            UserUtils.revokeUser(this._conn, string);
        }
        UtAddin.getRepositoryManager().initializeConnection();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        Object[] objectArray;
                        if (!actionEvent.getActionCommand().equals(">")) break block4;
                        for (Object object : objectArray = this._inactiveList.getSelectedValues()) {
                            if (!this.grantRole((String)object)) continue;
                            ((DefaultListModel)this._activeList.getModel()).addElement((String)object);
                            ((DefaultListModel)this._inactiveList.getModel()).removeElement((String)object);
                        }
                        break block5;
                    }
                    if (!actionEvent.getActionCommand().equals("<")) break block6;
                    Object[] objectArray = this._activeList.getSelectedValues();
                    String string = UserUtils.getUser(this._conn);
                    for (Object object : objectArray) {
                        if (object.equals(string) || !this.revokeRole((String)object)) continue;
                        ((DefaultListModel)this._inactiveList.getModel()).addElement((String)object);
                        ((DefaultListModel)this._activeList.getModel()).removeElement((String)object);
                    }
                    break block5;
                }
                if (!actionEvent.getActionCommand().equals(">>")) break block7;
                DefaultListModel defaultListModel = (DefaultListModel)this._inactiveList.getModel();
                Object[] objectArray = new Object[defaultListModel.size() + 1];
                defaultListModel.copyInto(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    if (string == null || ((DefaultListModel)this._activeList.getModel()).indexOf(string) != -1 || !this.grantRole(string)) continue;
                    ((DefaultListModel)this._activeList.getModel()).addElement(string);
                    ((DefaultListModel)this._inactiveList.getModel()).removeElement(string);
                }
                break block5;
            }
            if (!actionEvent.getActionCommand().equals("<<")) break block5;
            DefaultListModel defaultListModel = (DefaultListModel)this._activeList.getModel();
            Object[] objectArray = new Object[defaultListModel.size() + 1];
            defaultListModel.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = UserUtils.getUser(this._conn);
                if (string == null || ((DefaultListModel)this._inactiveList.getModel()).indexOf(string) != -1 || string.equals(string2) || !this.revokeRole(string)) continue;
                ((DefaultListModel)this._inactiveList.getModel()).addElement(string);
                ((DefaultListModel)this._activeList.getModel()).removeElement(string);
            }
        }
    }
}

