/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.unit_test.editor.UiArb;
import oracle.dbtools.unit_test.testObjects.DetailTableObject;
import oracle.dbtools.unit_test.testObjects.UtTestImplArgs;

class TestDetailTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    public static final int PARAMETER = 0;
    public static final int DATATYPE = 1;
    public static final int TYPE = 2;
    public static final int INVAL = 3;
    public static final int OUTVAL = 4;
    public static final int TEST_OUTVAL = 5;
    protected ArrayList<Object> columnNames = new ArrayList();
    protected Vector<DetailTableObject> dataVector;
    protected boolean isDynamic;
    private boolean _tableEditable;

    public TestDetailTableModel() {
        for (int i = 0; i < 6; ++i) {
            this.columnNames.add("");
        }
        this.dataVector = new Vector();
        this.isDynamic = false;
    }

    public Class getColumnClass(int n) {
        if (this.getValueAt(0, n) != null) {
            return this.getValueAt(0, n).getClass();
        }
        return String.class;
    }

    public void setColumn(int n, Object object) {
        this.columnNames.set(n, object);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n).toString();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    public DetailTableObject getRow(int n) {
        return this.dataVector.get(n);
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    public void addRow(DetailTableObject detailTableObject) {
        this.dataVector.add(detailTableObject);
    }

    public void clear() {
        this.dataVector = new Vector();
    }

    void setTableEditable(boolean bl) {
        this._tableEditable = bl;
    }

    private boolean isTableEditable() {
        return this._tableEditable;
    }

    boolean isDataValueColumn(int n) {
        return 3 == n || 4 == n;
    }

    public void setDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (!this.isTableEditable()) {
            return false;
        }
        if (5 != n2 && !this.isDataValueColumn(n2)) {
            return false;
        }
        DetailTableObject detailTableObject = this.getRow(n);
        if (null == detailTableObject) {
            return false;
        }
        DataType dataType = detailTableObject.getParm().getDataType();
        if (!dataType.isSupported()) {
            return false;
        }
        String string = detailTableObject.getArg().get_in_out();
        if (3 == n2 && ("IN".equals(string) || "IN/OUT".equals(string))) {
            return true;
        }
        if ("OUT".equals(string) || "IN/OUT".equals(string)) {
            if (4 == n2) {
                return !this.isDynamic;
            }
            if (5 == n2) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        UtTestImplArgs utTestImplArgs = this.dataVector.get(n).getParm();
        if (5 == n2) {
            utTestImplArgs.setTestOutVal((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        } else if (3 == n2 || 4 == n2) {
            switch (n2) {
                case 3: {
                    if (utTestImplArgs.equalsInput(object)) break;
                    utTestImplArgs.setInput(object);
                    this.fireTableCellUpdated(n, n2);
                    break;
                }
                case 4: {
                    if (utTestImplArgs.equalsReturn(object)) break;
                    utTestImplArgs.setResult(object);
                    this.fireTableCellUpdated(n, n2);
                }
            }
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        DetailTableObject detailTableObject = this.dataVector.get(n);
        switch (n2) {
            case 0: {
                if (detailTableObject.getArg().get_argument_name() != null) {
                    return detailTableObject.getArg().get_argument_name();
                }
                return "<RETURN>";
            }
            case 1: {
                return detailTableObject.getArg().getDataTypeString();
            }
            case 2: {
                return detailTableObject.getArg().get_in_out();
            }
            case 3: {
                if (detailTableObject.getArg().get_in_out().equals("IN") || detailTableObject.getArg().get_in_out().equals("IN/OUT")) {
                    if (detailTableObject.getParm().getDataType().isSupported()) {
                        Object object = detailTableObject.getParm().getInput();
                        return object;
                    }
                    return UiArb.getString("BAD_DATATYPE");
                }
                return new String("");
            }
            case 4: {
                if (detailTableObject.getArg().get_in_out().equals("OUT") || detailTableObject.getArg().get_in_out().equals("IN/OUT")) {
                    if (detailTableObject.getParm().getDataType().isSupported()) {
                        Object object = detailTableObject.getParm().getResult();
                        return object;
                    }
                    return UiArb.getString("BAD_DATATYPE");
                }
                return new String("");
            }
            case 5: {
                if (detailTableObject.getParm().getDataType().isSupported() && detailTableObject.getArg().get_in_out().equals("OUT") || detailTableObject.getArg().get_in_out().equals("IN/OUT")) {
                    return detailTableObject.getParm().getTestOutVal();
                }
                return false;
            }
        }
        return new Object();
    }

    public UtTestImplArgs.ValueSelector getValueSelector(int n) {
        if (n == 3) {
            return UtTestImplArgs.ValueSelector.input;
        }
        return UtTestImplArgs.ValueSelector.result;
    }
}

