/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.create_wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.create_wizard.CreateWizContext;
import oracle.dbtools.unit_test.create_wizard.CreateWizPanel;
import oracle.dbtools.unit_test.editor.ListTablePanel;
import oracle.dbtools.unit_test.editor.ValidationListTableModel;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.process_validation.ValidationArb;
import oracle.dbtools.unit_test.process_validation.ValidationRegistry;
import oracle.dbtools.unit_test.testObjects.UtTestImpl;

public class CreateWizValidations
extends CreateWizPanel {
    private static final long serialVersionUID = 1L;
    private ListTablePanel<IValidation> _validationPanel;

    public CreateWizValidations() {
        this.setLayout(new GridBagLayout());
    }

    private void init() {
        this.removeAll();
        Insets insets = new Insets(10, 10, 10, 10);
        JTextArea jTextArea = new JTextArea(CreateWizArb.getString("VALIDATIONS_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        this.add(jTextArea, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        ArrayList arrayList = new ArrayList();
        final ValidationListTableModel validationListTableModel = new ValidationListTableModel(this.getCreateWizContext().getCodeHookLookup()){

            @Override
            protected List<IValidation> add() {
                String string = ValidationArb.getString("NONE");
                IValidation iValidation = ValidationRegistry.getInstanceFor(string);
                iValidation.loadFromXml(null);
                ArrayList<IValidation> arrayList = new ArrayList<IValidation>();
                arrayList.add(iValidation);
                return arrayList;
            }
        };
        validationListTableModel.setRowList(arrayList);
        this._validationPanel = new ListTablePanel<IValidation>(validationListTableModel);
        this.add(this._validationPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        if (this.getCreateWizContext().getUseSeeding()) {
            this._validationPanel.setEditable(false);
        } else {
            UtTestImpl utTestImpl = this.getCreateWizContext().getTestImpl();
            if (utTestImpl != null) {
                utTestImpl.setValidationCodeHooks(null);
                this.getCreateWizContext().setValidationHooks(null);
                validationListTableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        List<IValidation> list = validationListTableModel.getRowList();
                        CreateWizContext createWizContext = CreateWizValidations.this.getCreateWizContext();
                        createWizContext.setValidationHooks(list);
                        UtTestImpl utTestImpl = createWizContext.getTestImpl();
                        utTestImpl.setValidationCodeHooks(list);
                    }
                });
            }
            this._validationPanel.setEditable(utTestImpl != null);
        }
    }

    @Override
    protected void onEntryTestChanged() {
        this.init();
    }

    @Override
    protected void onEntrySeedingChanged() {
        this.init();
    }

    public Object getExitTransition() {
        return "TEARDOWN_TRANS";
    }
}

