/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.OutputDirectoriesUI;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.UiResources;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class DpExpWizOutputFiles
extends DefaultTraversablePanel {
    private String[] _gotDirectories = null;
    private static final long serialVersionUID = 1L;
    private OutputDirectoriesUI _oUI = new OutputDirectoriesUI();
    private ExtractListModel _listModel = null;
    protected final JCheckBox _cbGoToSummary = new JCheckBox();
    private JRadioButton _neither = null;
    private JRadioButton _reuse = null;
    private JRadioButton _appendSysdate = null;
    private JLabel _utlFile10g = new JLabel(DpWizardArb.getString("EXP_OVERWRITE_EXISTING_WARN_FOR_10G"));
    private boolean _isShowGoToSummary = true;

    public DpExpWizOutputFiles() {
        this.setLayout(new GridBagLayout());
        this.add(this._oUI, new GridBagConstraints(0, 0, 3, 3, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._neither = new JRadioButton(DpWizardArb.getString("EXP_DEFAULT_NO_OVERWRITE"));
        this._reuse = new JRadioButton();
        this._reuse.setSelected(false);
        this._appendSysdate = new JRadioButton();
        this._appendSysdate.setSelected(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._neither);
        buttonGroup.add(this._reuse);
        buttonGroup.add(this._appendSysdate);
        this._neither.setSelected(true);
        this._reuse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpExpWizOutputFiles.this._appendSysdate.setSelected(false);
                }
            }
        });
        this._appendSysdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DpExpWizOutputFiles.this._reuse.setSelected(false);
                }
            }
        });
        this.add(this._neither, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._reuse.setText(DpWizardArb.getString("EXP_OVERWRITE_EXISTING_FILE"));
        this.add(this._reuse, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this._appendSysdate.setText(DpWizardArb.getString("EXP_APPEND_SYSDATE_LABEL"));
        this.add(this._utlFile10g, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._appendSysdate, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 10.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 7, 1, 1, 0.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._isShowGoToSummary) {
            ResourceUtils.resButton((AbstractButton)this._cbGoToSummary, (String)StringUtils.stripMnemonic((String)UiResources.getString((String)"GOTO_SUMMARY")));
            this.add(this._cbGoToSummary, new GridBagConstraints(0, 8, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.validate();
    }

    public String[] getDirectories(TraversableContext traversableContext) {
        this._gotDirectories = (String[])DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_DIRECTORIES", new String[0]);
        return this._gotDirectories;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._listModel = (ExtractListModel)traversableContext.get("KEY_EXPORT_OBJECTS");
        super.onEntry(traversableContext);
        this._gotDirectories = null;
        this._oUI.setDirectories(this.getDirectories(traversableContext));
        this._oUI.onEntry(traversableContext);
        this._neither.setSelected(true);
        this._reuse.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_REUSEDUMP_FILE", Boolean.FALSE)).equals(Boolean.TRUE));
        this._appendSysdate.setSelected(((Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_APPENDSYSDATEDUMPFILE", Boolean.FALSE)).equals(Boolean.TRUE));
        this._cbGoToSummary.setSelected(false);
        Version version = (Version)this._listModel.getPropertyValue("EXP_VERSION");
        if (DBUtil.checkVersion((Version)version, null, (Version)new Version("10.9"))) {
            this.remove(this._utlFile10g);
            this._reuse.setEnabled(true);
        } else if (DBUtil.checkVersion((Version)version, (Version)new Version("10.9"), null)) {
            Boolean bl = (Boolean)this._listModel.getPropertyValue("EXP_UTL_FILE");
            if (bl.equals(Boolean.TRUE)) {
                this.remove(this._utlFile10g);
                this._reuse.setEnabled(true);
            } else {
                this.remove(this._utlFile10g);
                this.add(this._utlFile10g, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
                if (this._reuse.isSelected()) {
                    this._neither.setSelected(true);
                }
                this._reuse.setEnabled(false);
            }
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this._oUI.onExit(traversableContext);
        if (this._reuse.isSelected()) {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_REUSEDUMP_FILE", (Object)Boolean.FALSE);
        }
        if (this._appendSysdate.isSelected()) {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.TRUE);
        } else {
            this._listModel.setProperty("DP_APPENDSYSDATEDUMPFILE", (Object)Boolean.FALSE);
        }
    }

    public Object getExitTransition() {
        if (this._cbGoToSummary.isSelected()) {
            return "Fin";
        }
        return "TRANSScheduleOptions";
    }
}

