/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin;

import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.ide.MetricsViewer;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.ide.MetricsViewerNode;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.NodeMonitorMixin;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;

public class FXViewerDrilldownMixin
extends NodeMonitorMixin {
    private final Class<? extends Region> panelClass;
    private final String connectionName;
    private final Connection connection;
    private final Map<String, String> panelAttributes;

    public static void install(Node node, Class<? extends Region> clazz, String string, Connection connection, Map<String, String> map) {
        FXViewerDrilldownMixin fXViewerDrilldownMixin = new FXViewerDrilldownMixin(clazz, string, connection, map);
        fXViewerDrilldownMixin.installMixin(node);
    }

    protected FXViewerDrilldownMixin(Class<? extends Region> clazz, String string, Connection connection, Map<String, String> map) {
        this.panelClass = clazz;
        this.connectionName = string;
        this.connection = connection;
        this.panelAttributes = map;
    }

    @Override
    protected boolean onClick(Node node, MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() > 1) {
            this.openViewer();
            bl = true;
        }
        return bl;
    }

    private void openViewer() {
        if (!this.findAndRaiseEditor(this.panelClass, this.connectionName)) {
            MetricsViewerNode metricsViewerNode = new MetricsViewerNode(this.panelClass, this.connectionName, this.connection);
            metricsViewerNode.enablePanAndZoom();
            Context context = Context.newIdeContext((oracle.ide.model.Node)metricsViewerNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            MetricsViewer metricsViewer = null;
            try {
                metricsViewer = (MetricsViewer)EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to open viewer", exception);
            }
            metricsViewer.getDefaultFocusComponent().requestFocusInWindow();
        }
    }

    private boolean findAndRaiseEditor(Class<? extends Region> clazz, String string) {
        boolean bl = false;
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            MetricsViewer metricsViewer;
            if (!(editor instanceof MetricsViewer) || !(metricsViewer = (MetricsViewer)editor).isViewerFor(clazz, string)) continue;
            bl = true;
            SwingUtilities.invokeLater(() -> {
                EditorManager editorManager = EditorManager.getEditorManager();
                for (EditorInfo editorInfo : editorManager.getEditorsInfo()) {
                    if (metricsViewer != editorInfo._getEditor()) continue;
                    editorManager.activateEditor(editorInfo);
                    break;
                }
            });
        }
        return bl;
    }
}

