/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin;

import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.NodeMonitorMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.ColorHelper;

public class BorderMixin
extends NodeMonitorMixin {
    public static final Color SELECTION_COLOR = Color.YELLOW;
    public static final Color DRILLDOWN_COLOR = Color.BLUE;
    private final String borderedStyle;
    private String borderDisabledStyle;
    private Node targetNode;

    public static void install(Node node, Color color) {
        BorderMixin.install(node, node, false, color);
    }

    public static void install(Node node, boolean bl, Color color) {
        BorderMixin.install(node, node, bl, color);
    }

    public static void install(Node node, Node node2, Color color) {
        BorderMixin.install(node, node2, false, color);
    }

    public static void install(Node node, Node node2, boolean bl, Color color) {
        BorderMixin borderMixin = new BorderMixin(node2, color);
        borderMixin.installMixin(node);
        if (bl && node instanceof Region) {
            Region region = (Region)node;
            for (Node node3 : region.getChildrenUnmodifiable()) {
                BorderMixin.install(node3, node2, true, color);
            }
        }
    }

    protected BorderMixin(Node node, Color color) {
        this.targetNode = node;
        this.borderedStyle = String.format("-fx-border-color:%s; -fx-border-width:2; -fx-border-insets:-2; -fx-border-radius:1;", ColorHelper.getWebColor(color));
    }

    @Override
    protected void onEnter(Node node, MouseEvent mouseEvent) {
        this.setBorderedStyleEnabled(true);
    }

    @Override
    protected void onExit(Node node, MouseEvent mouseEvent) {
        this.setBorderedStyleEnabled(false);
    }

    private void setBorderedStyleEnabled(boolean bl) {
        if (bl) {
            this.borderDisabledStyle = this.targetNode.getStyle();
            this.targetNode.setStyle(this.borderDisabledStyle + this.borderedStyle);
        } else {
            this.targetNode.setStyle(this.borderDisabledStyle);
        }
    }
}

