/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.MapEntryTransform;
import oracle.dbtools.raptor.metrics.value.DXRow;

class CategorySeriesMapBinding
extends ObjectBinding<ObservableList<XYChart.Series<Number, String>>> {
    private final ObservableList<String> categories;
    private final ObjectProperty<ObservableList<XYChart.Series<Number, String>>> dataProperty;
    private final ObservableList<XYChart.Data<Number, String>> dataPoints;
    private final Map<String, CategoryListener> listenerMap = new HashMap<String, CategoryListener>();

    CategorySeriesMapBinding(ObservableMapValue<String, DXRow<String>> observableMapValue, ObservableList<String> observableList, MapEntryTransform<String> mapEntryTransform) {
        this.categories = FXCollections.observableArrayList();
        Bindings.bindContent(observableList, this.categories);
        this.dataProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        XYChart.Series series = new XYChart.Series();
        this.dataPoints = series.getData();
        ((ObservableList)this.dataProperty.get()).add((Object)series);
        ((ObservableMap)observableMapValue.get()).addListener(change -> {
            if (change.wasAdded()) {
                DXRow dXRow = (DXRow)change.getValueAdded();
                this.onCategoryAdded((String)mapEntryTransform.getKey(dXRow), mapEntryTransform.getValue(dXRow));
            } else if (change.wasRemoved()) {
                DXRow dXRow = (DXRow)change.getValueRemoved();
                this.onCategoryRemoved((String)mapEntryTransform.getKey(dXRow));
            }
        });
    }

    protected ObservableList<XYChart.Series<Number, String>> computeValue() {
        return (ObservableList)this.dataProperty.get();
    }

    private void onCategoryAdded(String string, ObservableValue<? extends Number> observableValue) {
        XYChart.Data data = new XYChart.Data(observableValue.getValue(), (Object)string);
        this.listenForCategory(string, observableValue);
        int n = this.findInsertionIndex((Number)observableValue.getValue());
        this.categories.add(n, (Object)string);
        this.dataPoints.add(n, (Object)data);
    }

    private void onCategoryRemoved(String string) {
        int n = this.findCategoryIndex(string);
        if (n >= 0) {
            this.unlistenForCategory(string);
            this.dataPoints.remove(n);
            this.categories.remove(n);
        }
    }

    private void onCategoryValueChanged(String string, ObservableValue<? extends Number> observableValue) {
        XYChart.Data data;
        int n = this.findInsertionIndex((Number)observableValue.getValue());
        boolean bl = false;
        if (n > 0 && ((String)(data = (XYChart.Data)this.dataPoints.get(n - 1)).getYValue()).equals(string)) {
            data.setXValue(observableValue.getValue());
            bl = true;
        }
        if (!bl) {
            this.onCategoryRemoved(string);
            this.onCategoryAdded(string, observableValue);
        }
    }

    private int findInsertionIndex(Number number) {
        XYChart.Data data;
        int n = 0;
        Iterator iterator = this.dataPoints.iterator();
        while (iterator.hasNext() && !(((Number)(data = (XYChart.Data)iterator.next()).getXValue()).doubleValue() > number.doubleValue())) {
            ++n;
        }
        return n;
    }

    private int findCategoryIndex(String string) {
        int n = -1;
        int n2 = 0;
        for (XYChart.Data data : this.dataPoints) {
            if (((String)data.getYValue()).equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void listenForCategory(String string, ObservableValue<? extends Number> observableValue) {
        CategoryListener categoryListener = new CategoryListener(string, observableValue);
        this.listenerMap.put(string, categoryListener);
        categoryListener.listen();
    }

    private void unlistenForCategory(String string) {
        CategoryListener categoryListener = this.listenerMap.remove(string);
        if (categoryListener != null) {
            categoryListener.unlisten();
        }
    }

    private class CategoryListener
    implements ChangeListener<Number> {
        private final String category;
        private final ObservableValue<? extends Number> valueObject;

        CategoryListener(String string, ObservableValue<? extends Number> observableValue) {
            this.category = string;
            this.valueObject = observableValue;
        }

        void listen() {
            this.valueObject.addListener((ChangeListener)this);
        }

        void unlisten() {
            this.valueObject.removeListener((ChangeListener)this);
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            CategorySeriesMapBinding.this.onCategoryValueChanged(this.category, (ObservableValue<? extends Number>)this.valueObject);
        }
    }
}

