/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupsettings;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class SwitchArchiveLogModeAction
extends ActionDialog {
    private static final String ARCHIVELOG_MODE_ENABLED = "ARCHIVELOG_MODE_ENABLED";

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor(true, this);
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("SWITCH_ARCHIVE_LOG_MODE_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        Cloneable cloneable;
        Object object;
        boolean bl = false;
        if (Connections.getInstance().lock(connection)) {
            block6: {
                object = null;
                try {
                    cloneable = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    object = dBUtil.executeOracleQuery(this.getQuery(connection, "getArchiveLogMode"), (Map)((Object)cloneable));
                    if (object == null) break block6;
                    while (object.next()) {
                        bl = !object.getString("LOG_MODE").equals("NOARCHIVELOG");
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(object);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)object);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)object);
            Connections.getInstance().unlock(connection);
        }
        object = new BooleanCheckBoxActionControl(ARCHIVELOG_MODE_ENABLED, DbaNavigatorResources.getString("ENABLE_ARCHIVELOG_MODE_LABEL"), bl);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        ((ArrayList)cloneable).add(new SeperatorActionControl());
        ((ArrayList)cloneable).add(new RMANScriptProcessorActionControl(connection, "sqldev.rman"));
        return cloneable;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Boolean.parseBoolean(values.get(ARCHIVELOG_MODE_ENABLED));
        String string = RMANScriptProcessorActionControl.getJobName((ActionDialog.Lookup)values);
        stringBuffer.append("SHUTDOWN IMMEDIATE;\n");
        stringBuffer.append("STARTUP MOUNT;\n");
        stringBuffer.append("SQL \"ALTER DATABASE ");
        if (bl) {
            stringBuffer.append("ARCHIVELOG");
        } else {
            stringBuffer.append("NOARCHIVELOG");
        }
        stringBuffer.append("\";\n");
        stringBuffer.append("ALTER DATABASE OPEN;\n");
        if (string != null) {
            stringBuffer.append("SQL \"BEGIN DBMS_SCHEDULER.END_DETACHED_JOB_RUN(''");
            stringBuffer.append(string);
            stringBuffer.append("'', 0, null); END;\";");
        }
        return stringBuffer.toString();
    }
}

