/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs.NewSelectionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.AbstractActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.EditorActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ViewJobLogAction
extends ActionDialog {
    private static final String JOB_NAME = "JOB_NAME";
    private static final String ACTION = "ACTION";
    private static final String CREDENTIAL = "CREDENTIAL";
    private static final String LOG = "LOG";
    private String jobName;
    private String action;
    private String logPath;
    private String latestPath;
    private String jobCredential;
    private String[] credentials;
    private String log;

    protected AbstractActionDialog.DialogType getDialogType() {
        return AbstractActionDialog.DialogType.VIEW;
    }

    protected boolean shouldScrollEditPane() {
        return false;
    }

    protected ScriptProcessor createScriptProcessor() {
        return null;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("VIEW_LOG_TITLE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(final Connection connection) {
        ArrayList<ActionControl> arrayList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!DbaUtil.isSysdbaRole(connection) || DbaUtil.getDatabaseMajorVersion(connection) < 11) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("SCHEDULER_RMAN_NOT_SUPPORTED"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
            throw new RuntimeException("sysdba and 11g or higher is required for Unconfigure RMAN action");
        }
        boolean bl = "LATEST".equals(this.getArgs());
        if (!bl) {
            this.jobName = this.getDBObjectName();
        }
        String string = DbaUtil.getServerHome(connection);
        String string2 = "/";
        if (string.contains("\\")) {
            string2 = "\\";
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        if (Connections.getInstance().lock(connection)) {
            try {
                object4 = null;
                object3 = null;
                try {
                    object2 = new HashMap<String, String>();
                    if (!bl) {
                        ((HashMap)object2).put(JOB_NAME, this.jobName);
                    }
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    arrayList = bl ? this.getQuery(connection, "getLatestJobInfo") : this.getQuery(connection, "getJobInfo");
                    object4 = object.executeOracleQuery((String)((Object)arrayList), object2);
                    if (object4 != null) {
                        while (object4.next()) {
                            if (bl) {
                                this.jobName = object4.getString(JOB_NAME);
                            }
                            this.action = object4.getString(ACTION);
                            object3 = object4.getString("CREDENTIAL_NAME");
                        }
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)object4);
                }
                object4 = null;
                try {
                    object2 = new HashMap();
                    object = DBUtil.getInstance((Connection)connection);
                    object.setRaiseError(true);
                    object4 = object.executeOracleQuery(this.getQuery(connection, "getCredentials"), (Map)object2);
                    if (object4 != null) {
                        arrayList = new ArrayList();
                        while (object4.next()) {
                            String string3 = object4.getString("CREDENTIAL_NAME");
                            arrayList.add((ActionControl)string3);
                            if (!string3.equals(object3)) continue;
                            this.jobCredential = object3;
                        }
                        if (this.jobCredential == null && arrayList.size() > 0) {
                            this.jobCredential = (String)arrayList.get(0);
                        }
                        this.credentials = new String[arrayList.size()];
                        arrayList.toArray(this.credentials);
                    }
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    DBUtil.closeResultSet((ResultSet)object4);
                }
                if (this.jobCredential != null) {
                    object2 = string + "sqldeveloper" + string2 + "dbascripts" + string2;
                    this.latestPath = (String)object2 + "latest.properties";
                    if (bl && (object = this.getLatestProps(connection, this.latestPath, this.jobCredential)) != null) {
                        this.jobName = ((Properties)object).getProperty("job");
                        this.action = ((Properties)object).getProperty("action");
                    }
                    this.logPath = (String)object2 + (this.jobName != null ? this.jobName.replace('$', '_') : "") + ".log";
                    this.log = this.getLog(connection, this.logPath, this.jobCredential);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        object4 = new TextBoxActionControl(JOB_NAME, DbaNavigatorResources.getString("JOB_NAME_LABEL"), this.jobName);
        object3 = new TextBoxActionControl(ACTION, DbaNavigatorResources.getString("ACTION_LABEL"), this.action);
        object2 = new NewSelectionControl(CREDENTIAL, DbaNavigatorResources.getString("CREDENTIAL_LABEL"), this.credentials, new NewSelectionControl.NewListener(){

            @Override
            public String getButtonLabel() {
                return DbaNavigatorResources.getString("NEW_CREDENTIAL_LABEL");
            }

            @Override
            public String getNewComboItem() {
                return DbaUtil.createNewCredential(connection);
            }
        });
        ((NewSelectionControl)((Object)object2)).set(this.jobCredential);
        object = new EditorActionControl(LOG, this.log);
        object4.setEditable(false);
        object3.setEditable(false);
        object.setEditable(false);
        object2.addPropertyChangeListener(new PropertyChangeListener((NewSelectionControl)((Object)object2), bl, connection, (TextBoxActionControl)object4, (TextBoxActionControl)object3, (EditorActionControl)object){
            final /* synthetic */ NewSelectionControl val$credentialCtl;
            final /* synthetic */ boolean val$latest;
            final /* synthetic */ Connection val$conn;
            final /* synthetic */ TextBoxActionControl val$jobNameCtl;
            final /* synthetic */ TextBoxActionControl val$actionCtl;
            final /* synthetic */ EditorActionControl val$logCtl;
            {
                this.val$credentialCtl = newSelectionControl;
                this.val$latest = bl;
                this.val$conn = connection;
                this.val$jobNameCtl = textBoxActionControl;
                this.val$actionCtl = textBoxActionControl2;
                this.val$logCtl = editorActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Properties properties;
                ViewJobLogAction.this.jobCredential = this.val$credentialCtl.getValue().get();
                if (this.val$latest && (properties = ViewJobLogAction.this.getLatestProps(this.val$conn, ViewJobLogAction.this.latestPath, ViewJobLogAction.this.jobCredential)) != null) {
                    ViewJobLogAction.this.jobName = properties.getProperty("job");
                    this.val$jobNameCtl.set(ViewJobLogAction.this.jobName);
                    ViewJobLogAction.this.action = properties.getProperty("action");
                    this.val$actionCtl.set(ViewJobLogAction.this.action);
                }
                ViewJobLogAction.this.log = ViewJobLogAction.this.getLog(this.val$conn, ViewJobLogAction.this.logPath, ViewJobLogAction.this.jobCredential);
                this.val$logCtl.setEditable(true);
                try {
                    this.val$logCtl.set(ViewJobLogAction.this.log);
                }
                finally {
                    this.val$logCtl.setEditable(false);
                }
            }
        });
        arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object2);
        arrayList.add((ActionControl)object4);
        arrayList.add((ActionControl)object3);
        arrayList.add((ActionControl)object);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLog(Connection connection, String string, String string2) {
        String string3 = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                String string4 = this.getQuery(connection, "retrieveLog");
                try {
                    CallableStatement callableStatement = connection.prepareCall(string4);
                    callableStatement.setString("LOG_PATH", string);
                    callableStatement.setString(CREDENTIAL, string2);
                    callableStatement.registerOutParameter("LOG_CONTENT", 2005);
                    callableStatement.execute();
                    Clob clob = callableStatement.getClob("LOG_CONTENT");
                    Reader reader = clob.getCharacterStream();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = reader.read();
                    while (n >= 0) {
                        stringBuffer.append((char)n);
                        n = reader.read();
                    }
                    string3 = stringBuffer.toString();
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    string3 = DbaNavigatorResources.getString("NO_LOG_MESSAGE");
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLatestProps(Connection connection, String string, String string2) {
        Properties properties = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                String string3 = this.getQuery(connection, "retrieveLog");
                try {
                    CallableStatement callableStatement = connection.prepareCall(string3);
                    callableStatement.setString("LOG_PATH", string);
                    callableStatement.setString(CREDENTIAL, string2);
                    callableStatement.registerOutParameter("LOG_CONTENT", 2005);
                    callableStatement.execute();
                    Clob clob = callableStatement.getClob("LOG_CONTENT");
                    properties = new Properties();
                    properties.load(clob.getCharacterStream());
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return properties;
    }

    protected String getScript(ActionDialog.Values values) {
        return null;
    }
}

