/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backupactionjobs;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class ConfigurationGenerator {
    private String homeDir;
    private String sid;
    private boolean unix;
    private boolean hasWindowsSchedulerSupport;
    private String unixServerScriptDir;
    private String windowsServerScriptDir;
    private String unixChildScript;
    private String unixDetachedScript;
    private String windowsChildScript;
    private String windowsDetachedScript;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationGenerator(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            String string2 = null;
            try {
                String string3 = Utils.getQuery(ConfigurationGenerator.class, (Connection)connection, (String)"retrieveConfigValues");
                try {
                    CallableStatement callableStatement = connection.prepareCall(string3);
                    callableStatement.registerOutParameter("HOME", 12);
                    callableStatement.registerOutParameter("SID", 12);
                    callableStatement.execute();
                    this.homeDir = callableStatement.getString("HOME");
                    this.sid = callableStatement.getString("SID");
                    string2 = "/";
                    if (this.homeDir.contains("\\")) {
                        string2 = "\\";
                    }
                    string = this.homeDir.endsWith(string2) ? this.homeDir + "sqldeveloper" + string2 + "dbascripts" + string2 : this.homeDir + string2 + "sqldeveloper" + string2 + "dbascripts" + string2;
                    this.unix = string2.equals("/");
                    this.hasWindowsSchedulerSupport = false;
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    ExceptionHandler.handleException((Exception)sQLException, (String)string3, (int)-1);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        this.unixChildScript = "#!/bin/sh\nexport ORACLE_HOME=" + this.homeDir + "\n" + "export ORACLE_SID=" + this.sid + "\n" + "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib\n" + "$ORACLE_HOME/bin/rman TARGET / @$1 >& $2\n" + "if [ \"$?\" -ne \"0\" ]; then\n" + "   exit -1\n" + "fi\n" + "exit 0\n";
        this.unixDetachedScript = "#!/bin/sh\nexport ORACLE_HOME=" + this.homeDir + "\n" + "export ORACLE_SID=" + this.sid + "\n" + "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$ORACLE_HOME/lib\n" + "{\n" + "   $ORACLE_HOME/bin/rman TARGET / @$1 >& $2;\n" + "   if [ \"$?\" -ne \"0\" ]; then\n" + "      $ORACLE_HOME/bin/dbstart $ORACLE_HOME;\n" + "      exit -1;\n" + "   fi;\n" + "   exit 0;\n" + "} &\n" + "exit 0\n";
        if (this.hasWindowsSchedulerSupport) {
            this.windowsChildScript = "set ORACLE_HOME=" + this.homeDir + "\n" + "set ORACLE_SID=" + this.sid + "\n" + "set PATH=%PATH%;%ORACLE_HOME%\\lib\n" + "%ORACLE_HOME%\\bin\\rman TARGET / @%1 > %2\n" + "exit\n";
            this.windowsDetachedScript = "set ORACLE_HOME=" + this.homeDir + "\n" + "set ORACLE_SID=" + this.sid + "\n" + "set PATH=%PATH%;%ORACLE_HOME%\\lib\n" + "%ORACLE_HOME%\\bin\\rman TARGET / @%1 > %2\n" + "exit\n";
        } else {
            this.windowsChildScript = "# " + DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
            this.windowsDetachedScript = "# " + DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
        }
        this.unixServerScriptDir = string.replace('\\', '/');
        this.windowsServerScriptDir = string.replace('/', '\\');
    }

    public void setUnix(boolean bl) {
        this.unix = bl;
    }

    public boolean isUnix() {
        return this.unix;
    }

    public boolean isSchedulerSupported() {
        return this.unix || this.hasWindowsSchedulerSupport;
    }

    public void setUnixServerScriptDir(String string) {
        this.unixServerScriptDir = string;
    }

    public String getUnixServerScriptDir() {
        return this.unixServerScriptDir;
    }

    public void setWindowsServerScriptDir(String string) {
        this.windowsServerScriptDir = string;
    }

    public String getWindowsServerScriptDir() {
        return this.windowsServerScriptDir;
    }

    public void setUnixChildScript(String string) {
        this.unixChildScript = string;
    }

    public String getUnixChildScript() {
        return this.unixChildScript;
    }

    public void setUnixDetachedScript(String string) {
        this.unixDetachedScript = string;
    }

    public String getUnixDetachedScript() {
        return this.unixDetachedScript;
    }

    public void setWindowsChildScript(String string) {
        this.windowsChildScript = string;
    }

    public String getWindowsChildScript() {
        return this.windowsChildScript;
    }

    public void setWindowsDetachedScript(String string) {
        this.windowsDetachedScript = string;
    }

    public String getWindowsDetachedScript() {
        return this.windowsDetachedScript;
    }

    public String getServerScriptDir() {
        return this.unix ? this.unixServerScriptDir : this.windowsServerScriptDir;
    }

    public String getChildScript() {
        return this.unix ? this.unixChildScript : this.windowsChildScript;
    }

    public String getDetachedScript() {
        return this.unix ? this.unixDetachedScript : this.windowsDetachedScript;
    }

    public String generateConfigurationScript(String string) {
        if (!this.isSchedulerSupported()) {
            return "-- " + DbaNavigatorResources.getString("BACKUP_NO_WINDOWS_EXECUTION");
        }
        String string2 = this.unix ? ".sh" : ".bat";
        RMANScriptProcessorActionControl.updateDefaultCredential(string);
        String string3 = this.getServerScriptDir();
        String string4 = this.getChildScript();
        String string5 = this.getDetachedScript();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BEGIN \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_PROGRAM( \n");
        stringBuffer.append("          program_name => 'SQLDEV$DBA_CHILD', \n");
        stringBuffer.append("          force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_PROGRAM(  \n");
        stringBuffer.append("          program_name => 'SQLDEV$DBA_DETACHED', \n");
        stringBuffer.append("          force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        stringBuffer.append("    BEGIN \n");
        stringBuffer.append("        DBMS_SCHEDULER.DROP_JOB(  \n");
        stringBuffer.append("          job_name => 'SQLDEV$DBA_MKDIR', \n");
        stringBuffer.append("          defer => FALSE, force => TRUE); \n");
        stringBuffer.append("    EXCEPTION \n");
        stringBuffer.append("        WHEN OTHERS THEN \n");
        stringBuffer.append("          NULL; \n");
        stringBuffer.append("    END; \n");
        if (this.unix) {
            stringBuffer.append("    DBMS_SCHEDULER.CREATE_JOB( \n");
            stringBuffer.append("      job_name=>'SQLDEV$DBA_MKDIR', \n");
            stringBuffer.append("      job_type=>'EXECUTABLE', \n");
            stringBuffer.append("      job_action=>'/bin/mkdir', \n");
            stringBuffer.append("      number_of_arguments => 1, \n");
            stringBuffer.append("      enabled => false, \n");
            stringBuffer.append("      auto_drop =>true); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_MKDIR',1,'" + string3 + "'); \n");
        } else {
            stringBuffer.append("    DBMS_SCHEDULER.CREATE_JOB( \n");
            stringBuffer.append("      job_name=>'SQLDEV$DBA_MKDIR', \n");
            stringBuffer.append("      job_type=>'EXECUTABLE', \n");
            stringBuffer.append("      job_action=>'cmd', \n");
            stringBuffer.append("      number_of_arguments => 3, \n");
            stringBuffer.append("      enabled => false, \n");
            stringBuffer.append("      auto_drop =>true); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_MKDIR',1,'/c');\n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_MKDIR',2,'mkdir');\n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_MKDIR',3,'" + string3 + "'); \n");
        }
        stringBuffer.append("    DBMS_SCHEDULER.SET_ATTRIBUTE('SQLDEV$DBA_MKDIR','credential_name','\"" + string + "\"'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.ENABLE('SQLDEV$DBA_MKDIR'); \n");
        stringBuffer.append("    FOR l IN 1..50\n");
        stringBuffer.append("    LOOP\n");
        stringBuffer.append("        BEGIN\n");
        stringBuffer.append("            DBMS_SCHEDULER.PUT_FILE('" + string3 + "marker', NULL, '\"" + string + "\"', '\n'); \n");
        stringBuffer.append("            EXIT;\n");
        stringBuffer.append("        EXCEPTION\n");
        stringBuffer.append("            WHEN OTHERS THEN\n");
        stringBuffer.append("              NULL;\n");
        stringBuffer.append("        END;\n");
        stringBuffer.append("END LOOP;\n");
        stringBuffer.append("    DBMS_SCHEDULER.PUT_FILE('" + string3 + "marker', NULL, '\"" + string + "\"', '\n'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.PUT_FILE('" + string3 + "dba_child_job" + string2 + "', NULL, '\"" + string + "\"', '" + string4 + "'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.PUT_FILE('" + string3 + "dba_detached_job" + string2 + "', NULL, '\"" + string + "\"', '" + string5 + "'); \n");
        if (this.unix) {
            stringBuffer.append("    BEGIN \n");
            stringBuffer.append("        DBMS_SCHEDULER.DROP_JOB(  \n");
            stringBuffer.append("          job_name => 'SQLDEV$DBA_CHMOD', \n");
            stringBuffer.append("          defer => FALSE, force => TRUE); \n");
            stringBuffer.append("    EXCEPTION \n");
            stringBuffer.append("        WHEN OTHERS THEN \n");
            stringBuffer.append("          NULL; \n");
            stringBuffer.append("    END; \n");
            stringBuffer.append("    DBMS_SCHEDULER.CREATE_JOB( \n");
            stringBuffer.append("      job_name=>'SQLDEV$DBA_CHMOD', \n");
            stringBuffer.append("      job_type=>'EXECUTABLE', \n");
            stringBuffer.append("      job_action=>'/bin/chmod', \n");
            stringBuffer.append("      number_of_arguments => 3, \n");
            stringBuffer.append("      enabled => false, \n");
            stringBuffer.append("      auto_drop =>true); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_CHMOD',1,'+x'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_CHMOD',2,'" + string3 + "dba_child_job" + string2 + "'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_JOB_ARGUMENT_VALUE('SQLDEV$DBA_CHMOD',3,'" + string3 + "dba_detached_job" + string2 + "'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.SET_ATTRIBUTE('SQLDEV$DBA_CHMOD','credential_name','\"" + string + "\"'); \n");
            stringBuffer.append("    DBMS_SCHEDULER.ENABLE('SQLDEV$DBA_CHMOD'); \n");
        }
        stringBuffer.append("    DBMS_SCHEDULER.CREATE_PROGRAM( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_CHILD', \n");
        stringBuffer.append("        program_type => 'executable', \n");
        stringBuffer.append("        program_action => '" + string3 + "dba_child_job" + string2 + "', \n");
        stringBuffer.append("        number_of_arguments => 2, \n");
        stringBuffer.append("        enabled => FALSE); \n");
        stringBuffer.append("    DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_CHILD', \n");
        stringBuffer.append("        argument_position => 1, \n");
        stringBuffer.append("        argument_type => 'CHAR'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_CHILD', \n");
        stringBuffer.append("        argument_position => 2, \n");
        stringBuffer.append("        argument_type => 'CHAR'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.ENABLE('SQLDEV$DBA_CHILD'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.CREATE_PROGRAM( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_DETACHED', \n");
        stringBuffer.append("        program_type => 'executable', \n");
        stringBuffer.append("        program_action => '" + string3 + "dba_detached_job" + string2 + "', \n");
        stringBuffer.append("        number_of_arguments => 2, \n");
        stringBuffer.append("        enabled => FALSE); \n");
        stringBuffer.append("    DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_DETACHED', \n");
        stringBuffer.append("        argument_position => 1, \n");
        stringBuffer.append("        argument_type => 'CHAR'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.DEFINE_PROGRAM_ARGUMENT( \n");
        stringBuffer.append("        program_name => 'SQLDEV$DBA_DETACHED', \n");
        stringBuffer.append("        argument_position => 2, \n");
        stringBuffer.append("        argument_type => 'CHAR'); \n");
        stringBuffer.append("    DBMS_SCHEDULER.SET_ATTRIBUTE('SQLDEV$DBA_DETACHED', 'detached', TRUE); \n");
        stringBuffer.append("    DBMS_SCHEDULER.ENABLE('SQLDEV$DBA_DETACHED'); \n");
        stringBuffer.append("END; \n");
        return stringBuffer.toString();
    }
}

