/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.auditsettings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SelectionActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditAuditedPrivileges
extends ActionDialog {
    private static final String CLIENT_TYPES = "CLIENT_TYPES";
    private static final String CLIENTS = "CLIENTS";
    private static final String EXEC_CONDS = "EXEC_CONDS";
    private static final String GRANULARITIES = "GRANULARITIES";
    private static final String SELECTIONS = "SELECTIONS";
    private ComboBoxActionControl _clientTypesCtl;
    private ComboBoxActionControl _clientsCtl;
    private ComboBoxActionControl _execCondsCtl;
    private ComboBoxActionControl _granularitiesCtl;
    private SelectionActionControl _selectionCtl;
    private ArrayList<String> _initialValues;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_AUDITED_PRIVILEGES_TITLE");
    }

    protected List<ActionControl> createControls(final Connection connection) {
        this._clientTypesCtl = new ComboBoxActionControl(CLIENT_TYPES, DbaNavigatorResources.getString("CLIENT_TYPE_LABEL"), this.toStringArray(this.getClientTypes()));
        this._clientsCtl = new ComboBoxActionControl(CLIENTS, DbaNavigatorResources.getString("CLIENT_NAME_LABEL"), this.toStringArray(this.getClients(connection, this._clientTypesCtl.getValue().get())));
        this._execCondsCtl = new ComboBoxActionControl(EXEC_CONDS, DbaNavigatorResources.getString("EXEC_COND_LABEL"), this.toStringArray(this.getExecConditions()));
        this._granularitiesCtl = new ComboBoxActionControl(GRANULARITIES, DbaNavigatorResources.getString("DML_AUDIT_GRANULARITY_LABEL"), this.toStringArray(this.getGranularities()));
        this._selectionCtl = new SelectionActionControl(SELECTIONS, DbaNavigatorResources.getString("PRIVILEGES_LABEL"), this.getInitialItems(connection), this.getSourceItems(connection));
        this.enableControls();
        this._clientTypesCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                EditAuditedPrivileges.this._clientsCtl.reset(EditAuditedPrivileges.this.toStringArray(EditAuditedPrivileges.this.getClients(connection, EditAuditedPrivileges.this._clientTypesCtl.getValue().get())));
                EditAuditedPrivileges.this._selectionCtl.resetListContents(EditAuditedPrivileges.this.getInitialItems(connection), EditAuditedPrivileges.this.getSourceItems(connection));
                EditAuditedPrivileges.this.enableControls();
            }
        });
        this._clientsCtl.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (EditAuditedPrivileges.this._clientTypesCtl.getValue().get().equals(DbaNavigatorResources.getString("PROXY_ITEM"))) {
                    EditAuditedPrivileges.this._granularitiesCtl.reset(DbaNavigatorResources.getString("BY_DEFAULT_ITEM"));
                    EditAuditedPrivileges.this._granularitiesCtl.setEditable(false);
                } else {
                    EditAuditedPrivileges.this._granularitiesCtl.setEditable(true);
                }
                if (EditAuditedPrivileges.this._clientsCtl.getNumSelections() > 0) {
                    EditAuditedPrivileges.this._selectionCtl.resetListContents(EditAuditedPrivileges.this.getInitialItems(connection), EditAuditedPrivileges.this.getSourceItems(connection));
                }
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)this._clientTypesCtl);
        arrayList.add((ActionControl)this._clientsCtl);
        arrayList.add((ActionControl)this._execCondsCtl);
        arrayList.add((ActionControl)this._granularitiesCtl);
        arrayList.add((ActionControl)this._selectionCtl);
        return arrayList;
    }

    private String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    private List<String> getClientTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("USER_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("PROXY_ITEM"));
        return arrayList;
    }

    private List<String> getExecConditions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_OR_FAILURE_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("SUCCESS_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("FAILURE_ITEM"));
        return arrayList;
    }

    private List<String> getGranularities() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DbaNavigatorResources.getString("BY_DEFAULT_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("BY_SESSION_ITEM"));
        arrayList.add(DbaNavigatorResources.getString("BY_ACCESS_ITEM"));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getClients(Connection connection, String string) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = string.equals(DbaNavigatorResources.getString("USER_ITEM")) ? dBUtil.executeOracleQuery(this.getQuery(connection, "getUsers"), hashMap) : dBUtil.executeOracleQuery(this.getQuery(connection, "getProxies"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("NAME"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getSourceItems(Connection connection) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    HashMap hashMap = new HashMap();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getPrivileges"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("NAME"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        arrayList.removeAll(this.getInitialItems(connection));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getInitialItems(Connection connection) {
        ArrayList<String> arrayList;
        block14: {
            String string = this._clientTypesCtl.getValue().get();
            String string2 = this._clientsCtl.getValue().get();
            arrayList = new ArrayList<String>();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    int n;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    if (string.equals(DbaNavigatorResources.getString("USER_ITEM"))) {
                        if (string2.equals("*")) {
                            resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getPrivilegesForSystem"), hashMap);
                        } else {
                            hashMap.put("USERNAME", string2);
                            resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getPrivilegesForUser"), hashMap);
                        }
                    } else if (string2 != null && (n = string2.indexOf(40)) >= 0) {
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 1, string2.length() - 1);
                        if (string4.equals("*")) {
                            string4 = "ANY CLIENT";
                        }
                        hashMap.put("USERNAME", string4);
                        hashMap.put("PROXYNAME", string3);
                        resultSet = dBUtil.executeOracleQuery(this.getQuery(connection, "getPrivilegesForProxy"), hashMap);
                    }
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            arrayList.add(resultSet.getString("PRIVILEGE"));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block14;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        this._initialValues = arrayList;
        return arrayList;
    }

    private void enableControls() {
        boolean bl = this._clientsCtl.getNumSelections() != 0;
        this._clientsCtl.enableUI(bl);
        this._execCondsCtl.enableUI(bl);
        this._granularitiesCtl.enableUI(bl);
        this._selectionCtl.enableUI(bl);
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        List list = values.getList(SELECTIONS, "SELECTED_ITEMS");
        if (this._initialValues != null) {
            String string2;
            boolean bl = true;
            for (String string2 : this._initialValues) {
                if (list.contains(string2)) continue;
                if (bl) {
                    stringBuffer.append("NOAUDIT\n    ");
                    bl = false;
                } else {
                    stringBuffer.append(",\n    ");
                }
                stringBuffer.append(string2);
            }
            String string3 = values.get(CLIENT_TYPES);
            string2 = values.get(CLIENTS);
            if (!bl) {
                this.addByUserOrProxy(stringBuffer, string3, string2);
                stringBuffer.append(";\n");
            }
            boolean bl2 = true;
            for (String string4 : list) {
                if (this._initialValues.contains(string4)) continue;
                if (bl2) {
                    stringBuffer.append("AUDIT\n    ");
                    bl2 = false;
                } else {
                    stringBuffer.append(",\n    ");
                }
                stringBuffer.append(string4);
            }
            if (!bl2) {
                String string4;
                this.addByUserOrProxy(stringBuffer, string3, string2);
                String string5 = values.get(GRANULARITIES);
                string4 = values.get(EXEC_CONDS);
                if (string5.equals(DbaNavigatorResources.getString("BY_SESSION_ITEM"))) {
                    stringBuffer.append("\nBY SESSION");
                } else if (string5.equals(DbaNavigatorResources.getString("BY_ACCESS_ITEM"))) {
                    stringBuffer.append("\nBY ACCESS");
                }
                if (string4.equals(DbaNavigatorResources.getString("SUCCESS_ITEM"))) {
                    stringBuffer.append("\nWHENEVER SUCCESSFUL");
                } else if (string4.equals(DbaNavigatorResources.getString("FAILURE_ITEM"))) {
                    stringBuffer.append("\nWHENEVER NOT SUCCESSFUL");
                }
                stringBuffer.append(";\n");
            }
        }
        return stringBuffer.toString();
    }

    private void addByUserOrProxy(StringBuffer stringBuffer, String string, String string2) {
        if (string.equals(DbaNavigatorResources.getString("USER_ITEM"))) {
            if (!string2.equals("*")) {
                stringBuffer.append("\nBY \"");
                stringBuffer.append(string2);
                stringBuffer.append("\"");
            }
        } else {
            int n = string2.indexOf(40);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length() - 1);
            string4 = string4.equals("*") ? "ANY" : "\"" + string4 + "\"";
            stringBuffer.append("\nBY \"");
            stringBuffer.append(string3);
            stringBuffer.append("\" ON BEHALF OF ");
            stringBuffer.append(string4);
        }
    }
}

