/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.adapter;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attributes;
import javax.sql.DataSource;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;
import oracle.jdeveloper.db.adapter.DB2ConnectionCreator;
import oracle.jdeveloper.db.adapter.DatabaseProviderClassLoaderFactory;
import oracle.jdeveloper.db.adapter.DerbyConnectionCreator;
import oracle.jdeveloper.db.adapter.MySQLConnectionCreator;
import oracle.jdeveloper.db.adapter.ODBCConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;
import oracle.jdeveloper.db.adapter.OracleLiteConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLServerConnectionCreator;
import oracle.jdeveloper.db.adapter.SQLiteConnectionCreator;
import oracle.jdeveloper.db.ssh.SSHTunnel;
import oracle.jdeveloper.db.ssh.SSHTunnelConfiguration;
import oracle.jdeveloper.db.ssh.SSHTunnelManager;
import oracle.jdevimpl.db.adapter.DatabaseProviderFactory1212;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.ReferenceWorker;
import oracle.jdevimpl.db.resource.DBAdapterBundle;

public class DatabaseProvider
implements Referenceable,
DataSource {
    static final Class PROVIDER_CLASS = DatabaseProvider.class;
    static final String PROVIDER_CLASSNAME = PROVIDER_CLASS.getName();
    public static final String SUBTYPE_CLASS_REFTYPE = "subtype";
    public static final String CUSTOM_URL_CLASS_REFTYPE = "customUrl";
    public static final String DRIVER_CLASS_REFTYPE = "driver";
    public static final String USERNAME_CLASS_REFTYPE = "user";
    public static final String PASSWORD_CLASS_REFTYPE = "password";
    public static final String ROLE_CLASS_REFTYPE = "role";
    public static final String HOSTNAME_CLASS_REFTYPE = "hostname";
    public static final String PORT_CLASS_REFTYPE = "port";
    public static final String SID_CLASS_REFTYPE = "sid";
    public static final String DSN_CLASS_REFTYPE = "dataSourceName";
    @Deprecated
    public static final String INSTANCE_CLASS_REFTYPE = "instanceName";
    public static final String PARAMETERS_CLASS_REFTYPE = "parameters";
    public static final String SERVICENAME_CLASS_REFTYPE = "serviceName";
    public static final String SAVE_PASSWORD_CLASS_REFTYPE = "SavePassword";
    @Deprecated
    public static final String DEPLOY_PASSWORD_CLASS_REFTYPE = "DeployPassword";
    @Deprecated
    public static final String ALL_SCHEMAS_REFTYPE = "allSchemas";
    private static DatabaseProviderClassLoaderFactory s_clFactory;
    private static Map<String, Object> s_creators;
    private final Map<String, Object> m_properties = new ConcurrentHashMap<String, Object>();
    private final String m_name;
    private ReferenceWorker m_worker;
    private PrintWriter m_pw;
    private int m_timeout;

    public DatabaseProvider() {
        this(null, null);
    }

    public DatabaseProvider(Properties props) {
        this(null, props);
    }

    public DatabaseProvider(String name, Properties props) {
        this.m_name = name;
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                Object val = entry.getValue();
                if (val instanceof char[]) {
                    this.setCredential((String)key, (char[])val);
                    continue;
                }
                if (!(val instanceof String)) continue;
                this.setProperty((String)key, (String)val);
            }
        }
    }

    public void setReferenceWorker(ReferenceWorker worker) {
        this.m_worker = worker;
    }

    public String getName() {
        return this.m_name;
    }

    @Override
    public Reference getReference() {
        DatabaseProviderHelper.PasswordPrompter pp;
        ConnectionCreator cc = null;
        try {
            cc = DatabaseProvider.getCreator(this);
        }
        catch (SQLException sqe) {
            cc = new OracleConnectionCreator();
        }
        ReferenceWorker encryptionWorker = this.m_worker == null ? DatabaseProviderHelper.getDefaultWorker() : this.m_worker;
        Class factoryClass = encryptionWorker == null ? DatabaseProviderFactory1212.class : encryptionWorker.getFactoryClass();
        Reference ref = new Reference(PROVIDER_CLASSNAME, factoryClass.getName(), null);
        boolean cacheWithPrompter = false;
        for (Map.Entry<String, Object> entry : this.m_properties.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            boolean isCharArr = value instanceof char[];
            boolean enc = isCharArr || cc.shouldEncrypt(name);
            boolean save = cc.shouldSave(name, this);
            if (!isCharArr && !(value instanceof String)) {
                DatabaseProvider.getLogger().warning(this.m_name + ": invalid value for property " + name);
                continue;
            }
            if (save) {
                if (enc) {
                    char[] pwd = isCharArr ? (char[])value : ((String)value).toCharArray();
                    Object addr = encryptionWorker == null ? new SecureRefAddr(name, pwd) : encryptionWorker.encrypt(name, pwd, this.m_name);
                    ref.add((RefAddr)addr);
                    continue;
                }
                ref.add(new StringRefAddr(name, (String)value));
                continue;
            }
            if (!enc || value == null) continue;
            cacheWithPrompter = true;
        }
        if (cacheWithPrompter && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            pp.cache(this);
        }
        return ref;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getProperties());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties props = this.getProperties();
        props.setProperty(USERNAME_CLASS_REFTYPE, username);
        props.setProperty(PASSWORD_CLASS_REFTYPE, password);
        return this.getConnection(props);
    }

    private Connection getConnection(Properties props) throws SQLException {
        DatabaseProviderHelper.PasswordPrompter pp;
        ConnectionCreator creator;
        if (this.m_name != null && this.m_name.length() > 0) {
            Object obj = null;
            try {
                InitialContext ic = new InitialContext();
                try {
                    obj = ic.lookup("jdbc/" + this.m_name + "DS");
                }
                catch (NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if (obj == null) {
                    try {
                        obj = ic.lookup("java:comp/env/jdbc/" + this.m_name + "DS");
                    }
                    catch (NameNotFoundException nameNotFoundException) {}
                }
            }
            catch (Exception ic) {
                // empty catch block
            }
            if (obj instanceof DataSource) {
                return ((DataSource)obj).getConnection();
            }
        }
        if ((creator = DatabaseProvider.getCreator(this)).shouldPromptForPassword(props) && (pp = DatabaseProviderHelper.getPasswordPrompter()) != null) {
            return pp.promptForPassword(this);
        }
        SSHTunnel tunnel = null;
        SSHTunnelManager tmgr = SSHTunnelManager.getInstance();
        if (tmgr != null && SSHTunnelConfiguration.requiresTunnel(this)) {
            tunnel = tmgr.openTunnel(this);
            String newURL = tunnel.getLocalConnectionURL(this);
            props.setProperty(CUSTOM_URL_CLASS_REFTYPE, newURL);
        }
        Connection retval = creator.getConnection(props);
        if (tunnel != null) {
            retval = tunnel.wrapConnection(retval);
        }
        return retval;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pw;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pw = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_timeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_timeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() {
        return DatabaseProvider.getLogger();
    }

    public String getConnectionURL() throws SQLException {
        return DatabaseProvider.getCreator(this).getConnectionURL(this.getProperties());
    }

    public Properties getJDBCProperties() throws SQLException {
        return DatabaseProvider.getCreator(this).getJDBCProperties(this.getProperties());
    }

    public String getDriverClassName() throws SQLException {
        return DatabaseProvider.getCreator(this).getDriverClassName(this.getProperties());
    }

    public boolean shouldPromptForCredentials() {
        ConnectionCreator creator = DatabaseProvider.getCreatorImpl(this);
        return creator != null && creator.shouldPromptForPassword(this.getProperties());
    }

    public String getProperty(String name) {
        Object val = this.m_properties.get(name);
        String retval = val instanceof char[] ? new String((char[])val) : (val instanceof String ? (String)val : null);
        return retval;
    }

    public Properties getProperties() {
        Properties retval = new Properties();
        for (String prop : this.m_properties.keySet()) {
            String value = this.getProperty(prop);
            if (value == null) continue;
            retval.setProperty(prop, value);
        }
        return retval;
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.put(name, value);
        }
    }

    public char[] getCredential(String name) {
        Object val = this.m_properties.get(name);
        Object retval = val instanceof char[] ? (char[])val : (Object)(val instanceof String ? ((String)val).toCharArray() : null);
        return retval;
    }

    public void setCredential(String name, char[] value) {
        if (value == null) {
            this.m_properties.remove(name);
        } else {
            this.m_properties.put(name, value);
        }
    }

    public void disconnect() {
        DatabaseProviderHelper.PasswordPrompter pp = DatabaseProviderHelper.getPasswordPrompter();
        if (pp != null) {
            pp.disconnect(this);
        }
    }

    public int hashCode() {
        return this.m_properties.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseProvider && this.equalsImpl((DatabaseProvider)obj);
    }

    private boolean equalsImpl(DatabaseProvider prov) {
        return DatabaseProvider.areEqual(this.m_name, prov.m_name) && DatabaseProvider.areEqual(this.m_properties, prov.m_properties);
    }

    @Deprecated
    public Attributes getAttributes() {
        return null;
    }

    @Deprecated
    static ClassLoader getClassLoader(String driverClass) {
        return DatabaseProvider.getClassLoader(driverClass, null);
    }

    static ClassLoader getClassLoader(String driverClass, ClassLoader creatorClassLoader) {
        ClassLoader cl = null;
        if (s_clFactory != null) {
            cl = s_clFactory.getClassLoader(driverClass);
        }
        if (cl == null && creatorClassLoader != null) {
            cl = DatabaseProvider.tryLoad(creatorClassLoader, driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(Thread.currentThread().getContextClassLoader(), driverClass);
        }
        ClassLoader ourClassLoader = PROVIDER_CLASS.getClassLoader();
        if (cl == null && creatorClassLoader != ourClassLoader) {
            cl = DatabaseProvider.tryLoad(ourClassLoader, driverClass);
        }
        if (cl == null) {
            cl = DatabaseProvider.tryLoad(ClassLoader.getSystemClassLoader(), driverClass);
        }
        return cl;
    }

    private static ClassLoader tryLoad(ClassLoader l, String name) {
        if (l == null) {
            return null;
        }
        try {
            l.loadClass(name);
            return l;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static void setClassLoaderFactory(DatabaseProviderClassLoaderFactory factory) {
        s_clFactory = factory;
    }

    private static boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static ConnectionCreator getCreator(DatabaseProvider dp) throws SQLException {
        ConnectionCreator retval = DatabaseProvider.getCreatorImpl(dp);
        if (retval == null) {
            throw new SQLException(DBAdapterBundle.format("ERROR_INVALID_SUBTYPE", dp.getProperty(SUBTYPE_CLASS_REFTYPE)));
        }
        return retval;
    }

    private static ConnectionCreator getCreatorImpl(DatabaseProvider dp) {
        ConnectionCreator retval = null;
        String subtype = dp.getProperty(SUBTYPE_CLASS_REFTYPE);
        Object obj = s_creators.get(subtype);
        if (obj instanceof ConnectionCreator) {
            retval = (ConnectionCreator)obj;
        } else if (obj instanceof Callable) {
            try {
                retval = (ConnectionCreator)((Callable)obj).call();
            }
            catch (Exception e) {
                DatabaseProvider.getLogger().log(Level.SEVERE, subtype, e);
            }
        }
        return retval;
    }

    public static synchronized void registerConnectionCreator(String subtype, ConnectionCreator creator) {
        DatabaseProvider.registerCCImpl(subtype, creator);
    }

    public static synchronized void registerLazyConnectionCreator(String subtype, Callable<ConnectionCreator> creator) {
        DatabaseProvider.registerCCImpl(subtype, creator);
    }

    private static void registerCCImpl(String subtype, Object obj) {
        Object removed = obj == null ? s_creators.remove(subtype) : s_creators.put(subtype, obj);
        if (removed != null) {
            DatabaseProvider.getLogger().fine("DB Adapter warning: Replacing connection creator  for subtype " + subtype);
        }
    }

    private static Logger getLogger() {
        return DatabaseProviderHelper.getLogger();
    }

    static {
        s_creators = new ConcurrentHashMap<String, Object>();
        s_creators.put("oraJDBC", new OracleConnectionCreator());
        s_creators.put("oraLite", new OracleLiteConnectionCreator());
        s_creators.put("thirdParty", new CustomConnectionCreator());
        s_creators.put("ODBCBridge", new ODBCConnectionCreator());
        s_creators.put("MYSQL", new MySQLConnectionCreator());
        s_creators.put("DB2", new DB2ConnectionCreator());
        s_creators.put("SQLServer", new SQLServerConnectionCreator());
        s_creators.put("SQLite", new SQLiteConnectionCreator());
        s_creators.put("derby", new DerbyConnectionCreator());
    }
}

