/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.wiz.import_;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSImport;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNodeCommands;
import oracle.jdeveloper.vcs.util.VCSURLPatternFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceMonitorException;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.wiz.PerforceWizard;
import oracle.jdevimpl.vcs.perforce2.wiz.import_.ImportDestinationPanel;
import oracle.jdevimpl.vcs.perforce2.wiz.import_.ImportFilterPanel;
import oracle.jdevimpl.vcs.perforce2.wiz.import_.ImportLocationPanel;
import oracle.jdevimpl.vcs.perforce2.wiz.import_.ImportSummary;

public class PerforceImportWizard
extends PerforceWizard {
    private static final Logger slogger = PerforceProfile.getQualifiedLogger(PerforceImportWizard.class.getName());
    private static int COMMAND_LINE = 8000;
    private static final String IMPORT_DESTINATION = "Destination";
    private static final String IMPORT_LOCATION = "location";
    private static final String IMPORT_FILTER = "filter";
    private static final String IMPORT_SUMMARY = "summary";
    static final String KEY_SRC_FOLDER = "source_folder";
    static final String KEY_DST_FOLDER = "destination folder";
    static final String KEY_FILTERS = "filters";
    static final String KEY_NODES_TO_CLOSE = "nodesclose";
    static final String KEY_CONN_NAME = "connection_names";
    static final String KEY_SELECT_CON = "selected_connection";
    private WizardDialog wd;
    private Namespace ns;
    private URL rootURL;
    private Node[] nodes;
    private URL newURL;

    public boolean runWizard(Component parent, Context context) {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)PerforceArb.get("IMPORT_TITLE"), (String)PerforceArb.get("IMPORT_WIZARD_HEADER"), (String)PerforceArb.get("IMPORT_WIZARD_WELCOME_TEXT"), (String)"PerforceImportSkipNextTime", (String)"f1_pfcimpwwelcome_html");
        fsmBuilder.newStartState(welcomeStep, (Object)IMPORT_DESTINATION);
        Step step = new Step(PerforceArb.get("LOCATION_DESTINATION_TITLE"), ImportDestinationPanel.class, "");
        fsmBuilder.newState((Object)IMPORT_DESTINATION, step, (Object)IMPORT_LOCATION);
        step = new Step(PerforceArb.get("LOCATION_FILES_TITLE"), ImportLocationPanel.class, "f1_pfcimpwfolderlocations_html");
        fsmBuilder.newState((Object)IMPORT_LOCATION, step, (Object)IMPORT_FILTER);
        step = new Step(PerforceArb.get("FILTER_TITLE"), ImportFilterPanel.class, "f1_pfcimpwfilters_html");
        fsmBuilder.newState((Object)IMPORT_FILTER, step, (Object)IMPORT_SUMMARY);
        step = new Step(PerforceArb.get("IMPORT_SUMMARY_TITLE"), ImportSummary.class, "f1_pfcimpwsummary_html");
        fsmBuilder.newFinalState((Object)IMPORT_SUMMARY, step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            this.ns = this.populate(context);
            if (this.ns == null) {
                return false;
            }
            FSMWizard wiz = new FSMWizard(stateMachine, this.ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(PerforceArb.get("IMPORT_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setLogoImage(VCSImport.getWizardImage().getImage());
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this.rootURL = this.getSelectedUrl(context);
            this.wd = this.createWizardDialog(wiz, parent);
            if (WizardLauncher.runDialog((JDialog)this.wd)) {
                return true;
            }
        }
        catch (FSMInvalidException fie) {
            slogger.log(Level.WARNING, "Failed to create import wizard", fie);
        }
        catch (Exception e) {
            slogger.log(Level.WARNING, "Failed to create import wizard", e);
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
        }
        return false;
    }

    @Override
    protected boolean commitWizard() {
        WaitCursor cursor = new WaitCursor((Component)this.wd);
        cursor.show();
        try {
            if (this.runOperation()) {
                // empty if block
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            slogger.log(Level.WARNING, "Failed to commit import", e);
            this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            cursor.hide();
        }
        return false;
    }

    private Namespace populate(Context context) throws Exception {
        Namespace ns = new Namespace();
        URL srcURL = this.getSelectedUrl(context);
        if (srcURL == null) {
            return null;
        }
        ns.put(KEY_SRC_FOLDER, (Object)URLFileSystem.getParent((URL)srcURL));
        Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
        if (cons.isEmpty()) {
            return null;
        }
        ns.put(KEY_CONN_NAME, cons);
        ns.put(KEY_FILTERS, (Object)VCSIgnoreFilters.getAllIgnoreFilters());
        return ns;
    }

    private URL getSelectedUrl(Context context) {
        Element[] elms = context.getSelection();
        URL srcURL = null;
        if (elms[0] instanceof Workspace) {
            srcURL = ((Workspace)elms[0]).getURL();
        } else {
            Element elm = context.getElement();
            if (elm instanceof Locatable) {
                srcURL = ((Locatable)elm).getURL();
            }
        }
        return srcURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOperation() throws Exception {
        Collection filters = (Collection)this.ns.get(KEY_FILTERS);
        URL srcURL = (URL)this.ns.get(KEY_SRC_FOLDER);
        URL dstURL = (URL)this.ns.get(KEY_DST_FOLDER);
        PerforceConnectionProfile con = (PerforceConnectionProfile)this.ns.get(KEY_SELECT_CON);
        IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), PerforceArb.get("IMPORT_PROGRESS_TITLE"));
        monitor.setMillisToPopup(0);
        monitor.start();
        try {
            Collection urls = this.getURLsToCopy(srcURL, filters, monitor);
            this.nodes = this.getNodes(urls);
            this.saveNodes(this.nodes);
            Collection dURLS = this.copyURLsToDestFolder(urls, srcURL, dstURL, monitor);
            List<List<String>> batches = this.batchFiles(dURLS);
            Iterator it = batches.iterator();
            List<ChangeListFile> files = Collections.emptyList();
            String chgListNo = PerforceCommands.createChangeList(con, PerforceArb.format("IMPORT_COMMENT", ProductInformation.getProductInformation().getShortName()), files);
            if (chgListNo == null) {
                while (it.hasNext()) {
                    List batch = (List)it.next();
                    this.performAddOperation(con, batch, null, monitor);
                    this.performSubmitOperation(con, batch, monitor);
                }
            } else {
                while (it.hasNext()) {
                    List batch = (List)it.next();
                    this.performAddOperation(con, batch, chgListNo, monitor);
                }
                PerforceCommands.submitChangelist(chgListNo, PerforceArb.format("IMPORT_COMMENT", ProductInformation.getProductInformation().getShortName()), con);
            }
            this.newURL = this.findProjectOrWorkspaceToReopen(dURLS, srcURL);
            if (this.newURL != null) {
                this.openAndCloseURL(this.nodes, this.newURL);
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)PerforceArb.get("IMPORT_WARN_NO_LOCATE_PROJECT"), (String)PerforceArb.get("IMPORT_WARN_TITLE"), null);
            }
        }
        catch (PerforceMonitorException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            slogger.log(Level.INFO, "Import of application/project was successful");
            monitor.finish();
        }
        return true;
    }

    private List<List<String>> batchFiles(Collection urls) {
        ArrayList<List<String>> batches = new ArrayList<List<String>>();
        int cmdlength = 0;
        ArrayList<String> batch = new ArrayList<String>();
        for (URL url : urls) {
            String filename = VCSFileSystemUtils.getPlatformPathName((URL)url);
            if (cmdlength + filename.length() > COMMAND_LINE) {
                batches.add(batch);
                batch = new ArrayList();
                cmdlength = 0;
            }
            batch.add(filename);
            cmdlength += filename.length() + 1;
        }
        batches.add(batch);
        return batches;
    }

    private void closeNodes(Node[] node) throws PerforceProcessException {
        Context context = Context.newIdeContext();
        context.setSelection((Element[])node);
        try {
            Command command = VCSNodeCommands.createQuietCloseNodeCommand((Context)context);
            command.doit();
        }
        catch (Exception e) {
            slogger.log(Level.WARNING, "Failed to close files during import", e);
            throw new PerforceProcessException(PerforceArb.get("IMPORT_PROGRESS_ERR"), PerforceArb.get("IMPORT_PROGRESS_ERROR_ED"), e.getMessage());
        }
    }

    private URL findProjectOrWorkspaceToReopen(Collection urls, URL srcURL) {
        String projectPath = URLFileSystem.getPath((URL)this.rootURL);
        String srcPath = URLFileSystem.getPath((URL)srcURL);
        if (projectPath.length() < srcPath.length()) {
            return null;
        }
        String project = projectPath.substring(srcPath.length());
        for (URL url : urls) {
            String urlPath = URLFileSystem.getPath((URL)url);
            if (!urlPath.endsWith(project)) continue;
            return url;
        }
        return null;
    }

    private void openAndCloseURL(final Node[] nodes, final URL url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PerforceImportWizard.this.closeNodes(nodes);
                    Node node = NodeFactory.findOrCreate((URL)url);
                    OpenCommand cmd = new OpenCommand();
                    cmd.setContext(Context.newIdeContext((Node)node));
                    cmd.openURL(url);
                }
                catch (Exception e) {
                    slogger.log(Level.WARNING, "Failed to open " + url);
                    PerforceImportWizard.this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
                }
            }
        });
    }

    private Node[] getNodes(Collection urls) throws Exception {
        Node[] node = VCSModelUtils.findCachedNodes((URLFilter)new URLCompareFilter(urls));
        return node;
    }

    private void performAddOperation(PerforceConnectionProfile connect, List<String> files, String chgListNo, IndeterminateProgressMonitor monitor) throws Exception {
        monitor.getPanel().setMessage(PerforceArb.get("IMPORT_PROGRESS_ADD"));
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("add");
        if (chgListNo != null) {
            cmd.add("-c");
            cmd.add(chgListNo);
        }
        runner.setCmdList(cmd);
        runner.setConnection(connect);
        runner.setFiles(files);
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_ADD_FAILED_TITLE"), PerforceArb.get("ERROR_ADD_FAILED"), runner.getErrorText());
        }
        if (monitor.isCancelled()) {
            throw new PerforceMonitorException();
        }
    }

    private boolean performSubmitOperation(PerforceConnectionProfile connect, List<String> files, IndeterminateProgressMonitor monitor) throws Exception {
        monitor.getPanel().setMessage(PerforceArb.get("IMPORT_PROGRESS_SUBMIT"));
        PerforceShellRunner runner = new PerforceShellRunner();
        String comment = PerforceArb.format("IMPORT_SUBMIT_COMMENT", ProductInformation.getProductInformation().getShortName());
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("submit");
        cmd.add("-i");
        runner.setConnection(connect);
        runner.setCmdList(cmd);
        runner.setFiles(files);
        PerforceCommands.submit(runner, comment, connect);
        if (monitor.isCancelled()) {
            throw new PerforceMonitorException();
        }
        return true;
    }

    private Collection getURLsToCopy(URL srcFld, Collection patterns, IndeterminateProgressMonitor monitor) throws PerforceMonitorException {
        monitor.getPanel().setMessage(PerforceArb.get("IMPORT_PROGRESS_DETER"));
        LinkedHashSet urls = new LinkedHashSet();
        if (patterns == null || patterns.isEmpty()) {
            this.getURLsToCopy(srcFld, null, urls, monitor);
        } else {
            this.getURLsToCopy(srcFld, (URLFilter)new VCSURLPatternFilters(patterns), urls, monitor);
        }
        return urls;
    }

    private void getURLsToCopy(URL srcFld, URLFilter filter, Collection urls, IndeterminateProgressMonitor monitor) throws PerforceMonitorException {
        URL[] srcURLs = URLFileSystem.list((URL)srcFld, (URLFilter)filter);
        for (int u = 0; u < srcURLs.length; ++u) {
            if (URLFileSystem.isDirectory((URL)srcURLs[u])) {
                this.getURLsToCopy(srcURLs[u], filter, urls, monitor);
                continue;
            }
            urls.add(srcURLs[u]);
            if (!monitor.isCancelled()) continue;
            throw new PerforceMonitorException();
        }
    }

    private Collection copyURLsToDestFolder(Collection urls, URL srcFldURL, URL dstFldURL, IndeterminateProgressMonitor monitor) throws PerforceMonitorException {
        LinkedHashSet<URL> dstURLs = new LinkedHashSet<URL>(urls.size());
        monitor.getPanel().setMessage(PerforceArb.get("IMPORT_PROGRESS_DEST"));
        Iterator srcIt = urls.iterator();
        String srcFldPath = URLFileSystem.getPath((URL)srcFldURL);
        while (srcIt.hasNext()) {
            URL srcURL = (URL)srcIt.next();
            String path = URLFileSystem.getPath((URL)srcURL).substring(srcFldPath.length());
            URL destURL = URLFactory.newURL((URL)dstFldURL, (String)path);
            try {
                URLFileSystem.copy((URL)srcURL, (URL)destURL);
                dstURLs.add(destURL);
                if (!monitor.isCancelled()) continue;
                throw new PerforceMonitorException();
            }
            catch (IOException e) {
                slogger.log(Level.WARNING, "Failed to copy contents of " + srcFldURL + " to " + dstFldURL);
            }
        }
        return dstURLs;
    }

    private void saveNodes(Node[] closeNodes) {
        for (Node node : closeNodes) {
            if (!node.isDirty()) continue;
            try {
                node.save();
            }
            catch (IOException e) {
                slogger.log(Level.WARNING, "Failed to save " + node.getURL());
            }
        }
    }

    private static class URLCompareFilter
    implements URLFilter {
        private Collection urls;

        public URLCompareFilter(Collection urls) {
            this.urls = urls;
        }

        public boolean accept(URL url) {
            return this.urls.contains(url);
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return o instanceof URLCompareFilter;
        }

        public String toString() {
            return "URLCompareFilter";
        }
    }
}

