/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.wiz.import_;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLoginCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.util.FilePanel;

public class ImportDestinationPanel
extends DefaultTraversablePanel {
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JMultiLineLabel hintText = new JMultiLineLabel();
    private JLabel _lblConnectionName = new JLabel();
    private JComboBox _cmbConnection = new JComboBox();
    private JLabel _lblDestination = new JLabel();
    private FilePanel _dstFolder = new FilePanel();
    private boolean populated = false;
    private String _clientName;

    public ImportDestinationPanel() {
        this.jbInit();
    }

    public void onEntry(TraversableContext dataContext) {
        if (!this.populated && dataContext.getDirection() == 1) {
            URL srcFld = (URL)dataContext.get("source_folder");
            this._clientName = URLFileSystem.getFileName((URL)srcFld);
            this.populateConnectNames(dataContext);
            this.populated = true;
        }
        dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    private void populateConnectNames(TraversableContext dataContext) {
        Collection cons = (Collection)dataContext.get("connection_names");
        for (PerforceConnectionProfile con : cons) {
            this._cmbConnection.addItem(con);
            if (!PerforceSessionManager.getInstance().isConnected(con)) continue;
            this._cmbConnection.setSelectedItem(con);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            if (this._dstFolder.isFieldEmpty()) {
                throw new TraversalException(PerforceArb.get("IMPORT_DST_EMPTY"));
            }
            URL dstURL = this._dstFolder.getURL();
            if (URLFileSystem.exists((URL)dstURL)) {
                throw new TraversalException(PerforceArb.format("IMPORT_DST_FLD_EXIST", URLFileSystem.getPlatformPathName((URL)dstURL)));
            }
            URL root = PerforceSessionManager.getInstance().getClientRootFolder(this.getConnectionProfile());
            if (!URLFileSystem.isBaseURLFor((URL)root, (URL)dstURL)) {
                throw new TraversalException(PerforceArb.format("IMPORT_DST_OUTSIDE_ROOT", URLFileSystem.getPlatformPathName((URL)dstURL), URLFileSystem.getPlatformPathName((URL)root)));
            }
            try {
                if (!PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile())) {
                    try {
                        this.doConnect();
                    }
                    catch (Exception e) {
                        throw new TraversalException(e.getMessage());
                    }
                }
                if (PerforceCommands.existInRepository(dstURL, this.getConnectionProfile())) {
                    throw new TraversalException(PerforceArb.format("IMPORT_DST_FOLDER_IN_REPOS", URLFileSystem.getPlatformPathName((URL)dstURL)));
                }
            }
            catch (PerforceProcessException e) {
                throw new TraversalException(e.getMessage());
            }
            dataContext.put("destination folder", (Object)dstURL);
            dataContext.put("selected_connection", (Object)this.getConnectionProfile());
        }
    }

    private boolean doConnect() throws Exception {
        PerforceLoginCommand login = new PerforceLoginCommand();
        login.setConnectionProfile(this.getConnectionProfile());
        login.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
        Context con = Context.newIdeContext();
        login.setContext(con);
        if (CommandProcessor.getInstance().invoke((Command)login) == 0) {
            PerforceSessionManager.getInstance().connect(this.getConnectionProfile());
            return true;
        }
        return false;
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this._dstFolder.setChooseFolders(true);
        ResourceUtils.resLabel((JLabel)this._lblConnectionName, (Component)this._cmbConnection, (String)PerforceArb.get("IMPORT_CONNECTION_NAME"));
        ResourceUtils.resLabel((JLabel)this._lblDestination, (Component)this._dstFolder, (String)PerforceArb.get("IMPORT_LOCATION_DESTINATION"));
        this.hintText.setText(PerforceArb.get("IMPORT_DESTINATION_HINT"));
        this.add((Component)this.hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 12, 2, new Insets(5, 5, 15, 5), 0, 0));
        this.add(this._lblConnectionName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this._cmbConnection, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblDestination, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.add((Component)this._dstFolder, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._cmbConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cmbCon = (JComboBox)e.getSource();
                PerforceConnectionProfile con = (PerforceConnectionProfile)cmbCon.getSelectedItem();
                if (!PerforceSessionManager.getInstance().isConnected(con)) {
                    try {
                        if (!ImportDestinationPanel.this.doConnect()) {
                            ImportDestinationPanel.this._dstFolder.setURL(null);
                            return;
                        }
                    }
                    catch (Exception f) {
                        return;
                    }
                }
                URL clientRoot = PerforceSessionManager.getInstance().getClientRootFolder(con);
                URL dUrl = URLFactory.newDirURL((URL)clientRoot, (String)ImportDestinationPanel.this._clientName);
                ImportDestinationPanel.this._dstFolder.setURL(dUrl);
            }
        });
    }

    private PerforceConnectionProfile getConnectionProfile() {
        return (PerforceConnectionProfile)this._cmbConnection.getSelectedItem();
    }
}

