/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceLoginUIPanel
extends JPanel {
    private JLabel lblUser = new JLabel();
    private JTextField fldUser = new JTextField();
    private JLabel lblServer = new JLabel();
    private JTextField fldServer = new JTextField();
    private JLabel lblPassword = new JLabel();
    private JPasswordField fldPassword = new JPasswordField();
    private JLabel _lblCon;
    private JComboBox _cmbCon;
    private GridBagLayout layout = new GridBagLayout();

    public PerforceLoginUIPanel() {
        this.jbInit();
    }

    public PerforceLoginUIPanel(List<PerforceConnectionProfile> connects) {
        try {
            this._lblCon = new JLabel();
            this._cmbCon = new JComboBox();
            this._cmbCon.setModel(new DefaultComboBoxModel<Object>(connects.toArray(new Object[0])));
            this._cmbCon.addItemListener(new ConnectionItemListener());
            this.setDetails((PerforceConnectionProfile)this._cmbCon.getModel().getSelectedItem());
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        if (this._cmbCon != null) {
            ResourceUtils.resLabel((JLabel)this._lblCon, (Component)this._cmbCon, (String)PerforceArb.get("CONNECT_LOGIN_NAME"));
        }
        this.setLayout(this.layout);
        ResourceUtils.resLabel((JLabel)this.lblUser, (Component)this.fldUser, (String)PerforceArb.get("LOGIN_PANEL_USERNAME"));
        ResourceUtils.resLabel((JLabel)this.lblServer, (Component)this.fldServer, (String)PerforceArb.get("LOGIN_PANEL_SERVER"));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.fldPassword, (String)PerforceArb.get("LOGIN_PANEL_PASSWORD"));
        Insets ins = new Insets(5, 5, 5, 5);
        int row = 0;
        if (this._cmbCon != null) {
            this.add((Component)this._lblCon, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)this._cmbCon, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        }
        this.add((Component)this.lblServer, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldServer, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblUser, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.fldUser, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblPassword, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldPassword, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.fldUser.setEditable(false);
        this.fldServer.setEditable(false);
    }

    public void setUsername(String user) {
        this.fldUser.setText(user);
    }

    public void setServer(String server) {
        this.fldServer.setText(server);
    }

    public void setPassword(char[] pass) {
        if (pass != null) {
            this.fldPassword.setText(new String(pass));
        }
    }

    public Component getInitialFocusCompontent() {
        return this.fldPassword;
    }

    public char[] getPassword() {
        return this.fldPassword.getPassword();
    }

    private void setDetails(PerforceConnectionProfile connect) {
        this.setUsername(connect.getUser());
        this.setServer(connect.getServer());
        this.setPassword(connect.getConnectionPassword());
    }

    public PerforceConnectionProfile getConnectionProfile() {
        if (this._cmbCon != null) {
            return (PerforceConnectionProfile)this._cmbCon.getModel().getSelectedItem();
        }
        return null;
    }

    private class ConnectionItemListener
    implements ItemListener {
        private ConnectionItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            PerforceConnectionProfile connect = (PerforceConnectionProfile)e.getItem();
            PerforceLoginUIPanel.this.setDetails(connect);
        }
    }
}

