/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.controls.ConnectionImportExportPanel;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.connection.PerforceConnectionHelper;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceDepotNavigatorManager;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceImportExportPanel
extends ConnectionImportExportPanel {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceImportExportPanel.class.getName());
    private ImportExportPerforceConnection _helper;

    protected void filenameChanged(String fileName) {
        this.getIEHelper().setFilename(fileName);
        Collection<PerforceConnectionProfile> connections = this.getIEHelper().getPersistedProfiles();
        if (!connections.isEmpty()) {
            this.setConnections(connections.toArray(new Object[connections.size()]));
        }
    }

    protected Object[] getExportableConnections() {
        try {
            Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
            if (!cons.isEmpty()) {
                ArrayList<PerforceConnectionProfile> connections = new ArrayList<PerforceConnectionProfile>();
                connections.addAll(cons);
                return connections.toArray(new Object[connections.size()]);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to load connections ");
        }
        return new Object[0];
    }

    protected boolean importConnections() {
        Object[] selected = this.getSelectedConnections();
        if (selected != null && selected.length > 0) {
            for (Object select : selected) {
                PerforceConnectionProfile connection = (PerforceConnectionProfile)select;
                try {
                    PerforceConnectionProfile overWrite = PerforceUtil.connectionUsed(connection);
                    if (PerforceUtil.connectionNameUsed(connection) || overWrite != null) {
                        if (!this.confirmOverwrite(overWrite)) continue;
                        PerforceConnectionManager.getInstance().removeConnection(overWrite);
                        PerforceDepotNavigatorManager.getInstance().removeConnection(overWrite);
                        this.createNodeForConnection(connection);
                        continue;
                    }
                    this.createNodeForConnection(connection);
                }
                catch (Exception e) {
                    sLogger.log(Level.WARNING, "Failed to import connections ", e);
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean exportConnections(String filename) {
        Object[] selectedConn = this.getSelectedConnections();
        if (selectedConn.length > 0) {
            this.getIEHelper().setFilename(filename);
            ArrayList<PerforceConnectionProfile> connections = new ArrayList<PerforceConnectionProfile>(selectedConn.length);
            for (Object selected : selectedConn) {
                connections.add((PerforceConnectionProfile)selected);
            }
            this.getIEHelper().setPersistedProfiles(connections);
        }
        return true;
    }

    private void createNodeForConnection(PerforceConnectionProfile connect) throws Exception {
        PerforceConnectionManager.getInstance().addConnection(connect);
        PerforceDepotNavigatorManager.getInstance().createConnection(connect);
        PerforceDepotNavigatorManager.getInstance().showRepositoryNavigator();
    }

    private boolean confirmOverwrite(PerforceConnectionProfile overwrite) {
        return MessageDialog.confirm((Component)((Object)this), (Object)PerforceArb.format("IMPORT_WZ_OVERWRITE", overwrite.toString()), (String)PerforceArb.get("IMPORT_WZ_OVERWRITE_TITLE"), null);
    }

    private ImportExportPerforceConnection getIEHelper() {
        if (this._helper == null) {
            this._helper = new ImportExportPerforceConnection();
        }
        return this._helper;
    }

    private class ImportExportPerforceConnection
    extends PerforceConnectionHelper {
        private URL _url;

        private ImportExportPerforceConnection() {
        }

        @Override
        protected URL getStoreURL() {
            return this._url;
        }

        private void setFilename(String filename) {
            this._url = URLFactory.newFileURL((String)filename);
        }
    }
}

