/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceClientPanel;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceFinish;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceLoginProcess;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class ConnectionPanel
extends JPanel
implements ActionListener {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(ConnectionPanel.class.getName());
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblUsername = new JLabel();
    private JLabel lblPassword = new JLabel();
    private JLabel lblServer = new JLabel();
    private JLabel lblClient = new JLabel();
    private JLabel lblName = new JLabel();
    private JTextField fldUsername = new JTextField();
    private JPasswordField fldPassword = new JPasswordField();
    private JTextField fldServer = new JTextField();
    private JTextField fldClient = new JTextField();
    private JButton btnClient = new JButton();
    private JTextField fldName = new JTextField();
    private JButton btnTest = new JButton();
    private JTextArea fldTest = new JTextArea();
    private JScrollPane scrollPane = new JScrollPane(this.fldTest);
    private boolean queryClients = true;
    private List _finishListener = new ArrayList();
    public boolean _error = false;

    public ConnectionPanel() {
        try {
            this.jbInit();
            this.initializeComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize() {
        this.enableTestButton();
        this.canFinish();
    }

    public void addFinishListener(PerforceFinish fin) {
        this._finishListener.add(fin);
    }

    public String getUsername() {
        return this.fldUsername.getText();
    }

    public void setUsername(String username) {
        this.fldUsername.setText(username);
    }

    public char[] getPassword() {
        return this.fldPassword.getPassword();
    }

    public void setPassword(String password) {
        this.fldPassword.setText(password);
    }

    public String getServer() {
        return this.fldServer.getText();
    }

    public void setServer(String server) {
        this.fldServer.setText(server);
    }

    public String getClient() {
        return this.fldClient.getText();
    }

    public void setClient(String client) {
        this.fldClient.setText(client);
    }

    public Component getDefaultComponent() {
        return this.fldUsername;
    }

    public void setRemPassword(boolean remPasswd) {
    }

    public boolean getRemPassword() {
        return false;
    }

    public void setConnectionName(String name) {
        this.fldName.setText(name);
    }

    public String getConnectionName() {
        return this.fldName.getText();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        Insets ins = new Insets(5, 5, 5, 5);
        ResourceUtils.resLabel((JLabel)this.lblUsername, (Component)this.fldUsername, (String)PerforceArb.get("CONNECT_USERNAME"));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.fldPassword, (String)PerforceArb.get("CONNECT_PASSWORD"));
        ResourceUtils.resLabel((JLabel)this.lblServer, (Component)this.fldServer, (String)PerforceArb.get("CONNECT_PORT"));
        ResourceUtils.resLabel((JLabel)this.lblClient, (Component)this.fldClient, (String)PerforceArb.get("CONNECT_CLIENT"));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)PerforceArb.get("CONNECT_NAME"));
        ResourceUtils.resButton((AbstractButton)this.btnTest, (String)PerforceArb.get("CONNECT_TEST"));
        ResourceUtils.resButton((AbstractButton)this.btnClient, (String)PerforceArb.get("CONNECT_BROWSE"));
        this.add((Component)this.lblUsername, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldUsername, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblPassword, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldPassword, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblServer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldServer, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.lblClient, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        JPanel tpanel = new JPanel();
        this.add((Component)tpanel, new GridBagConstraints(1, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        tpanel.setLayout(new GridBagLayout());
        tpanel.add((Component)this.fldClient, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        tpanel.add((Component)this.btnClient, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this.btnTest, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 6, 4, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
    }

    private void initializeComponents() {
        this.btnTest.addActionListener(this);
        this.fldTest.setEditable(false);
        this.btnClient.setEnabled(false);
        GeneralDocumentListener gDocument = new GeneralDocumentListener();
        this.fldServer.getDocument().addDocumentListener(gDocument);
        this.fldUsername.getDocument().addDocumentListener(gDocument);
        this.fldClient.getDocument().addDocumentListener(gDocument);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_pfcconnection_html");
        this.btnClient.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PerforceLoginProcess process = PerforceCommands.getTestConnectionLogin(ConnectionPanel.this.getUsername(), ConnectionPanel.this.getPassword(), ConnectionPanel.this.getServer());
                    if (!process.getErrorMessage().isEmpty()) {
                        MessageDialog.error((Component)ConnectionPanel.this, (Object)PerforceArb.get("LOGIN_FAILED_PASSWORD"), (String)PerforceArb.get("LOGIN_ERROR_TITLE"), null);
                        return;
                    }
                    PerforceClientPanel panel = new PerforceClientPanel(ConnectionPanel.this.getUsername(), ConnectionPanel.this.getServer());
                    HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_pfcconnbrowse_html");
                    final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)PerforceArb.get("CLIENT_LOGIN_TITLE"));
                    dialog.setOKButtonEnabled(false);
                    dialog.setMinimumSize(200, 260);
                    panel.addFinishListener(new PerforceFinish(){

                        @Override
                        public void canFinish(boolean finish) {
                            dialog.setOKButtonEnabled(finish);
                        }
                    });
                    if (VCSDialogRunner.runDialog((JDialog)dialog)) {
                        ConnectionPanel.this.fldClient.setText(panel.getClient());
                    }
                }
                catch (Exception f) {
                    f.printStackTrace();
                }
                finally {
                    try {
                        PerforceCommands.logout(ConnectionPanel.this.getServer(), ConnectionPanel.this.getUsername());
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fldTest.setText(PerforceArb.get("CONNECT_TESTING"));
        try {
            this.performTest();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void performTest() throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean testClient = true;
                    StringBuffer bug = new StringBuffer(ConnectionPanel.this.fldTest.getText());
                    PerforceLoginProcess process = PerforceCommands.getTestConnectionLogin(ConnectionPanel.this.getUsername(), ConnectionPanel.this.getPassword(), ConnectionPanel.this.getServer());
                    if (process.isError()) {
                        if (!process.getErrorMessage().isEmpty()) {
                            bug.append(PerforceUtil.parseErrorMessage(process.getErrorMessage(), ConnectionPanel.this.getServer()));
                        }
                        bug.append("\n");
                        bug.append(PerforceArb.get("CONNECT_FAILED"));
                        testClient = false;
                    }
                    process.destroyProcess();
                    if (testClient) {
                        if (PerforceUtil.isPerforceClientValid(ConnectionPanel.this.getUsername(), ConnectionPanel.this.getServer(), ConnectionPanel.this.getClient())) {
                            bug.append(PerforceArb.get("CONNECT_SUCCESS"));
                        } else {
                            this.messageInvalidClient(bug);
                        }
                    }
                    ConnectionPanel.this.fldTest.requestFocus();
                    ConnectionPanel.this.fldTest.setText(bug.toString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    try {
                        PerforceCommands.logout(ConnectionPanel.this.getServer(), ConnectionPanel.this.getUsername());
                    }
                    catch (Exception e) {
                        sLogger.warning("Failed to logout durring test connection " + e.getMessage());
                        Assert.printStackTrace((Throwable)e);
                    }
                }
            }

            private void messageInvalidClient(StringBuffer bug) {
                bug.append(PerforceArb.get("CONNECT_CLIENT_NOT_VALID"));
                bug.append("\n");
                bug.append(PerforceArb.get("CONNECT_FAILED"));
            }
        });
    }

    private void enableButton() {
        this.enableTestButton();
        this.canFinish();
    }

    private void canFinish() {
        boolean enable;
        Iterator it = this._finishListener.iterator();
        boolean bl = enable = !this.getClient().isEmpty();
        while (it.hasNext()) {
            PerforceFinish fin = (PerforceFinish)it.next();
            fin.canFinish(enable);
        }
    }

    private void enableTestButton() {
        if (this.getUsername().isEmpty() || this.getServer().isEmpty() || this.getClient().isEmpty()) {
            this.btnTest.setEnabled(false);
        } else {
            this.btnTest.setEnabled(true);
        }
    }

    class GeneralDocumentListener
    implements DocumentListener {
        GeneralDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableClientButton();
            ConnectionPanel.this.enableButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableClientButton();
            ConnectionPanel.this.enableButton();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableClientButton();
        }

        private void enableClientButton() {
            if (!ConnectionPanel.this.fldUsername.getText().isEmpty() && !ConnectionPanel.this.fldServer.getText().isEmpty()) {
                ConnectionPanel.this.btnClient.setEnabled(true);
            } else {
                ConnectionPanel.this.btnClient.setEnabled(false);
            }
        }
    }
}

