/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.requirement;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.ActionRequirement;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;

public class ChangelistOrFileStatusOpen
implements ActionRequirement {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(ChangelistOrFileStatusOpen.class.getName());

    public boolean isSatisfied(VCSProfile profile, Context context, Controller controller) {
        URL url;
        Node node = context.getNode();
        Element elm = context.getElement();
        URLFilter pfilter = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.PENDING_CHANGELIST");
        if (node != null) {
            url = node.getURL();
        } else if (elm != null && !(elm instanceof Locatable)) {
            url = ((Locatable)elm).getURL();
        } else {
            return false;
        }
        if (pfilter.accept(url)) {
            return true;
        }
        VCSStatusFilter filter = profile.getStatusFilter("oracle.jdeveloper.perforce2.filter.status.OPEN");
        try {
            VCSStatus stat = (VCSStatus)profile.getPolicyStatusCache().get(url);
            return filter.accept(stat);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Error " + e.getMessage());
            return false;
        }
    }
}

