/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.util.Iterator;
import javax.swing.SwingUtilities;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRootNode;

public class PerforceDepotNavigatorManager {
    private static final PerforceDepotNavigatorManager sInstance = new PerforceDepotNavigatorManager();
    private PerforceRootNode _rootNode = null;

    private PerforceDepotNavigatorManager() {
    }

    public static PerforceDepotNavigatorManager getInstance() {
        return sInstance;
    }

    public void showRepositoryNavigator() {
        Runnable runme = new Runnable(){

            @Override
            public void run() {
                IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
                try {
                    if (showNavigatorAction != null) {
                        showNavigatorAction.performAction();
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runme.run();
        } else {
            SwingUtilities.invokeLater(runme);
        }
    }

    PerforceRootNode getRootNode() {
        if (this._rootNode == null) {
            this._rootNode = new PerforceRootNode();
        }
        return this._rootNode;
    }

    public void removeConnection(PerforceConnectionNode node) {
        this._rootNode.remove((Element)node, true);
        PerforceSessionManager.getInstance().removeConnectionListeners(node);
        if (this._rootNode.isDirty()) {
            this._rootNode.markDirty(false);
        }
    }

    public void removeConnection(PerforceConnectionProfile connect) {
        if (this._rootNode.isOpen()) {
            Iterator it = this._rootNode.getChildren();
            while (it.hasNext()) {
                PerforceConnectionNode node = (PerforceConnectionNode)it.next();
                if (!node.getConnectionProfile().equals(connect)) continue;
                this.removeConnection(node);
            }
        }
    }

    public void createConnection(PerforceConnectionProfile connect) {
        PerforceConnectionNode node = new PerforceConnectionNode(connect);
        PerforceSessionManager.getInstance().addConnectionListeners(node);
        this._rootNode.add((Element)node, true);
        if (this._rootNode.isDirty()) {
            this._rootNode.markDirty(false);
        }
    }
}

