/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.merge;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.merge.BaseTextMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.merge.ConflictFile;
import oracle.jdevimpl.vcs.perforce2.merge.MergeConflictMonitor;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;

public class PerforceMergeEditor
extends BaseTextMergeEditor {
    private URL ancestor;
    private URL second;

    protected void initializeMergeContextCS(Context context) throws Exception {
        URL url = this.getRealURL();
        URL parent = URLFileSystem.getParent((URL)url);
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        String type = this.getSuffixAsType(url);
        List conflicts = this.getConflictFiles(connect, url);
        if (conflicts.size() == 0) {
            MergeContext.setClientSideMerge((Context)context, (boolean)false);
            return;
        }
        URLContributor contributor = new URLContributor(url);
        contributor.setType(type);
        MergeContext.setFirstContributor((Context)context, (CompareContributor)contributor);
        this.ancestor = this.getFilefromServer(connect, parent, ((ConflictFile)conflicts.get(0)).getBaseFile());
        this.second = this.getFilefromServer(connect, parent, ((ConflictFile)conflicts.get(0)).getTheirFile());
        contributor = new URLContributor(this.second);
        contributor.setType(type);
        MergeContext.setSecondContributor((Context)context, (CompareContributor)contributor);
        contributor = new URLContributor(this.ancestor);
        contributor.setType(type);
        MergeContext.setAncestorContributor((Context)context, (CompareContributor)contributor);
        MergeContext.setMergeEngine((Context)context, (MergeEngine)MergeEngine.getInstance());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("need a hint");
    }

    protected void resolveMergeStatus(URL url) {
        try {
            PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
            this.acceptConflicts(connect, url);
            URLFileSystem.delete((URL)this.second);
            URLFileSystem.delete((URL)this.ancestor);
            VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce").getPolicyStatusCache().clear(url);
        }
        catch (IOException ioe) {
            FeedbackManager.reportException((Throwable)ioe);
        }
    }

    protected boolean getClientSideMergeSetting() {
        return true;
    }

    private void acceptConflicts(PerforceConnectionProfile connect, URL file) throws IOException {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        runner.setConnection(connect);
        cmds.add("resolve");
        cmds.add("-ay");
        cmds.add(URLFileSystem.getPlatformPathName((URL)file));
        runner.setCmdList(cmds);
        try {
            runner.exec();
        }
        catch (Exception e) {
            throw new IOException(PerforceArb.format("ERROR_RESOLVE_SAVE", URLFileSystem.getPlatformPathName((URL)file)));
        }
    }

    private List getConflictFiles(PerforceConnectionProfile connect, URL url) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("-s");
        cmd.add("resolve");
        cmd.add("-as");
        cmd.add("-o");
        cmd.add(URLFileSystem.getPlatformPathName((URL)url));
        runner.setConnection(connect);
        runner.setCmdList(cmd);
        MergeConflictMonitor mergemonitor = new MergeConflictMonitor();
        runner.addOutputMonitor(mergemonitor);
        this.doInvocationImpl(runner);
        List conflicts = mergemonitor.getConflicts();
        return conflicts;
    }

    private URL getFilefromServer(PerforceConnectionProfile connect, URL parent, String file) throws Exception {
        PerforceShellRunner runner = new PerforceShellRunner();
        URL url = PerforceCommands.createUniqueURL(parent, file);
        String tempFile = URLFileSystem.getPlatformPathName((URL)url);
        ArrayList<String> cmds = new ArrayList<String>();
        runner.setConnection(connect);
        runner.setOptionDirURL(parent);
        cmds.add("print");
        cmds.add("-o");
        cmds.add(tempFile);
        cmds.add(file);
        runner.setCmdList(cmds);
        this.doInvocationImpl(runner);
        return url;
    }

    private void doInvocationImpl(PerforceShellRunner runner) throws Exception {
        try {
            runner.exec();
        }
        catch (IOException ioe) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_RESOLVE_TITLE"), PerforceArb.get("ERROR_COMMAND_RESOLVE_FAILED"), ioe.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_RESOLVE_TITLE"), PerforceArb.get("ERROR_RESOLVE_FAILED"), runner.getErrorText());
        }
    }
}

