/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceContent {
    public byte[] getVersionContent(URL url, String version) throws VCSException {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        String path = URLFileSystem.getPlatformPathName((URL)url);
        PerforceFstatResult stat = PerforceGetStatus.fstat(connect, path);
        String versionPath = stat.getDepotFile() + "#" + version;
        return this.getVersionContent(connect, versionPath);
    }

    public byte[] getVersionContent(URL url) throws VCSException {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(url);
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setBufferOutputBinary(true);
        ArrayList<String> cmd = new ArrayList<String>(2);
        ArrayList<String> file = new ArrayList<String>(1);
        file.add(URLFileSystem.getPlatformPathName((URL)url));
        cmd.add("print");
        cmd.add("-q");
        runner.setCmdList(cmd);
        runner.setFiles(file);
        runner.setConnection(connect);
        runner.setQuiet(true);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                throw new VCSException(PerforceArb.get("VERSION_TITLE"), runner.getErrorText());
            }
        }
        catch (Exception ex) {
            throw new VCSException(PerforceArb.get("VERSION_TITLE"), ex.getMessage());
        }
        return runner.getOutputBytes();
    }

    public byte[] getVersionContent(PerforceConnectionProfile connect, String path) throws VCSException {
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setBufferOutputBinary(true);
        ArrayList<String> cmd = new ArrayList<String>(2);
        ArrayList<String> file = new ArrayList<String>(1);
        file.add(path);
        cmd.add("print");
        cmd.add("-q");
        runner.setCmdList(cmd);
        runner.setFiles(file);
        runner.setConnection(connect);
        runner.setQuiet(true);
        try {
            runner.exec();
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                throw new VCSException(PerforceArb.get("VERSION_TITLE"), runner.getErrorText());
            }
        }
        catch (Exception ex) {
            throw new VCSException(PerforceArb.get("VERSION_TITLE"), ex.getMessage());
        }
        return runner.getOutputBytes();
    }
}

