/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd.custom;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSettingsKey;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PreviewListener;
import oracle.jdevimpl.vcs.perforce2.error.PerforceValidationException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PerforceSyncCustomizer
implements VCSOptionsCustomizer,
PerforceSettingsKey {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceSyncCustomizer.class.getName());
    private static String NEWLINE = new String("\n");
    private static String SYNCHEAD = "Head";
    private static String SYNCREVSION = "Revision";
    private static String SYNCCHANGELIST = "ChangeList";
    private static String SYNCLABEL = "LabelName";
    private static String SYNCDATE = "Date";
    private SyncOptionsPanel _panel;
    private boolean _preview;

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new SyncOptionsPanel();
        }
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        return null;
    }

    public void addPreviewListener(PreviewListener pl) {
        ((SyncOptionsPanel)this.getComponent()).addPreviewListener(pl);
    }

    public void setOptions(Map options) {
        this.getComponent();
        Boolean b = (Boolean)options.get("setting_sync_force");
        if (b != null) {
            this._panel.getForceCheckbox().setSelected(b);
        }
    }

    public Map getOptions() {
        this.getComponent();
        HashMap<String, Object> m = new HashMap<String, Object>();
        SyncOptionsPanel panel = (SyncOptionsPanel)this.getComponent();
        String name = ((SyncData)panel.getSyncCombo().getModel().getSelectedItem()).getAction();
        String target = panel.getTargetText().getText().trim();
        if (name.equals(SYNCHEAD)) {
            m.put("setting_sync_revision", "");
        } else if (name.equals(SYNCREVSION)) {
            m.put("setting_sync_revision", "#" + target);
        } else if (name.equals(SYNCCHANGELIST)) {
            m.put("setting_sync_revision", "@" + target);
        } else if (name.equals(SYNCLABEL)) {
            m.put("setting_sync_revision", "@" + target);
        } else if (name.equals(SYNCDATE)) {
            m.put("setting_sync_revision", "@" + target);
        }
        m.put("setting_sync_force", panel.getForceCheckbox().isSelected());
        m.put("setting_sync_preview", this._preview);
        return m;
    }

    public void validateOptions() throws VCSException {
        SyncOptionsPanel panel = (SyncOptionsPanel)this.getComponent();
        String name = ((SyncData)panel.getSyncCombo().getModel().getSelectedItem()).getAction();
        String target = panel.getTargetText().getText().trim();
        if (name.equals(SYNCREVSION)) {
            if (target.length() == 0) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_NO_REVISION"));
            }
            try {
                Integer.parseInt(target);
            }
            catch (NumberFormatException nfe) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_REVISION_NO"));
            }
        }
        if (name.equals(SYNCCHANGELIST)) {
            if (target.length() == 0) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_NO_CHANGELIST"));
            }
            try {
                Integer.parseInt(target);
            }
            catch (NumberFormatException nfe) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_CHANGE_LIST_NOT_NUMBER"));
            }
        }
        if (name.equals(SYNCLABEL) && target.length() == 0) {
            throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_NO_LABELNAME"));
        }
        if (name.equals(SYNCDATE)) {
            if (target.length() == 0) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_NO_DATE"));
            }
            DateFormat format = DateFormat.getDateInstance();
            try {
                if (format instanceof SimpleDateFormat) {
                    ((SimpleDateFormat)format).applyPattern("yyyy/mm/dd");
                    format.parse(target);
                }
            }
            catch (ParseException pe) {
                throw new PerforceValidationException(PerforceArb.get("PERFORCE_SYNC_ERROR_TITLE"), PerforceArb.get("PERFORCE_SYNC_DATE_FORMAT"));
            }
        }
    }

    public boolean isPreview() {
        return this._panel._previewOnly.isSelected();
    }

    public void addPreviewText(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PerforceSyncCustomizer.this._panel._previewText.append(line);
                PerforceSyncCustomizer.this._panel._previewText.append(NEWLINE);
            }
        });
    }

    private static class SyncData {
        public String _text;
        public String _action;

        public SyncData(String iRes, String action) {
            this._text = PerforceArb.get(iRes);
            this._action = action;
        }

        public String toString() {
            return this._text;
        }

        public String getAction() {
            return this._action;
        }
    }

    private class SyncOptionsPanel
    extends JPanel
    implements ListDataListener {
        private JLabel _lblSync = new JLabel();
        private JComboBox _cmbSync = new JComboBox();
        private JLabel _lblTarget = new JLabel();
        private JTextField _fldTarget = new JTextField();
        private JCheckBox _forceSync = new JCheckBox();
        private JButton _previewOnly = new JButton();
        private JTextArea _previewText = new JTextArea();
        private JScrollPane _logPane = new JScrollPane(this._previewText);
        private PreviewListener _alPreview;
        private Insets commonIs = new Insets(5, 5, 5, 5);

        private SyncOptionsPanel() {
            ResourceUtils.resLabel((JLabel)this._lblSync, (Component)this._cmbSync, (String)PerforceArb.get("PERFORCESYNC_LABEL"));
            ResourceUtils.resLabel((JLabel)this._lblTarget, (Component)this._fldTarget, (String)PerforceArb.get("PERFORCESYNC_TARGET"));
            ResourceUtils.resButton((AbstractButton)this._forceSync, (String)PerforceArb.get("PERFORCESYNCCUSTOMIZER_FORCE"));
            ResourceUtils.resButton((AbstractButton)this._previewOnly, (String)PerforceArb.get("PERFORCESYNCCUSTOMIZER_PREVIEW"));
            this._fldTarget.setEnabled(false);
            this._lblTarget.setEnabled(false);
            this._previewText.setEditable(false);
            this._previewText.setBackground(this.getBackground());
            this._cmbSync.setModel(this.getComboBoxModel());
            this.initLayout();
            this._cmbSync.getModel().addListDataListener(this);
            this._previewOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PerforceSyncCustomizer.this._preview = true;
                    SyncOptionsPanel.this._previewText.setText("");
                    SyncOptionsPanel.this._previewOnly.setEnabled(false);
                    SwingWorker worker = new SwingWorker(){

                        protected Object doInBackground() {
                            try {
                                SyncOptionsPanel.this._alPreview.actionPerformed();
                            }
                            catch (Exception f) {
                                sLogger.log(Level.WARNING, "Error " + f.getMessage());
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            PerforceSyncCustomizer.this._preview = false;
                            SyncOptionsPanel.this._previewOnly.setEnabled(true);
                        }
                    };
                    worker.execute();
                }
            });
        }

        public void addPreviewListener(PreviewListener al) {
            this._alPreview = al;
        }

        public JTextField getTargetText() {
            return this._fldTarget;
        }

        public JCheckBox getForceCheckbox() {
            return this._forceSync;
        }

        public JButton getPreviewButton() {
            return this._previewOnly;
        }

        public JComboBox getSyncCombo() {
            return this._cmbSync;
        }

        public JLabel getTargetLabel() {
            return this._lblTarget;
        }

        private void initLayout() {
            this._previewText.setRows(5);
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.add((Component)this._lblSync, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.commonIs, 0, 0));
            this.add((Component)this._cmbSync, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 17, 0, this.commonIs, 0, 0));
            this.add((Component)this._lblTarget, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 17, 0, this.commonIs, 0, 0));
            this.add((Component)this._fldTarget, new GridBagConstraints(3, row++, 1, 1, 1.0, 0.0, 17, 2, this.commonIs, 0, 0));
            this.add((Component)this._forceSync, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, this.commonIs, 0, 0));
            this.add((Component)this._previewOnly, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 17, 2, this.commonIs, 0, 0));
            this.add((Component)this._logPane, new GridBagConstraints(0, row++, 4, 2, 1.0, 2.0, 17, 1, this.commonIs, 0, 0));
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            String action = ((SyncData)this._cmbSync.getModel().getSelectedItem()).getAction();
            if (action.equals(SYNCHEAD)) {
                PerforceSyncCustomizer.this._panel.getTargetText().setEnabled(false);
                PerforceSyncCustomizer.this._panel.getTargetLabel().setEnabled(false);
                PerforceSyncCustomizer.this._panel.getForceCheckbox().setEnabled(true);
            } else {
                PerforceSyncCustomizer.this._panel.getTargetText().setEnabled(true);
                PerforceSyncCustomizer.this._panel.getTargetLabel().setEnabled(true);
                PerforceSyncCustomizer.this._panel.getForceCheckbox().setEnabled(false);
            }
        }

        private ComboBoxModel getComboBoxModel() {
            DefaultComboBoxModel<SyncData> model = new DefaultComboBoxModel<SyncData>();
            model.addElement(new SyncData("PERFORCESYNCCUSTOMIZER_HEAD", SYNCHEAD));
            model.addElement(new SyncData("PERFORCESYNCCUSTOMIZER_REVISION", SYNCREVSION));
            model.addElement(new SyncData("PERFORCESYNCCUSTOMIZER_CHANGELIST", SYNCCHANGELIST));
            model.addElement(new SyncData("PERFORCESYNCCUSTOMIZER_LABELNAME", SYNCLABEL));
            model.addElement(new SyncData("PERFORCESYNCCUSTOMIZER_DATE", SYNCDATE));
            return model;
        }

        private void addItemListener(JRadioButton button, final JTextField field) {
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    field.setEnabled(event.getStateChange() == 1);
                }
            });
        }

        private void addRadioButton(JRadioButton button, Component field, Container parent, String action, int row) {
            button.setActionCommand(action);
            if (field != null) {
                parent.add((Component)button, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, this.commonIs, 0, 0));
                parent.add(field, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 17, 2, this.commonIs, 0, 0));
            } else {
                parent.add((Component)button, new GridBagConstraints(0, row, 0, 1, 0.0, 0.0, 17, 2, this.commonIs, 0, 0));
            }
        }
    }
}

