/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd.custom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JLabel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSettingsKey;
import oracle.jdevimpl.vcs.perforce2.cl.cmd.MoveChangelistCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.CommonChangeListPanel;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceAddCustomizer
implements VCSOptionsCustomizer,
PerforceSettingsKey {
    private AddOptionsPanel _panel;
    protected PerforceConnectionProfile _connect;
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(MoveChangelistCommand.class.getName());

    public PerforceAddCustomizer(PerforceConnectionProfile connect) {
        this._connect = connect;
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new AddOptionsPanel();
        }
        return this._panel;
    }

    public Component getInitialFocusComponent() {
        return null;
    }

    public void setOptions(Map options) {
        this.getComponent();
    }

    public Map getOptions() {
        this.getComponent();
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            String changelist = this._panel.getChangeListNo();
            if (changelist.equals(PerforceUtil.getDefaultChangelist(this._connect))) {
                m.put("open_on_changelist", changelist);
            } else {
                m.put("open_on_changelist", PerforceUtil.getChangelistNo(this._connect, changelist));
            }
        }
        catch (Exception e) {
            sLogger.warning(e.getMessage());
        }
        return m;
    }

    public void validateOptions() {
    }

    private class AddOptionsPanel
    extends CommonChangeListPanel {
        private AddOptionsPanel() {
            this.jbInit();
        }

        private void jbInit() {
            Insets ins = new Insets(5, 5, 5, 5);
            this.setLayout(new GridBagLayout());
            ResourceUtils.resLabel((JLabel)this.lblChangelist, (Component)this.cmbChangelist, (String)PerforceArb.get("ADD_CUSTOMIZER_CHANGELIST_LABEL"));
            this.add((Component)this.lblChangelist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, ins, 0, 0));
            this.add((Component)this.cmbChangelist, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        }

        @Override
        protected PerforceConnectionProfile getConnectionProfile() {
            return PerforceAddCustomizer.this._connect;
        }
    }
}

