/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

abstract class CommonChangeListPanel
extends JPanel {
    protected JLabel lblChangelist = new JLabel();
    protected JComboBox cmbChangelist = new JComboBox();

    public CommonChangeListPanel() {
        try {
            this.jbInit();
            this.changeListPopulate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract PerforceConnectionProfile getConnectionProfile();

    String getChangeListNo() throws Exception {
        String changelist = (String)this.cmbChangelist.getModel().getSelectedItem();
        return PerforceUtil.getChangelistNo(this.getConnectionProfile(), changelist);
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
    }

    private void changeListPopulate() throws Exception {
        ArrayList changeListno = new ArrayList(PerforceUtil.getFromServerChangelistNo(this.getConnectionProfile()));
        ArrayList<String> sortedChangelists = new ArrayList<String>();
        sortedChangelists.add(PerforceUtil.getDefaultChangelist(this.getConnectionProfile()));
        Collections.sort(changeListno);
        for (String changelistNo : changeListno) {
            String changelist = PerforceUtil.getLongLabel(this.getConnectionProfile(), changelistNo);
            sortedChangelists.add(changelist);
        }
        ChangeListComboModel model = new ChangeListComboModel(sortedChangelists);
        model.setSelectedItem(PerforceUtil.getDefaultChangelist(this.getConnectionProfile()));
        this.cmbChangelist.setModel(model);
    }

    private class ChangeListComboModel
    implements ComboBoxModel {
        private List changelist;
        private Object selectItem = null;

        ChangeListComboModel(List data) {
            this.changelist = data;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectItem = anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectItem;
        }

        @Override
        public int getSize() {
            return this.changelist.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.changelist.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }
}

