/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ProductInformation;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceUnlockCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.unlock";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceUnlockCommand.class.getName());

    public PerforceUnlockCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(final PerforceConnectionProfile connect, VCSProfile profile, CommandState commandState, Map options) {
        final PerforceShellRunner runner = new PerforceShellRunner();
        runner.setCommand("unlock");
        runner.setConnection(connect);
        runner.setQuiet(false);
        return new PerforceDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = PerforceUtil.getURLFileNamesAndConvertToAscii(invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                for (int i = 0; i < filenames.length; ++i) {
                    if (!URLFileSystem.isDirectory((URL)invokeUrls[i])) continue;
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                runner.setFiles(filenames2);
                runner.exec();
                if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                    sLogger.log(Level.WARNING, "Failed to unlock " + runner.getErrorText());
                    PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_SYNC_FAILED_TITLE"));
                    throw new PerforceProcessException(PerforceArb.get("ERROR_UNLOCK_FAILED_TITLE"), PerforceArb.format("ERROR_UNLOCK_FAILED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
                }
                return true;
            }
        };
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("UNLOCK_PROGRESS_TITLE"), (Object)PerforceArb.get("UNLOCK_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }
}

