/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.ProductInformation;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFileAndDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceComponents;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceSyncCustomizer;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PreviewListener;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceSyncCommand
extends PerforceAbstractCommand {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceSyncCommand.class.getName());
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.sync";
    private PerforceSyncCustomizer _customizer;

    public PerforceSyncCommand() {
        super(COMMAND_ID);
    }

    public PerforceSyncCommand(String commandId) {
        super(commandId);
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)PerforceComponents.createOpenEditFileListerComponent(nodes), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
    }

    protected boolean invokeCommand(final VCSProfile profile, final CommandState commandState) throws Exception {
        PerforceSyncCustomizer customizer = this.createOptionsCustomizer();
        final JEWTDialog dialog = this.createOperationDialog(Arrays.asList(commandState.getLocatables()), customizer);
        dialog.setMinimumSize(500, 400);
        customizer.addPreviewListener(new PreviewRunner(customizer){

            @Override
            protected boolean doOperation(Map options) throws Exception {
                return PerforceSyncCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }
        });
        dialog.addVetoableChangeListener(this.getDialogCommitter(profile, dialog, commandState, customizer));
        return VCSDialogRunner.runDialog((JDialog)dialog);
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(commandState.getLocatables()[0].getURL());
        if (connect == null && commandState.getLocatables()[0] instanceof RemoteItem) {
            connect = ((RemoteItem)commandState.getLocatables()[0]).getConnectionProfile();
        }
        VCSDirectoryInvokable invokable = this.createDirectoryInvokable(connect, profile, commandState, options);
        if (Boolean.valueOf(options.get("setting_sync_preview").equals(Boolean.FALSE)).booleanValue()) {
            invokable.setProgressMonitor(this.createProgressMonitor(parentUi));
        }
        return invokable.runInvokable();
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(PerforceConnectionProfile connect, VCSProfile profile, CommandState commandState, Map options) {
        PerforceShellRunner runner = new PerforceShellRunner();
        Boolean bForce = (Boolean)options.get("setting_sync_force");
        Boolean bPreview = (Boolean)options.get("setting_sync_preview");
        String spec = (String)options.get("setting_sync_revision");
        ArrayList<String> command = new ArrayList<String>();
        PreviewMonitor preview = new PreviewMonitor();
        runner.setConnection(connect);
        command.add("sync");
        if (bForce.booleanValue()) {
            command.add("-f");
        }
        if (bPreview.booleanValue()) {
            command.add("-n");
            runner.setQuiet(true);
            runner.addOutputMonitor(preview);
            runner.addErrorMonitor(preview);
        }
        runner.setCmdList(command);
        return this.syncItems(connect, profile, commandState, runner, spec, bPreview);
    }

    protected VCSDirectoryInvokable syncItems(final PerforceConnectionProfile connect, final VCSProfile profile, CommandState commandState, final PerforceShellRunner runner, final String spec, Boolean bPreview) {
        return new PerforceFileAndDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = PerforceUtil.getURLFileNamesAndConvertToAscii(invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                ArrayList<URL> dirUrls = new ArrayList<URL>();
                for (int i = 0; i < filenames.length; ++i) {
                    if (profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.OPEN_EDIT").accept(invokeUrls[i])) {
                        filenames2.remove(filenames[i]);
                        continue;
                    }
                    if (!URLFileSystem.isDirectoryPath((URL)invokeUrls[i])) continue;
                    dirUrls.add(invokeUrls[i]);
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0 && dirUrls.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                PerforceSyncCommand.this.syncDirectories(connect, runner, dirUrls, spec);
                if (PerforceSyncCommand.this.isRemote(parent) && filenames2.size() > 0) {
                    URL urlLocal = this.localPath(invokeUrls[0]);
                    if (urlLocal != null) {
                        runner.setOptionDirURL(URLFileSystem.getParent((URL)urlLocal));
                    } else {
                        return false;
                    }
                }
                PerforceSyncCommand.this.syncFiles(connect, runner, filenames2, spec);
                return true;
            }

            private URL localPath(URL url) {
                try {
                    PerforceFstatResult stat = PerforceGetStatus.fstat(connect, URLFileSystem.getPlatformPathName((URL)url));
                    if (stat.getClientFile() != null) {
                        return URLFactory.newFileURL((String)stat.getClientFile());
                    }
                }
                catch (VCSException vCSException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("SYNC_PROGRESS_TITLE"), (Object)PerforceArb.get("SYNC_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }

    protected PerforceSyncCustomizer createOptionsCustomizer() {
        if (this._customizer == null) {
            this._customizer = new PerforceSyncCustomizer();
        }
        return this._customizer;
    }

    private boolean isRemote(URL url) {
        return url.getProtocol().equalsIgnoreCase(PerforceNavURLFileSystemHelper.PERFORCE_NAV_PROTOCOL);
    }

    private void syncFiles(PerforceConnectionProfile connect, PerforceShellRunner runner, List filenames2, String spec) throws Exception {
        if (spec != null) {
            ArrayList<String> fileandSpec = new ArrayList<String>(filenames2.size());
            Iterator it = filenames2.iterator();
            while (it.hasNext()) {
                fileandSpec.add(it.next() + spec);
            }
            filenames2 = fileandSpec;
        }
        if (filenames2.size() > 0) {
            runner.setFiles(filenames2);
            this.doInvocationImpl(runner, connect);
            sLogger.log(Level.INFO, " Sync Files ");
        }
    }

    private void syncDirectories(PerforceConnectionProfile connect, PerforceShellRunner runner, Collection<URL> dirUrls, String spec) throws Exception {
        if (dirUrls.isEmpty()) {
            return;
        }
        ArrayList<String> dNames = new ArrayList<String>(dirUrls.size());
        for (URL dURL : dirUrls) {
            StringBuilder name = new StringBuilder(PerforceUtil.convertToAscii(URLFileSystem.getPlatformPathName((URL)dURL)));
            name.append("...");
            if (spec != null) {
                name.append(spec);
            }
            dNames.add(name.toString());
        }
        runner.setFiles(dNames);
        this.doInvocationImpl(runner, connect);
        sLogger.log(Level.INFO, " Sync Directories ");
        runner.writeMessage(PerforceArb.get("PROJECT_SYNC_COMPLETE"));
    }

    private void doInvocationImpl(PerforceShellRunner runner, PerforceConnectionProfile connect) throws Exception {
        runner.exec();
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_SYNC_FAILED_TITLE"));
            throw new PerforceProcessException(PerforceArb.get("ERROR_SYNC_FAILED_TITLE"), PerforceArb.format("ERROR_SYNC_FAILED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
        }
        String errText = runner.getErrorText();
        if (errText != null && !errText.isEmpty()) {
            throw new PerforceProcessException(PerforceArb.get("ERROR_SYNC_FAILED_TITLE"), PerforceArb.format("ERROR_SYNC_FAILED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
        }
    }

    protected VetoableChangeListener getDialogCommitter(final VCSProfile profile, final JEWTDialog dialog, final CommandState commandState, PerforceSyncCustomizer customizer) {
        return new VCSDialogCommitter(customizer){

            protected boolean doCommitOperation(Map options) throws Exception {
                Collection openEditUrls = this.getOpenEditUrls(profile, commandState.getLocatables());
                if (!openEditUrls.isEmpty()) {
                    MessageDialog.information((Component)dialog, (Object)PerforceArb.get("PERFORCE_OPEN_SYNC_FILES"), (String)PerforceArb.get("PERFORCE_SYNC_OPEN_FILES_TITLE"), null);
                }
                return PerforceSyncCommand.this.invokeCommandImpl(profile, commandState, (Component)dialog, options);
            }

            private Collection getOpenEditUrls(VCSProfile profile2, Locatable[] locatables) {
                ArrayList<Locatable> openUrls = new ArrayList<Locatable>();
                for (Locatable locatable : locatables) {
                    if (!profile2.getURLFilter("oracle.jdeveloper.perforce.filters.url.OPEN_EDIT").accept(locatable.getURL())) continue;
                    openUrls.add(locatable);
                }
                return openUrls;
            }
        };
    }

    abstract class PreviewRunner
    implements PreviewListener {
        PerforceSyncCustomizer _customizer;

        PreviewRunner(PerforceSyncCustomizer customizer) {
            this._customizer = customizer;
        }

        @Override
        public void actionPerformed() throws Exception {
            this.doOperation(this._customizer.getOptions());
        }

        protected abstract boolean doOperation(Map var1) throws Exception;
    }

    private final class PreviewMonitor
    extends VCSStreamMonitor {
        private PreviewMonitor() {
        }

        protected final void streamLine(String line, RunProcess process) {
            PerforceSyncCommand.this.createOptionsCustomizer().addPreviewText(line);
        }
    }
}

