/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.ProductInformation;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceEditCustomizer;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceEditCommand
extends PerforceAbstractCommand {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceEditCommand.class.getName());
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.edit";
    private String _changelistNo;

    public PerforceEditCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected String getPerforceChangelist() {
        return this._changelistNo;
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(final PerforceConnectionProfile connect, final VCSProfile profile, CommandState commandState, Map options) {
        final PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        final Boolean bLock = (Boolean)options.get("setting_lock");
        final Boolean bSync = (Boolean)options.get("setting_sync");
        this._changelistNo = (String)options.get("open_on_changelist");
        cmds.add("edit");
        try {
            if (!this._changelistNo.equals(PerforceUtil.getDefaultChangelist(connect))) {
                cmds.add("-c");
                cmds.add(this._changelistNo);
            }
        }
        catch (Exception e) {
            sLogger.warning(e.getMessage());
        }
        runner.setCmdList(cmds);
        runner.setQuiet(false);
        runner.setConnection(connect);
        return new PerforceDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = PerforceUtil.getURLFileNamesAndConvertToAscii(invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                for (int i = 0; i < filenames.length; ++i) {
                    if (!URLFileSystem.isDirectory((URL)invokeUrls[i])) continue;
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                runner.setFiles(filenames2);
                if (bSync.booleanValue()) {
                    PerforceEditCommand.this.syncFileToHead(connect, parent, filenames2, profile);
                }
                runner.exec();
                if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                    sLogger.log(Level.WARNING, "Failed to open " + runner.getErrorText());
                    PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_EDIT_FAILED_TITLE"));
                    throw new PerforceProcessException(PerforceArb.get("ERROR_EDIT_FAILED_TITLE"), PerforceArb.format("ERROR_EDIT_FAILED", ProductInformation.getProductInformation().getShortName()), runner.getErrorText());
                }
                if (bLock.booleanValue()) {
                    PerforceEditCommand.this.lock(connect, parent, filenames2);
                }
                return true;
            }
        };
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("EDIT_PROGRESS_TITLE"), (Object)PerforceArb.get("EDIT_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        PerforceEditCustomizer customizer = new PerforceEditCustomizer(this.getConnectionProfileFromContext());
        return customizer;
    }
}

