/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.util.VCSDialogRunner;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceChangeListName;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cl.ConnectionDetail;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.res.Bundle;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.ChangeListPanel;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceCreateChangeListCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.changelist";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceCreateChangeListCommand.class.getName());
    private VCSRecentCommentsModel _recentCommentsModel;

    public PerforceCreateChangeListCommand() {
        super(COMMAND_ID);
    }

    public int doit() throws Exception {
        try {
            return this.createChangeList();
        }
        catch (Exception ex) {
            PerforceProfile.getErrorHandler().handleException(ex);
            return 1;
        }
    }

    @Override
    protected String getPerforceChangelist() {
        return PerforceChangeListName.getDefaultChangelist();
    }

    private int createChangeList() throws Exception {
        Collection<PerforceConnectionProfile> cons = PerforceSessionManager.getInstance().getConnectedProfiles();
        final ArrayList newChangelistNo = new ArrayList(1);
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.perforce");
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(this.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Bundle.get("PERFORCE_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        final ChangeListPanel panel = new ChangeListPanel(cons, customizer);
        PerforceConnectionProfile connect = this.getConnectionProfile(this.getContext());
        if (connect != null) {
            panel.setConnectionProfile(connect);
        }
        panel.setFileHeader(PerforceArb.get("SELECT_FILES_CHANGELIST"));
        final JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)this.getDialogTitle());
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(PerforceArb.get("CHANGELIST_HEADER"));
        panel.setPreferredSize(new Dimension(400, 250));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, this.getHelpTopicId());
        dialog.setOKButtonEnabled(true);
        dialog.setDialogHeader((Component)header);
        dialog.setMinimumSize(500, 450);
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    if (panel.getDescription().length() == 0) {
                        MessageDialog.information((Component)dialog, (Object)PerforceArb.get("ERROR_NO_CL_DESCRIPTION"), (String)PerforceArb.get("CL_ERROR_TITLE"), null);
                        throw new PropertyVetoException(PerforceArb.get("ERROR_NO_CL_DESCRIPTION"), evt);
                    }
                    try {
                        newChangelistNo.add(PerforceCommands.createChangeList(panel.getSelectedConnection(), panel.getDescription(), panel.getCLFilesAndActions()));
                    }
                    catch (Exception ex) {
                        MessageDialog.error((Component)dialog, (Object)ex.getMessage(), (String)PerforceArb.get("CL_ERROR_TITLE"), null);
                        throw new PropertyVetoException(ex.getMessage(), evt);
                    }
                }
            }
        });
        if (VCSDialogRunner.runDialog((JDialog)dialog)) {
            VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce").getPolicyStatusCache().clear();
            PerforceUtil.changelistCreate(panel.getSelectedConnection(), (String)newChangelistNo.get(0));
            PerforceUtil.changelistModified(panel.getSelectedConnection(), this.getPerforceChangelist());
            return 0;
        }
        return 1;
    }

    private PerforceConnectionProfile getConnectionProfile(Context context) {
        Element[] elm = context.getSelection();
        if (elm.length == 0) {
            return null;
        }
        if (elm[0] instanceof ConnectionDetail) {
            return ((ConnectionDetail)elm[0]).getConnectionProfile();
        }
        return null;
    }

    private VCSRecentCommentsModel getRecentCommentsModel() {
        if (this._recentCommentsModel == null) {
            this._recentCommentsModel = new VCSRecentCommentsModel();
        }
        return this._recentCommentsModel;
    }
}

