/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.generic.util.VCSCompareCommand;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.history.PerforceContent;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

abstract class PerforceCompare
extends VCSCompareCommand {
    public PerforceCompare(String cmdId) {
        super(cmdId);
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, Locatable locatable, Object objectRevision) throws Exception {
        URL url = locatable.getURL();
        PerforceRevisionNumber revision = (PerforceRevisionNumber)objectRevision;
        String path = URLFileSystem.getPlatformPathName((URL)url);
        String resourceName = PerforceArb.format("DIFF_INTEGRATED_RESOURCE", revision.getHaveRevision(), path);
        PerforceContent content = new PerforceContent();
        if (VCSFileSystemUtils.isContentTypeBinary((URL)url)) {
            return new BinaryCompareContributor((InputStream)new ByteArrayInputStream(content.getVersionContent(url, revision.getHaveRevision())), URLFileSystem.getFileName((URL)url), resourceName, resourceName);
        }
        InputStreamTextContributor compareContributor = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(content.getVersionContent(url, revision.getHaveRevision())), resourceName, resourceName, URLFileSystem.getSuffix((URL)url));
        compareContributor.setPatchDescriptor(new PatchCompareDescriptor(URLFileSystem.getFileName((URL)url)));
        compareContributor.getPatchDescriptor().setPatchParentURL(URLFileSystem.getParent((URL)url));
        compareContributor.getPatchDescriptor().setRevision(revision.getHaveRevision());
        return compareContributor;
    }
}

