/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceAbstractCommand;
import oracle.jdevimpl.vcs.perforce2.cmd.custom.PerforceAddCustomizer;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceAddCommand
extends PerforceAbstractCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.add";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceAddCommand.class.getName());
    private String _changelistNo;

    public PerforceAddCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(final PerforceConnectionProfile connect, VCSProfile profile, CommandState commandState, Map options) {
        final PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("add");
        this._changelistNo = this.getChangeListNo(options);
        if (this._changelistNo != null) {
            cmd.add("-c");
            cmd.add(this._changelistNo);
        }
        cmd.add("-f");
        runner.setCmdList(cmd);
        runner.setQuiet(false);
        runner.setConnection(connect);
        return new PerforceDirectoryInvokable(commandState.getInvokableState(), 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                for (int i = 0; i < filenames.length; ++i) {
                    if (!URLFileSystem.isDirectory((URL)invokeUrls[i])) continue;
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                runner.setFiles(filenames2);
                runner.exec();
                if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                    sLogger.log(Level.WARNING, "Failed to add children of " + parent);
                    PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("ERROR_ADD_FAILED_TITLE"));
                    throw new PerforceProcessException(PerforceArb.get("ERROR_ADD_FAILED_TITLE"), PerforceArb.get("ERROR_ADD_FAILED"), runner.getErrorText());
                }
                if (runner.getOutputText().contains("can't add (already opened for delete)")) {
                    sLogger.log(Level.WARNING, runner.getOutputText());
                    throw new PerforceProcessException(PerforceArb.get("ERROR_ADD_FAILED_TITLE"), PerforceArb.get("ERROR_ADD_FAILED"), runner.getOutputText());
                }
                return true;
            }
        };
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(parent, PerforceArb.get("ADD_PROGRESS_TITLE"), (Object)PerforceArb.get("ADD_WATCHER_DESCRIPTION"), "", 0, -1);
        return monitor;
    }

    protected VCSOptionsCustomizer createOptionsCustomizer() {
        PerforceAddCustomizer customizer = new PerforceAddCustomizer(this.getConnectionProfileFromContext());
        return customizer;
    }

    private String getChangeListNo(Map options) {
        if (!options.isEmpty()) {
            return (String)options.get("open_on_changelist");
        }
        return null;
    }

    @Override
    protected String getPerforceChangelist() {
        return this._changelistNo;
    }
}

