/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.ProductInformation;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSTextFileUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotOpenedCache;
import oracle.jdevimpl.vcs.perforce2.PerforceExceptionHandler;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLoginCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.nav.RemoteItem;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public abstract class PerforceAbstractCommand
extends ActionCommand {
    private static final String PREFIX_TEMP_COMMENTS = ".jdevperforce_comments";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceAbstractCommand.class.getName());
    private static PerforceExceptionHandler _exceptionHandler;
    private static URLFilter _localFilter;
    protected static final int FILE_COMMAND_BATCH_SIZE = 10;

    protected PerforceAbstractCommand(String cmdId) {
        super(cmdId);
    }

    protected static URLFilter getLocalFilter() {
        return _localFilter;
    }

    protected VCSExceptionHandler getExceptionHandler() {
        if (_exceptionHandler == null) {
            _exceptionHandler = new PerforceExceptionHandler();
        }
        return _exceptionHandler;
    }

    protected boolean isNonEditable(URL url) {
        return VCSFileSystemUtils.isNonEditable((URL)url);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(commandState.getLocatables()[0].getURL());
        if (!PerforceSessionManager.getInstance().isConnected(connect)) {
            PerforceLoginCommand login = new PerforceLoginCommand();
            login.setConnectionProfile(connect);
            login.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
            login.setContext(Context.newIdeContext());
            CommandProcessor.getInstance().invoke((Command)login);
            if (!PerforceSessionManager.getInstance().isConnected(connect)) {
                return false;
            }
        }
        VCSDirectoryInvokable invokable = this.createDirectoryInvokable(connect, profile, commandState, options);
        invokable.setProgressMonitor(this.createProgressMonitor(parentUi));
        return invokable.runInvokable();
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(commandState.getLocatables()[0].getURL());
        VCSDirectoryInvokable invokable = this.createDirectoryInvokable(connect, profile, commandState, options);
        return invokable.runInvokable();
    }

    protected VCSDirectoryInvokable createDirectoryInvokable(PerforceConnectionProfile connect, VCSProfile profile, CommandState commandState, Map options) {
        return null;
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return null;
    }

    protected Collection coalesceNodesForFolderOperation(Collection nodes, boolean recursive) {
        LinkedHashMap<URL, Locatable> nodesByUrl = new LinkedHashMap<URL, Locatable>();
        for (Locatable node : nodes) {
            nodesByUrl.put(node.getURL(), node);
        }
        if (recursive) {
            nodesByUrl.keySet().retainAll(Arrays.asList(VCSFileSystemUtils.coalesceURLs((URL[])nodesByUrl.keySet().toArray(new URL[0]))));
        } else {
            this.retainURLsForLocalFolderOperation(nodesByUrl.keySet());
        }
        return new ArrayList(nodesByUrl.values());
    }

    protected final URL writeCommentsFile(String comments, Collection cmd) throws IOException {
        if (comments == null) {
            cmd.add("-nc");
            return null;
        }
        URL commentFile = URLFactory.newFileURL((File)File.createTempFile(PREFIX_TEMP_COMMENTS, null));
        VCSTextFileUtils.writeTextFile((URL)commentFile, (String)comments);
        cmd.add("-cfi");
        cmd.add(URLFileSystem.getPlatformPathName((URL)commentFile));
        return commentFile;
    }

    protected void syncFileToHead(PerforceConnectionProfile connect, URL parent, List files, VCSProfile profile) throws Exception {
        ArrayList<String> syncFiles = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            String file = (String)files.get(i);
            URL fileURL = URLFactory.newURL((URL)parent, (String)file);
            URLFilter headFilter = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.HEAD_REVISION");
            if (headFilter.accept(fileURL)) continue;
            syncFiles.add(file);
        }
        if (!syncFiles.isEmpty()) {
            PerforceShellRunner sync = new PerforceShellRunner();
            sync.setConnection(connect);
            sync.setCommand("sync");
            sync.setOptionDirURL(parent);
            sync.setFiles(syncFiles);
            sync.exec();
            if (sync.getExitCode() == null || sync.getExitCode() != 0) {
                PerforceUtil.isErrorConnection(sync, connect, PerforceArb.get("ERROR_SYNC_FAILED_TITLE"));
                throw new PerforceProcessException(PerforceArb.get("ERROR_SYNC_FAILED_TITLE"), PerforceArb.format("ERROR_SYNC_FAILED", ProductInformation.getProductInformation().getShortName()), sync.getErrorText());
            }
        }
    }

    protected void lock(PerforceConnectionProfile connect, URL parent, List files) throws Exception {
        PerforceShellRunner lock = new PerforceShellRunner();
        lock.setConnection(connect);
        lock.setCommand("lock");
        lock.setOptionDirURL(parent);
        lock.setQuiet(false);
        lock.setFiles(files);
        lock.exec();
        if (lock.getExitCode() == null || lock.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(lock, connect, PerforceArb.get("ERROR_LOCK_FAILED_TITLE"));
            throw new PerforceProcessException(PerforceArb.get("ERROR_LOCK_FAILED_TITLE"), PerforceArb.format("ERROR_LOCK_FAILED", ProductInformation.getProductInformation().getShortName()), lock.getErrorText());
        }
    }

    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(commandState.getLocatables()[0].getURL());
        if (this.getPerforceChangelist() != null && PerforceSessionManager.getInstance().isConnected(connect)) {
            PerforceUtil.changelistModified(connect, this.getPerforceChangelist());
        }
        PerforceDepotOpenedCache.getInstance().clear(connect);
        Collection processed = commandState.getInvokableState().getProcessedURLs();
        PerforceURLInfoCache.getInstance().clear(processed);
    }

    protected String getPerforceChangelist() {
        return null;
    }

    private void retainURLsForLocalFolderOperation(Collection urls) {
        Iterator itr = urls.iterator();
        while (itr.hasNext()) {
            URL url = (URL)itr.next();
            if (!urls.contains(URLFileSystem.getParent((URL)url))) continue;
            itr.remove();
        }
    }

    protected PerforceConnectionProfile getConnectionProfileFromContext() {
        Context context = this.getContext();
        PerforceConnectionProfile connect = null;
        if (context.getElement() instanceof RemoteItem) {
            return ((RemoteItem)context.getElement()).getConnectionProfile();
        }
        Locatable[] locatables = VCSContextUtils.getContextLocatables((Context)context);
        if (locatables.length > 0) {
            connect = PerforceConnectionManager.getInstance().getConnectionProfile(locatables[0].getURL());
        }
        return connect;
    }

    static {
        _localFilter = VCSContextUtils.createLocalProtocolFilter();
    }
}

