/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl.node;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.cl.PerforceCLURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLContainer;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLDetail;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistFileNode;
import oracle.jdevimpl.vcs.perforce2.error.PerforceOperationException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class ChangelistNoNode
implements CLContainer,
Locatable,
CLDetail {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(ChangelistNoNode.class.getName());
    private PerforceConnectionProfile _connect;
    private URL _url;
    private String _changelistNo;
    private String _label;
    private String _id;

    public ChangelistNoNode(PerforceConnectionProfile con, URL url, String changeListNo) {
        this._connect = con;
        this._url = url;
        this._changelistNo = changeListNo;
    }

    @Override
    public PerforceConnectionProfile getConnectionProfile() {
        return this._connect;
    }

    public String toString() {
        if (this._label == null) {
            try {
                if (!this._changelistNo.equals(PerforceUtil.getDefaultChangelist(this.getConnectionProfile()))) {
                    StringBuilder sb = new StringBuilder(PerforceArb.format("PENDING_CHANGELIST_LABEL", this._changelistNo));
                    String description = PerforceUtil.getName(this.getConnectionProfile(), this._changelistNo);
                    if (description.length() > 0) {
                        sb.append(" - ");
                        sb.append(description);
                    }
                    this._label = sb.toString();
                } else {
                    this._label = this._changelistNo;
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                sLogger.warning(e.getMessage());
            }
        }
        return this._label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getChildren() throws Exception {
        ArrayList<ChangelistFileNode> children;
        PerforceConnectionProfile connection = this.getConnectionProfile();
        String[] sp = connection.getServer().split(":");
        String host = connection.getHostName();
        int port = connection.getPortNumber();
        ArrayList<ChangelistFileNode> arrayList = children = new ArrayList<ChangelistFileNode>();
        synchronized (arrayList) {
            Collection<ChangeListFile> files;
            try {
                files = PerforceCommands.getOpenFilesOnChangelist(this.getConnectionProfile(), this._changelistNo);
            }
            catch (PerforceOperationException e) {
                throw new IOException(e.getMessage());
            }
            ArrayList<ChangeListFile> sorted = new ArrayList<ChangeListFile>(files);
            Collections.sort(sorted);
            for (ChangeListFile file : sorted) {
                URL url = URLFactory.newURL((String)PerforceCLURLFileSystemHelper.PERFORCE_CL_PROTOCOL, null, (String)host, (int)port, (String)file.getDepotFileNoRevisionNo(), null, null);
                children.add(new ChangelistFileNode(connection, url, file.getDepotFile(), file.getAction()));
            }
        }
        return children;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    @Override
    public String getChangelistNo() {
        return this._changelistNo;
    }

    @Override
    public String identifer() {
        if (this._id == null) {
            this._id = this._changelistNo + this._connect.toString();
        }
        return this._id;
    }
}

