/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl.cmd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistFileNode;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class MoveChangelistCommand
extends Command {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.movechangelist";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(MoveChangelistCommand.class.getName());
    private PerforceConnectionProfile _connect;

    public MoveChangelistCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    public int doit() {
        Collection<URL> clURL;
        Collection<String> oldChangelist;
        PerforceFstatResult[] fstat;
        Context context = this.getContext();
        Element[] elms = context.getSelection();
        final List<String> paths = this.getPaths(elms);
        if (elms[0].getData() instanceof ChangelistFileNode) {
            this._connect = ((ChangelistFileNode)elms[0].getData()).getConnectionProfile();
        }
        if (this._connect == null) {
            this._connect = PerforceConnectionManager.getInstance().getConnectionProfile(((Locatable)elms[0]).getURL());
        }
        final MoveChangelistPanel panel = new MoveChangelistPanel();
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultComponent(), (String)PerforceArb.get("MOVE_FILE_CHANGELIST_TITLE"));
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_pfcmovechangelist_html");
        try {
            fstat = PerforceGetStatus.fstat(this._connect, paths);
            oldChangelist = this.getUniqueChangelist(fstat);
            clURL = this.getClientURLs(fstat);
        }
        catch (VCSException e) {
            PerforceProfile.getErrorHandler().handleException((Exception)((Object)e));
            return 1;
        }
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    try {
                        String changelistno = panel.getChangelist();
                        if (oldChangelist.size() == 1 && oldChangelist.contains(changelistno)) {
                            MessageDialog.information((Component)panel, (Object)PerforceArb.get("CHANGELIST_SAME_MESSAGE"), (String)PerforceArb.get("CHANGELIST_SAME_TITLE"), null);
                            throw new PropertyVetoException(PerforceArb.get("CHANGELIST_SAME_MESSAGE"), evt);
                        }
                        for (PerforceFstatResult rst : fstat) {
                            if (paths.contains(rst.getMovedFile())) continue;
                            paths.add(rst.getMovedFile());
                        }
                        MoveChangelistCommand.this.moveToChangelist(MoveChangelistCommand.this._connect, changelistno, paths);
                    }
                    catch (PerforceProcessException e) {
                        PerforceProfile.getErrorHandler().handleException((Exception)((Object)e));
                        throw new PropertyVetoException("", evt);
                    }
                }
            }
        });
        if (dialog.runDialog()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        MoveChangelistCommand.this.postMove(MoveChangelistCommand.this._connect, panel.getChangelist(), clURL, oldChangelist);
                    }
                    catch (Exception e) {
                        sLogger.warning("failed to move files to new changelist ");
                    }
                }
            });
            return 0;
        }
        return 1;
    }

    private void postMove(PerforceConnectionProfile connect, String changelistno, Collection<URL> url, Collection<String> oldChangelist) throws Exception {
        Iterator<String> it = oldChangelist.iterator();
        while (it.hasNext()) {
            PerforceUtil.changelistModified(connect, it.next());
        }
        PerforceUtil.changelistModified(connect, changelistno);
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        profile.getPolicyStatusCache().clear(url.toArray(new URL[0]));
    }

    private boolean moveToChangelist(PerforceConnectionProfile connect, String changelistno, List<String> paths) throws PerforceProcessException {
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(connect);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("reopen");
        cmds.add("-c");
        cmds.add(changelistno);
        runner.setFiles(paths);
        runner.setCmdList(cmds);
        try {
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to move file(s) to changelist " + changelistno);
            throw new PerforceProcessException(PerforceArb.get("MOVE_ERROR_TITLE"), PerforceArb.format("MOVE_ERROR_MESSAGE", changelistno), e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            sLogger.log(Level.WARNING, "Failed to move file(s) to changelist " + changelistno);
            throw new PerforceProcessException(PerforceArb.get("MOVE_ERROR_TITLE"), PerforceArb.get("MOVE_ERROR_MESSAGE"), runner.getErrorText());
        }
        return true;
    }

    private List<String> getPaths(Element[] elms) {
        ArrayList<String> paths = new ArrayList<String>(elms.length);
        for (Element elm : elms) {
            URL url = ((Locatable)elm).getURL();
            paths.add(url.getPath());
        }
        return paths;
    }

    private Collection<URL> getClientURLs(PerforceFstatResult[] fstats) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (PerforceFstatResult fstat : fstats) {
            if (fstat.getClientFile() == null) continue;
            urls.add(URLFactory.newFileURL((String)fstat.getClientFile()));
        }
        return urls;
    }

    private Collection<String> getUniqueChangelist(PerforceFstatResult[] fstat) {
        HashSet<String> changelists = new HashSet<String>();
        for (PerforceFstatResult fs : fstat) {
            changelists.add(fs.getChangelist());
        }
        return changelists;
    }

    private class ChangelistTableModel
    extends DefaultTableModel {
        private List<String> _data;

        ChangelistTableModel() {
        }

        String getChangelistAt(int row) {
            String data = this._data.get(row);
            String[] parts = data.split("-");
            return parts[0].trim();
        }

        @Override
        public int getRowCount() {
            if (this._data == null) {
                this.populate();
            }
            return this._data.size();
        }

        @Override
        public String getColumnName(int column) {
            return PerforceArb.get("CHANGELIST_TABLE_COLUMN");
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this._data == null) {
                this.populate();
            }
            return this._data.get(rowIndex);
        }

        private void populate() {
            try {
                Collection<String> changelist = PerforceUtil.getChangelistNo(MoveChangelistCommand.this._connect);
                ArrayList<String> sortLst = new ArrayList<String>(changelist.size());
                sortLst.addAll(changelist);
                Collections.sort(sortLst);
                this._data = new ArrayList<String>();
                this._data.add(PerforceUtil.getDefaultChangelist(MoveChangelistCommand.this._connect));
                Iterator it = sortLst.iterator();
                while (it.hasNext()) {
                    this._data.add(PerforceUtil.getLongLabel(MoveChangelistCommand.this._connect, (String)it.next()));
                }
            }
            catch (Exception e) {
                sLogger.warning(e.getMessage());
            }
        }
    }

    private class MoveChangelistPanel
    extends JPanel {
        private JLabel lblChangelist = new JLabel();
        private JTable tblChangelist;

        MoveChangelistPanel() {
            this.tblChangelist = new JTable(new ChangelistTableModel());
            this.tblChangelist.setSelectionMode(0);
            this.init();
        }

        private void init() {
            Insets ins = new Insets(2, 5, 3, 5);
            ResourceUtils.resLabel((JLabel)this.lblChangelist, (Component)this.tblChangelist, (String)PerforceArb.get("MOVE_FILE_CHANGELIST_LABEL"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.lblChangelist, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
            this.add((Component)new JScrollPane(this.tblChangelist), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
            this.setPreferredSize(new Dimension(200, 300));
        }

        Component getDefaultComponent() {
            return this.tblChangelist;
        }

        String getChangelist() {
            int row = this.tblChangelist.getSelectedRow();
            String changelistno = ((ChangelistTableModel)this.tblChangelist.getModel()).getChangelistAt(row);
            return changelistno;
        }
    }
}

