/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;

public class PerforceURLInfoCache {
    private static PerforceURLInfoCache _instance = new PerforceURLInfoCache();
    private Map<String, PerforceRevisionNumber> cache = new HashMap<String, PerforceRevisionNumber>();
    private Map<String, String> _cacheCList = new HashMap<String, String>();

    private PerforceURLInfoCache() {
    }

    public static PerforceURLInfoCache getInstance() {
        return _instance;
    }

    public synchronized void putRevisionInfo(URL url, PerforceRevisionNumber info) {
        this.cache.put(url.getPath(), info);
    }

    public synchronized void putChangeList(URL url, String changeList) {
        this._cacheCList.put(url.getPath(), changeList);
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(Collection<URL> urls) {
        for (URL url : urls) {
            this.cache.remove(url);
        }
    }

    public void clear(URL[] urls) {
        for (URL url : urls) {
            this.cache.remove(url);
        }
    }

    public PerforceRevisionNumber getRevisionInfo(URL url) {
        return this.cache.get(url.getPath());
    }

    public String getChangeList(URL url) {
        return this._cacheCList.get(url.getPath());
    }

    public void clearChangelist(URL[] urls) {
        for (URL url : urls) {
            this._cacheCList.remove(url.getPath());
        }
    }
}

