/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.perforce2.ConnectionEvent;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.connection.PerforceConnectionHelper;

public class PerforceConnectionManager {
    public static final String PRESET_DEPOT_SERVER = "depotServer";
    private static PerforceConnectionHelper _helper = new PerforceConnectionHelper();
    private static final PerforceConnectionManager sInstance = new PerforceConnectionManager();
    private Collection<PerforceConnectionProfile> _connections;
    private Collection<PerforceConnectionListener> _listeners = new ArrayList<PerforceConnectionListener>();

    public static PerforceConnectionManager getInstance() {
        return sInstance;
    }

    private PerforceConnectionManager() {
    }

    public void addConnectionListener(PerforceConnectionListener cl) {
        if (!this._listeners.contains(cl)) {
            this._listeners.add(cl);
        }
    }

    public void removeConnectionListener(PerforceConnectionListener cl) {
        if (this._listeners.contains(cl)) {
            this._listeners.add(cl);
        }
    }

    public void addConnection(PerforceConnectionProfile connect) throws Exception {
        this.getConnections();
        if (!this._connections.contains(connect)) {
            this._connections.add(connect);
            this.connectionAdded(connect);
        }
        _helper.setPersistedProfiles(this._connections);
    }

    public boolean hasConnections() {
        return _helper.hasConnection();
    }

    public synchronized Collection<PerforceConnectionProfile> list() throws Exception {
        if (this._connections == null) {
            this._connections = new ArrayList<PerforceConnectionProfile>();
            this._connections.addAll(_helper.getPersistedProfiles());
        }
        return this._connections;
    }

    public void removeConnection(PerforceConnectionProfile con) {
        if (this._connections.contains(con)) {
            this._connections.remove(con);
            _helper.setPersistedProfiles(this._connections);
            this.connectionDeleted(con);
        }
    }

    private Collection<PerforceConnectionProfile> getConnections() throws Exception {
        this.list();
        return this._connections;
    }

    public PerforceConnectionProfile getConnectionProfile(URL url) {
        Collection<PerforceConnectionProfile> cons;
        try {
            cons = this.list();
        }
        catch (Exception e) {
            return null;
        }
        for (PerforceConnectionProfile con : cons) {
            URL cURL = PerforceSessionManager.getInstance().getClientRootFolder(con);
            if (cURL == null || !URLFileSystem.isBaseURLFor((URL)cURL, (URL)url)) continue;
            return con;
        }
        return null;
    }

    private void connectionAdded(PerforceConnectionProfile connect) {
        Iterator<PerforceConnectionListener> it = this._listeners.iterator();
        ConnectionEvent ce = new ConnectionEvent(connect);
        while (it.hasNext()) {
            it.next().connectionCreated(ce);
        }
    }

    private void connectionDeleted(PerforceConnectionProfile connect) {
        Iterator<PerforceConnectionListener> it = this._listeners.iterator();
        ConnectionEvent ce = new ConnectionEvent(connect);
        while (it.hasNext()) {
            it.next().connectionDeleted(ce);
        }
    }

    public boolean hasConnectionDetails(PerforceConnectionProfile connection) {
        return connection.getClient() != null && connection.getUser() != null;
    }
}

