/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.vcs.generic.CheckOutProvider;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSProgress;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceDepotOpenedCache;
import oracle.jdevimpl.vcs.perforce2.PerforceDirectoryInvokable;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceCheckOutProvider
extends CheckOutProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOut(URL[] urls, final VCSProgress progress) throws Exception {
        PerforceConnectionProfile connect = PerforceConnectionManager.getInstance().getConnectionProfile(urls[0]);
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
        final PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(connect);
        runner.setCommand("edit");
        runner.setQuiet(false);
        VCSDirectoryInvokableState state = new VCSDirectoryInvokableState(urls);
        PerforceDirectoryInvokable invokable = new PerforceDirectoryInvokable(state, 10){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = PerforceUtil.getURLFileNamesAndConvertToAscii(invokeUrls);
                ArrayList<String> filenames2 = new ArrayList<String>(Arrays.asList(filenames));
                for (int i = 0; i < filenames.length; ++i) {
                    if (!URLFileSystem.isDirectory((URL)invokeUrls[i])) continue;
                    filenames2.remove(filenames[i]);
                }
                if (filenames2.size() <= 0) {
                    return true;
                }
                runner.setOptionDirURL(parent);
                runner.setFiles(filenames2);
                runner.exec();
                progress.incrementProgress(invokeUrls.length);
                return runner.getExitCode() != null && runner.getExitCode() == 0;
            }
        };
        try {
            boolean bl = invokable.runInvokable();
            return bl;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            profile.getPolicyStatusCache().clear(state.getProcessedURLs().toArray(new URL[0]));
            PerforceDepotOpenedCache.getInstance().clear(connect);
        }
    }
}

