/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistEvent;
import oracle.jdevimpl.vcs.perforce2.PerforceChangelistListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;

public class PerforceChangeListName {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceChangeListName.class.getName());
    private final Map<String, String> _changes = new HashMap<String, String>();
    private boolean _populated = false;
    private PerforceConnectionProfile _connect;
    private static String DEFAULT_CHANGELIIST = "default";
    private Collection<PerforceChangelistListener> _listener = new ArrayList<PerforceChangelistListener>();

    public PerforceChangeListName(PerforceConnectionProfile connect) {
        this._connect = connect;
    }

    public String getName(String changeNo) {
        this.populate();
        return this._changes.get(changeNo);
    }

    public void clear() {
        this._populated = false;
        this._changes.clear();
    }

    public Collection<String> getChangelistNo() {
        this.populate();
        return this._changes.keySet();
    }

    public String getLongLabelName(String changelistNo) {
        String name = this.getName(changelistNo);
        if (name != null && name.length() > 0) {
            StringBuilder sb = new StringBuilder(changelistNo);
            sb.append(" - ");
            sb.append(name);
            return sb.toString();
        }
        return changelistNo;
    }

    public String getChangelistNo(String longlabel) {
        String[] changelist = longlabel.split("-");
        return changelist[0].trim();
    }

    public Collection getFromServerChangelistNo() {
        this.clear();
        return this.getChangelistNo();
    }

    public void addListener(PerforceChangelistListener cl) {
        if (!this._listener.contains(cl)) {
            this._listener.add(cl);
        }
    }

    public void removeListener(PerforceChangelistListener cl) {
        if (this._listener.contains(cl)) {
            this._listener.remove(cl);
        }
    }

    public void changelistCreate(PerforceConnectionProfile connect, String changelistNo) {
        this.clear();
        if (!this._listener.isEmpty()) {
            PerforceChangelistEvent cle = new PerforceChangelistEvent(changelistNo, connect);
            for (PerforceChangelistListener cl : this._listener) {
                cl.changelistCreated(cle);
            }
        }
    }

    public void changelistSubmitted(PerforceConnectionProfile connect, String changelistNo) {
        this.clear();
        if (!this._listener.isEmpty()) {
            PerforceChangelistEvent cle = new PerforceChangelistEvent(changelistNo, connect);
            for (PerforceChangelistListener cl : this._listener) {
                cl.changelistSubmitted(cle);
            }
        }
    }

    public void changelistModified(PerforceConnectionProfile connect, String changelistno) {
        if (!this._listener.isEmpty()) {
            PerforceChangelistEvent cle = new PerforceChangelistEvent(changelistno, connect);
            for (PerforceChangelistListener cl : this._listener) {
                cl.changelistModified(cle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() {
        if (this._populated) {
            return;
        }
        Map<String, String> map = this._changes;
        synchronized (map) {
            PerforceShellRunner runner = new PerforceShellRunner();
            ArrayList<String> cmds = new ArrayList<String>();
            ChangeListMonitor monitor = new ChangeListMonitor();
            cmds.add("changes");
            cmds.add("-c");
            cmds.add(this._connect.getClient());
            cmds.add("-s");
            cmds.add("pending");
            runner.setConnection(this._connect);
            runner.setCmdList(cmds);
            runner.addOutputMonitor(monitor);
            runner.setQuiet(true);
            try {
                runner.exec();
                if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                    sLogger.log(Level.WARNING, " Failed to get pending change list information" + runner.getErrorText());
                }
            }
            catch (Exception ex) {
                sLogger.log(Level.WARNING, " Failed to get pending change list information");
            }
            this._populated = true;
        }
    }

    public static String getDefaultChangelist() {
        return DEFAULT_CHANGELIIST;
    }

    private class ChangeListMonitor
    extends VCSStreamMonitor {
        private ChangeListMonitor() {
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            String[] sections = line.split(" ");
            if (sections.length >= 8) {
                int en;
                int st = line.indexOf("'");
                en = st == (en = line.lastIndexOf("'")) ? line.length() - 1 : --en;
                if (++st >= en) {
                    PerforceChangeListName.this._changes.put(sections[1], "");
                } else {
                    PerforceChangeListName.this._changes.put(sections[1], line.substring(st, en));
                }
            }
        }
    }
}

