/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.shape.composite;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.diagram.framework.graphic.FrameworkCompositeGraphic;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubSelectableShape;
import oracle.diagram.framework.shape.SubShape;
import oracle.diagram.framework.transformer.TransformerUtil;

public class SubSelectableCompositeGraphic
extends FrameworkCompositeGraphic
implements SubSelectableShape {
    private final List<IlvGraphic> _selectedSubShapes = new ArrayList<IlvGraphic>();
    private final transient Map<IlvGraphic, IlvSelection> _selections = new HashMap<IlvGraphic, IlvSelection>();

    public SubSelectableCompositeGraphic(IlvInputStream stream) throws IlvReadFileException {
        super(stream);
    }

    public SubSelectableCompositeGraphic() {
    }

    @Override
    public boolean ensureSubShapeIsVisible(IlvGraphic graphic) {
        return true;
    }

    @Override
    public boolean hasSelectedSubShapes() {
        return !this._selectedSubShapes.isEmpty();
    }

    @Override
    public boolean isSubShapeSelected(IlvGraphic graphic) {
        return this._selectedSubShapes.contains(graphic);
    }

    @Override
    public void selectSubShape(IlvGraphic graphic) {
        if (!this.isSubShapeSelected(graphic)) {
            this._selectedSubShapes.add(graphic);
            this._selections.put(graphic, graphic.makeSelection());
        }
    }

    @Override
    public void deselectSubShape(IlvGraphic graphic) {
        this._selectedSubShapes.remove(graphic);
        this._selections.remove(graphic);
    }

    @Override
    public void clearSubShapeSelection() {
        this._selectedSubShapes.clear();
        this._selections.clear();
    }

    @Override
    public boolean canSelectSubShapeRange(IlvGraphic startGraphic, IlvGraphic endGraphic) {
        return false;
    }

    @Override
    public void selectSubShapeRange(IlvGraphic startGraphic, IlvGraphic endGraphic) {
    }

    @Override
    public void addSelectedSubShapesToList(List<IlvGraphic> list) {
        list.addAll(this._selectedSubShapes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawSelectedSubShapes(Graphics dst, IlvTransformer t) {
        Graphics2D g2 = (Graphics2D)dst;
        Shape restoreClip = g2.getClip();
        Area clipArea = new Area((Shape)this.boundingBox());
        IlvGraphic ancestor = ManagerUtil.getManagedAncestor((IlvGraphic)this);
        if (ancestor != null) {
            int i;
            IlvManager mgr = ManagerUtil.getManager(ancestor);
            int layerIndex = mgr.getLayer(ancestor);
            mgr = ManagerUtil.getTransformingManager(ancestor);
            IlvManager topManager = ManagerUtil.getTopManager(ancestor);
            for (i = layerIndex + 1; i < topManager.getLayersCount(); ++i) {
                IlvManagerLayer layer = topManager.getManagerLayer(i);
                if (!layer.isVisible()) continue;
                IlvGraphicEnumeration graphics = layer.getElements();
                while (graphics.hasMoreElements()) {
                    IlvGraphic g = graphics.nextElement();
                    if (!g.isVisible()) continue;
                    IlvTransformer t1 = ManagerUtil.getConversionTransformer(topManager, mgr);
                    IlvRect r = g.boundingBox();
                    t1.inverse(r);
                    clipArea.subtract(new Area((Shape)r));
                }
            }
            clipArea = TransformerUtil.getApplied(t, clipArea);
            for (i = 0; i < this._selectedSubShapes.size(); ++i) {
                IlvGraphic subShape = this._selectedSubShapes.get(i);
                IlvSelection selection = this._selections.get(subShape);
                if (selection == null) continue;
                IlvRect clipRect = this.boundingBox();
                IlvGraphicBag bag = subShape.getGraphicBag();
                while (bag != null && bag instanceof IlvGraphic && bag != this) {
                    IlvGraphic g = (IlvGraphic)bag;
                    clipRect.intersection(g.boundingBox());
                    bag = g.getGraphicBag();
                }
                Area area = TransformerUtil.getApplied(t, (Shape)clipRect);
                area.intersect(clipArea);
                area.intersect(new Area(restoreClip));
                try {
                    g2.setClip(area);
                    selection.draw(dst, t);
                    continue;
                }
                finally {
                    g2.setClip(restoreClip);
                }
            }
        }
    }

    @Override
    public IlvSelection getSelection(IlvGraphic graphic) {
        return this._selections.get(graphic);
    }

    @Override
    public IlvGraphic getSubShape(IlvPoint point, IlvManagerView view) {
        IlvTransformer tx = ManagerUtil.getTransformingManager((IlvGraphic)this).getDrawingTransformer(view);
        return this.getSubShape(point, tx);
    }

    @Override
    public IlvGraphic getSubShape(IlvPoint point, IlvTransformer t) {
        return this.getSubShapeImpl(point, t);
    }

    protected IlvGraphic getSubShapeImpl(IlvPoint point, IlvTransformer tx) {
        IlvPoint p = new IlvPoint(point);
        tx.inverse(p);
        boolean skip = this.shouldIgnoreFirstChild(this);
        IlvGraphic[] children = this.getChildren();
        for (int childNumber = children.length - 1; childNumber >= (skip ? 1 : 0); --childNumber) {
            IlvGraphic tmp;
            IlvGraphic child = children[childNumber];
            if (!child.isVisible() || !child.contains(p, point, tx)) continue;
            if (child instanceof SubSelectableShape && (tmp = ((SubSelectableShape)child).getSubShape(point, tx)) != null) {
                return tmp;
            }
            if (!SubSelectionManager.isSelectable(child) && (!(child instanceof SubShape) || !((SubShape)child).isEditable())) continue;
            return child;
        }
        return null;
    }

    protected boolean shouldIgnoreFirstChild(IlvCompositeGraphic c) {
        return c.getResizingPolicy() == 1;
    }
}

