/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.print;

import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.interactor.IlvDragRectangleInteractor;
import ilog.views.interactor.RectangleDraggedEvent;
import ilog.views.interactor.RectangleDraggedListener;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.AutoscrollInteractorMarker;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.print.PrintPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;

public class PrintAreaInteractor
extends IlvDragRectangleInteractor
implements AutoscrollInteractorMarker {
    private MyTransformerListener _transformerListener;
    private MouseEvent _lastDragEvent;

    public PrintAreaInteractor() {
        super.setRotationAllowed(true);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.addRectangleDraggedListener(new RectangleDraggedListener(){

            public void rectangleDragged(RectangleDraggedEvent ev) {
                PrintAreaInteractor.this.setPrintArea(ev.getRectangle());
                IlvManagerView view = PrintAreaInteractor.this.getManagerView();
                if (view != null && view.getInteractor() == PrintAreaInteractor.this) {
                    view.popInteractor();
                }
            }
        });
    }

    protected void setPrintArea(IlvRect r) {
        PrintPlugin pp = PluginUtil.getPlugin(this.getManagerView(), PrintPlugin.class);
        if (pp != null && r.width != 0.0f && r.height != 0.0f) {
            if (!ReadOnlyUtil.checkWritable(DiagramContext.getDiagramContext(this.getManagerView()))) {
                return;
            }
            pp.setPrintArea(r);
        }
    }

    protected void attach(IlvManagerView view) {
        super.attach(view);
        this._transformerListener = new MyTransformerListener();
        view.addTransformerListener((TransformerListener)this._transformerListener);
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener((TransformerListener)this._transformerListener);
        this._transformerListener = null;
        this._lastDragEvent = null;
        super.detach();
    }

    protected void processMouseMotionEvent(MouseEvent event) {
        boolean allowEnsureVisible = this.allowEnsureVisible();
        this.allowEnsureVisible(false);
        if (event.getID() == 506) {
            this._lastDragEvent = event;
        }
        super.processMouseMotionEvent(event);
        this.allowEnsureVisible(allowEnsureVisible);
    }

    public boolean isOpaqueMode() {
        return true;
    }

    public void setRotationAllowed(boolean allowed) {
    }

    private class MyTransformerListener
    implements TransformerListener {
        private MyTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (PrintAreaInteractor.this._lastDragEvent != null && PrintAreaInteractor.this.getManagerView().getInteractor() == PrintAreaInteractor.this) {
                final MouseEvent event = new MouseEvent(PrintAreaInteractor.this._lastDragEvent.getComponent(), 506, System.currentTimeMillis(), PrintAreaInteractor.this._lastDragEvent.getModifiers(), PrintAreaInteractor.this._lastDragEvent.getX(), PrintAreaInteractor.this._lastDragEvent.getY(), PrintAreaInteractor.this._lastDragEvent.getClickCount(), false, PrintAreaInteractor.this._lastDragEvent.getButton());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PrintAreaInteractor.this.processEvent(event);
                    }
                });
            }
        }
    }
}

