/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.inspector.PropertyModel;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.framework.inspector.CompositePropertyModel;
import oracle.diagram.framework.inspector.InspectorElementInspectable;
import oracle.diagram.framework.inspector.ProxyPropertyModel;
import oracle.ide.Context;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class InspectorElement
implements Element,
Subject {
    protected static final PropertyModel[] EMPTY_MODELS;
    private final Observer _obs = new MyObserver();
    private final Attributes _attributes = new ElementAttributes();
    private final List<Observer> _observers = new ArrayList<Observer>();
    private final DiagramContext _context;
    private int _adjusting = 0;

    public InspectorElement(DiagramContext context) {
        this._context = context;
    }

    public void beginInspection() {
    }

    public void endInspection() {
    }

    public Context getContext() {
        return this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
    }

    public final DiagramContext getDiagramContext() {
        return this._context;
    }

    public final PropertyModel createPropertyModel() {
        Context context = this.getContext();
        Collection<PropertyModel> models = this.createComponentPropertyModels(context);
        return this.createPropertyModelImpl(models != null && models.size() != 0 ? models.toArray(new PropertyModel[models.size()]) : EMPTY_MODELS);
    }

    protected PropertyModel createPropertyModelImpl(PropertyModel[] models) {
        if (models != null && models.length > 0) {
            if (models.length == 1) {
                return new DiagramProxyPropertyModel(models[0]);
            }
            return new DiagramCompositePropertyModel(this.getShortLabel(), models);
        }
        return null;
    }

    public final boolean mayHaveChildren() {
        return false;
    }

    public final Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public final Object getData() {
        return this;
    }

    public abstract String getShortLabel();

    public final String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return null;
    }

    public final String getToolTipText() {
        return this.getShortLabel();
    }

    public void attach(Observer observer) {
        this._observers.add(observer);
    }

    public void detach(Observer observer) {
        this._observers.remove(observer);
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        if (!this._observers.isEmpty()) {
            Observer[] obs;
            for (Observer o : obs = this._observers.toArray(new Observer[this._observers.size()])) {
                try {
                    o.update(subject, change);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected abstract Collection<PropertyModel> createComponentPropertyModels(Context var1);

    protected final void setAdjusting(boolean adjusting) {
        this._adjusting += adjusting ? 1 : -1;
    }

    protected final boolean isAdjusting() {
        return this._adjusting != 0;
    }

    protected final Observer getObserver() {
        return this._obs;
    }

    static {
        InspectorFactory.getInstance().registerInspectable(InspectorElement.class, InspectorElementInspectable.class);
        EMPTY_MODELS = new PropertyModel[0];
    }

    private class MyObserver
    implements Observer {
        private MyObserver() {
        }

        public void update(Object observed, UpdateMessage change) {
            if (!InspectorElement.this.isAdjusting()) {
                InspectorElement.this.notifyObservers(InspectorElement.this, change);
            }
        }
    }

    public class DiagramCompositePropertyModel
    extends CompositePropertyModel {
        public DiagramCompositePropertyModel(String name, PropertyModel[] models) {
            super(name != null && name.length() > 0 ? name : null, models);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object data, int row, int column) {
            try {
                InspectorElement.this.setAdjusting(true);
                super.setValueAt(data, row, column);
            }
            finally {
                InspectorElement.this.setAdjusting(false);
            }
        }
    }

    public class DiagramProxyPropertyModel
    extends ProxyPropertyModel {
        public DiagramProxyPropertyModel(PropertyModel delegate) {
            super(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValueAt(Object data, int row, int column) {
            try {
                InspectorElement.this.setAdjusting(true);
                super.setValueAt(data, row, column);
            }
            finally {
                InspectorElement.this.setAdjusting(false);
            }
        }

        public Enumeration getPropertyIDs() {
            Enumeration e = super.getPropertyIDs();
            if (e == null) {
                e = new Enumeration(){

                    @Override
                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        return null;
                    }
                };
            }
            return e;
        }
    }
}

